/************************************************************************
* FILE:         tun_VdClockClient.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner server
*----------------------------------------------------------------------
*
* DESCRIPTION: FC_TmcTuner registers as client to SPM
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author               | Modification
* 11.11.16  | RBEI/ECO11 gds5kor   | initial version
*************************************************************************/

#ifndef TUN_VDCLOCK_CLIENT_H
#define TUN_VDCLOCK_CLIENT_H

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "tun_Class_ForwardDecl.h"
#include "AMFMTuner/clHDImageMemoryManagement.h"

/*
 * Include clock interface files
 */
 #ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
 
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_DBGVISITORS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_STDVISITORS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_SERVICEINFO
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_TYPES
#define CLOCK_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "clock_fi_if.h"

#endif

class clConfigInterface;


/*------------------------------------*/
/* class tun_tclVdClockClient definition  */
/*------------------------------------*/
class tun_tclVdClockClient : public ahl_tclBaseWork
{
private:

	// Pointer to class tuner_tclApp.
	tuner_tclApp*   poGWMain;
	clConfigInterface* 	m_poclConfigInterface;
    clHDStationLogoManagement* m_poclHDStationLogoManagement;

     // Store the RegID of the registered service
   tU16  m_u16SrvRegID;

   tBool m_fFidClockReg;

   /*---------------------------------------------------------------------*/

   // Function to register for required service
   tVoid fRegisterForService();

   /*---------------------------------------------------------------------*/

   // Function to unregister for required service
   tVoid fUnregisterForService();

   /*---------------------------------------------------------------------*/

   // Function to register for FID (upreg)
   tBool fRegisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/

   // Function to unregister for FID (relupreg)
   tBool fUnregisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/

protected:
  /*---------------------------------------------------------------------*/
     // Function to handle unknown messages
   virtual tVoid vOnUnknownMessage
                  (
                  amt_tclBaseMessage* poMessage
                  );

  /*---------------------------------------------------------------------*/

public:

//Functions to set the pointers to other classes

	tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);


    // constructor
     tun_tclVdClockClient (tuner_tclApp* poMain, clHDStationLogoManagement *poclHDStationLogoManagement);
    tun_tclVdClockClient();//default constructor is added to remove lint warning
    tVoid vHandleClock(amt_tclServiceData* poMessage);
	
	// Function to get acknowledgement for registered service
   tVoid vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,
				tU16 u16ServiceId,
				tU16 u16SourceSubID);

   /*---------------------------------------------------------------------*/

   // destructor
   virtual ~tun_tclVdClockClient();

#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
	// Get the Data from AMT
	 virtual  tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData ) const;
#endif

   /*---------------------------------------------------------------------*/

   // Function to handle new app state
   tVoid vOnNewAppState
      (
      tU32 u32OldAppState,
      tU32 u32AppState
      );

   /*---------------------------------------------------------------------*/

   // Function to handle the service state changes
   tVoid vOnServiceState
      (
      tU16 u16ServiceId,
      tU16 u16ServerId,
      tU16 u16RegisterId,
      tU8  u8ServiceState,
      tU16 u16SubId
      );
#ifdef VARIANT_S_FTR_ENABLE_VDCLOCK
   DECLARE_MSG_MAP(tun_tclVdClockClient)
#endif
};

#endif //TUN_VDCLOCK_CLIENT_H
