#ifndef TUN_SINGLETON_H
#define TUN_SINGLETON_H
/************************************************************************
* FILE:         tun_Singleton.h
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Singleton pattern.
*              
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date       | Author                 | Modification
* --.--.2012 | CM-AI/PJ-VW34 Loss     | initial version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


/*****************************************************************************
 * 
 ****************************************************************************/
template <typename C>
class TUN_Singleton {
 public:
    static C* instance ()
    {
        if (!_instance) {
            _instance = new C;
        }
        return _instance;
    }
    virtual
    ~TUN_Singleton ()
    {
       _instance = 0;
    }
 private:
    //lint -esym(1704, DAB_Singleton*::DAB_Singleton*) prio3 constructor has private access specification
    TUN_Singleton(const TUN_Singleton<C>&);	
    TUN_Singleton& operator=(const TUN_Singleton<C>&);
    static C* _instance;
 protected:
    TUN_Singleton () { }
 };


template <typename C> C* TUN_Singleton <C>::_instance = 0;


#endif /* #ifndef TUN_SINGLETON_H */
/*** END OF FILE *************************************************************/
