/************************************************************************
* FILE:         tun_SensorClient.h
* PROJECT:      g3g
* SW-COMPONENT: Tuner server
*----------------------------------------------------------------------
*
* DESCRIPTION: FC_TmcTuner registers as client to SPM
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author               | Modification
* 11.11.16  | RBEI/ECO11 gds5kor   | initial version
*************************************************************************/

#ifndef TUN_SENSOR_CLIENT_H
#define TUN_SENSOR_CLIENT_H

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "tun_Class_ForwardDecl.h"
#include "TunerApp/clTmcTuner_stationLogo_map.h"

/*
 * Include sensor interface files
 */
 

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_DBGVISITORS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_STDVISITORS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_FI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_SERVICEINFO
#include "sensor_fi_if.h"

class clConfigInterface;
class clTmcTuner_Property_G_GET_STATIC_LIST;

/*------------------------------------*/
/* class tun_tclSensorClient definition  */
/*------------------------------------*/
class tun_tclSensorClient : public ahl_tclBaseWork
{
private:

	// Pointer to class tuner_tclApp.
	tuner_tclApp*   poGWMain;
	clConfigInterface* 	m_poclConfigInterface;
	clTmcTuner_stationLogo_map* m_poclTmcTuner_stationLogo_map;
	clTmcTuner_Property_G_GET_STATIC_LIST* m_poclTmcTuner_Property_G_GET_STATIC_LIST;

     // Store the RegID of the registered service
   tU16  m_u16SrvRegID;

   tBool m_fFidPositionReg;
   tun_MsgFromHMI* m_potun_MsgFromHMI;
   /*---------------------------------------------------------------------*/

   // Function to register for required service
   tVoid fRegisterForService();

   /*---------------------------------------------------------------------*/

   // Function to unregister for required service
   tVoid fUnregisterForService();

   /*---------------------------------------------------------------------*/

   // Function to register for FID (upreg)
   tBool fRegisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/

   // Function to unregister for FID (relupreg)
   tBool fUnregisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/
   tBool blFirstValidPositionStatusRx;
protected:
  /*---------------------------------------------------------------------*/
     // Function to handle unknown messages
   virtual tVoid vOnUnknownMessage
                  (
                  amt_tclBaseMessage* poMessage
                  );

  /*---------------------------------------------------------------------*/

public:

//Functions to set the pointers to other classes

	tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
	tVoid vSet_tun_MsgFromHMI_ptr(tun_MsgFromHMI* potun_MsgFromHMI);

    // constructor
     tun_tclSensorClient (tuner_tclApp* poMain, clTmcTuner_stationLogo_map *poclTmcTuner_stationLogo_map);
    tun_tclSensorClient();//default constructor is added to remove lint warning
    tVoid vHandleSensorStatus(amt_tclServiceData* poMessage);
	
	// Function to get acknowledgement for registered service
   tVoid vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,
				tU16 u16ServiceId,
				tU16 u16SourceSubID);

   /*---------------------------------------------------------------------*/

   // destructor
   virtual ~tun_tclSensorClient();

	// Get the Data from AMT
	 virtual  tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData ) const;

   /*---------------------------------------------------------------------*/

   // Function to handle new app state
   tVoid vOnNewAppState
      (
      tU32 u32OldAppState,
      tU32 u32AppState
      );

   /*---------------------------------------------------------------------*/

   // Function to handle the service state changes
   tVoid vOnServiceState
      (
      tU16 u16ServiceId,
      tU16 u16ServerId,
      tU16 u16RegisterId,
      tU8  u8ServiceState,
      tU16 u16SubId
      );
   void vSet_clTmcTuner_Property_G_GET_STATIC_LIST_Ptr( clTmcTuner_Property_G_GET_STATIC_LIST* poclTmcTuner_Property_G_GET_STATIC_LIST );
   DECLARE_MSG_MAP(tun_tclSensorClient)
};

#endif //TUN_SENSOR_CLIENT_H
