/************************************************************************
* FILE:           tun_RUIF_WaitingThread.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Wating thread, waits for events.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 03.02.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef TUN_RUIF_WAITINGTHREAD_H
#define TUN_RUIF_WAITINGTHREAD_H

#include "tun_Class_ForwardDecl.h"



//class tun_IPNInterface;




/*----------------------------------------------*/
/*  class tun_RUIF_WaitingThread definition     */
/*----------------------------------------------*/

class tun_RUIF_WaitingThread
{
public: 
  /*----------------*/
  /* Constructor    */
  /*----------------*/
  tun_RUIF_WaitingThread(  );

  /*----------------*/
  /* Destructor     */
  /*----------------*/
  ~tun_RUIF_WaitingThread( );

  OSAL_tEventHandle           _hEvTuner;
  OSAL_tIODescriptor          _fdTrace;

  static OSAL_tTimerHandle    _hTxTimer; 


  tBool bThreadSetup( );
  static tVoid vSetTxTimeOut(tU8 u8MsTimeout);

  //static OSAL_tpfThreadEntry vInputThread(tVoid *pvArg);
  static tVoid vInputThread(tVoid *pvArg);
   
  static OSAL_tpfCallback vGetTxTimeout(const tVoid* pArg); 
  tVoid vHandleReceivedMessage( );
  tVoid vHandleConfirmation( tVoid) const;

  tVoid vHandleReceivedEvents(tU16 u16Event);
  tVoid vPostEventToSelf( ) const;


  static OSAL_tSemHandle     m_hMsgRUIFWaitingThreadSem;

  /*----------------*/
  /* Tuner Manager  */
  /*----------------*/   
  tu_Manager* m_potu_Manager;

  /*-------------------------------------*/
  /* Tuner RU message Dispatcher class   */
  /*-------------------------------------*/
  tun_MsgDispatcher* m_potun_MsgDispatcher;


  tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );
  tVoid vSet_tun_MsgDispatcher_Ptr( tun_MsgDispatcher* potun_MsgDispatcher );
  



  /*-------------------------*/
  /* ID of the active thread */
  /*-------------------------*/
  OSAL_tThreadID       _hInputThreadId;  

  /*------------------------*/
  /* terminates thread loop */
  /*------------------------*/
  tBool                _bTerminate;   


};



#endif /* TUN_RUIF_WAITINGTHREAD_H */
