/************************************************************************
* FILE:           tun_PrjConfig_rnaivi.h
* PROJECT:       g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner component, Project specific configuration.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 20.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/
#ifndef TUN_PRJCONFIG_RNAIVI_H
#define TUN_PRJCONFIG_RNAIVI_H


/*============================================================================
 * Default values for missing KDS
 *--------------------------------------------------------------------------*/
#define TUN_CONFIG_DEFAULT_TUNER_MASTER              0x03
#define TUN_CONFIG_DEFAULT_TUNER_AREA                enTunerArea_Europe;


/*==========================================================================
 * Stage 1:
 * Tuning behaviour (not audio tuner dependent):
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_NUM_OF_SEEK_PERIODS            1  // s
#define TUN_CONFIG_DEFAULT_SCAN_TIME                      10  // s
#define TUN_CONFIG_DEFAULT_PTY_FILTER_FOR_SEEK            0xffffffff
//#define TUN_CONFIG_DEFAULT_AF_BEST_DELAY_TIME_AFTER_SEEK 10  // s
#define TUN_CONFIG_DEFAULT_TP_SEEK_STRATEGY               0
#define TUN_CONFIG_DEFAULT_AUTO_SEEK_STEP_DELAY           50  // ms
#define TUN_CONFIG_DEFAULT_PEMANENT_MANUAL_STEP_DELAY     50  // ms
//#define TUN_CONFIG_DEFAULT_WRONG_PI_ACCEPT_DELAY        10  // s
#define TUN_CONFIG_TUNNINGBEHAVIOUR_SWITCHES			  0x02 // bit 0:- CM_AtPiSearch disabled , bit 1: CM_AtPiSearch enabled , 2-7 reserved
#define TUN_CONFIG_DEFAULT_MUTE_RAMP_1					  0x1000
#define TUN_CONFIG_DEFAULT_DEMUTE_RAMP_1                  0x1000
#define TUN_CONFIG_DEFAULT_MUTE_RAMP_2                    0x1000
#define TUN_CONFIG_DEFAULT_DEMUTE_RAMP_2                  0x1000

/*==========================================================================
 * Stage 2:
 * Behaviour of  ATstation info auto notification (not audio tuner dependent):
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_ATSTATIONINFO_SWITCHES 0x0c

/*==========================================================================
* Stage 3:
* Timer Configuration (not audio tuner dependent):
*------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_TIMERSCANRADIO		            10				
#define TUN_CONFIG_DEFAULT_TIMERINHIBITLSTSORTAFTERSKIP		10
#define TUN_CONFIG_DEFAULT_TIMERDELAYTPSTNSELAFTERVOL0      120
#define TUN_CONFIG_DEFAULT_TIMERDELAYNOTPSTNFOUND           120
#define TUN_CONFIG_DEFAULT_TIMERNONRDS_DETECT				1
#define TUN_CONFIG_DEFAULT_TIMERPS_DELAFTERRDSLOST			120
#define TUN_CONFIG_DEFAULT_TIMERWRONGPIACCEPT				0xfe //defination for infinite
#define TUN_CONFIG_DEFAULT_TIMERSCROLLPSDETECT				7
#define TUN_CONFIG_DEFAULT_TIMERDELAYTPSTNSELAFTERRDSLOST	30
#define TUN_CONFIG_DEFAULT_TIMERTAENDAFTERRDSLOST			120
#define TUN_CONFIG_DEFAULT_TIMERAM_MINTUNTIME				30
#define TUN_CONFIG_DEFAULT_TIMERCURSORDELAYAFTERSTNSEL		3
#define TUN_CONFIG_DEFAULT_TIMERAF_INHIBITAFTERMANTUNE		10
#define TUN_CONFIG_DEFAULT_TIMERPTY_HOLD					0xfe //defination for infinite

/*==========================================================================
 * Stage 4:
 * Parameters that influence the reception behaviour (not audio tuner dependent):
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_FM_RDS					20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_FM_RDS					0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_FM_NONRDS				20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_FM_NONRDS				0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_LW						20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_LW						0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_MW						20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_MW						0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_SW						20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_SW						0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_TRF						20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_TRF						0x0f
#define TUN_CONFIG_DEFAULT_FS_SEEKLEVEL_WB						20
#define TUN_CONFIG_DEFAULT_Q_SEEKLEVEL_WB						0x0f

#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_FM_RDS					20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_FM_RDS					0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_FM_NONRDS				20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_FM_NONRDS				0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_LW						20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_LW						0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_MW						20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_MW						0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_SW						20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_SW						0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_TRF						20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_TRF						0x0f
#define TUN_CONFIG_DEFAULT_FS_LISTLEVEL_WB						20
#define TUN_CONFIG_DEFAULT_Q_LISTLEVEL_WB						0x0f

#define TUN_CONFIG_DEFAULT_SHARX                     0x00
#define TUN_CONFIG_DEFAULT_HICUT                     0x77

/*==========================================================================
 * Stage 5:
 * Area setup for CONFIG area (no CONFIG arear needed) (not audio tuner dependent):
 *------------------------------------------------------------------------*/

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#define TUN_CONFIG_DEFAULT_AVAILABLE_BANDS           0x00000005
#define TUN_CONFIG_DEFAULT_COMBI_BANDS           0x80000004
#else
#define TUN_CONFIG_DEFAULT_AVAILABLE_BANDS           0x00000005
#define TUN_CONFIG_DEFAULT_COMBI_BANDS				 0x00000000
#endif
/** FM */
#define TUN_CONFIG_DEFAULT_LOW_FM                    87500   // kHz;
#define TUN_CONFIG_DEFAULT_HIGH_FM                   108000  // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_FM              100     // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_MANUAL_FM       100     // kHz
#define TUN_CONFIG_DEFAULT_FM_LSM                    87500  // kHz
/** LW */
#define TUN_CONFIG_DEFAULT_LOW_LW                    0xAAAAAAAA   // kHz;
#define TUN_CONFIG_DEFAULT_HIGH_LW                   0xAAAAAAAA   // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_LW              0xAA		  // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_MANUAL_LW       0xAA		  // kHz
#define TUN_CONFIG_DEFAULT_LW_LSM                    0xAAAAAAAA   // kHz
/** MW */
#define TUN_CONFIG_DEFAULT_LOW_MW                    531     // kHz
#define TUN_CONFIG_DEFAULT_HIGH_MW                   1602    // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_MW              9       // kHz
#define TUN_CONFIG_DEFAULT_STEP_SIZE_MANUAL_MW       9       // kHz
#define TUN_CONFIG_DEFAULT_MW_LSM                    531     // kHz

/*==========================================================================
 * Stage 6:
 * User settings (audio tuner dependent):
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_ADR_SWITCHES1             0x01
#define TUN_CONFIG_DEFAULT_ADR_SWITCHES2             0x31
#define TUN_CONFIG_DEFAULT_ADR_SWITCHES3             0x0

#define TUN_CONFIG_DEFAULT_PTY31_1				 1
#define TUN_CONFIG_DEFAULT_PTY31_2				 0
#define TUN_CONFIG_DEFAULT_DDS_1 				 1
#define TUN_CONFIG_DEFAULT_DDS_2 				 1
#define TUN_CONFIG_DEFAULT_DMQ_1			     1
#define TUN_CONFIG_DEFAULT_DMQ_2			     1


/*==========================================================================
 * Stage 7:
 * HF Parameter (not physical tuner dependent):
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_FM_CHANNEL_SEPARATION     1
#define TUN_CONFIG_DEFAULT_FM_LIMITING               1
#define TUN_CONFIG_DEFAULT_FM_MULTIPATH              1
#define TUN_CONFIG_DEFAULT_FM_SOFTMUTE               1
#define TUN_CONFIG_DEFAULT_AM_SOFTMUTE               1
#define TUN_CONFIG_DEFAULT_FM_HIGHCUT                1
#define TUN_CONFIG_DEFAULT_AM_HICUT_CONFIGURATION    0x01
#define TUN_CONFIG_DEFAULT_FM_DEEMPHASIS             1
#define TUN_CONFIG_DEFAULT_AM_DEEMPHASIS             0x01
#define TUN_CONFIG_DEFAULT_FM_FREQUENCY_RESPONSE     1
#define TUN_CONFIG_DEFAULT_AM_FREQUENCY_RESPONSE     1
#define TUN_CONFIG_DEFAULT_FM_MISC                   1
#define TUN_CONFIG_DEFAULT_AM_MISC                   1
#define TUN_CONFIG_DEFAULT_FM_AMPLIFICATION_LEVEL    0
#define TUN_CONFIG_DEFAULT_AM_AMPLIFICATION_LEVEL    0
#define TUN_CONFIG_DEFAULT_ANTENNA_CONFIG_ID         0
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#define TUN_CONFIG_DEFAULT_AMFMMISC2             1
#endif

/*==========================================================================
 * Stage 8:
 * RDS Parameter
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_PHYSICAL_TUNER_CONFIG_ID  enFmDabHdTunerMode_reserved_0x00
#define TUN_CONFIG_DEFAULT_EXCHANGE_ANTENNA_LEVEL    20      // dBuV
#define TUN_CONFIG_DEFAULT_PITEST_LEVEL              20      // dBuV
#define TUN_CONFIG_DEFAULT_NRDS_LEVEL                36      // dBuV
#define TUN_CONFIG_DEFAULT_EON_LEVEL                 36      // dBuV
#define TUN_CONFIG_DEFAULT_FM_MEMO_LEVEL             20      // dBuV
#define TUN_CONFIG_DEFAULT_PANIC_FIELDST_LEVEL       16      // dBuV
#define TUN_CONFIG_DEFAULT_PARAM_RDS_LEVEL           31      // dBuV
#define TUN_CONFIG_DEFAULT_RDS_DATA_ACCEPT_LEVEL     15      // dBuV
#define TUN_CONFIG_DEFAULT_PI_STEP_LEVEL             20      // dBuV
#define TUN_CONFIG_DEFAULT_DDA_ANTENNA_DIST_LEVEL     4
#define TUN_CONFIG_DEFAULT_RDS_SYN_DELAY_CNT          3
#define TUN_CONFIG_DEFAULT_MP_MEASURE_LEVEL          20
#define TUN_CONFIG_DEFAULT_MP_LEVEL2_LEVEL           18
#define TUN_CONFIG_DEFAULT_MP_VERY_BAD_LEVEL         32
#define TUN_CONFIG_DEFAULT_MP_MEDIUM_LEVEL           18
#define TUN_CONFIG_DEFAULT_RDS_BAD_LEVEL            128
#define TUN_CONFIG_DEFAULT_ILLEGAL_AF               206
#define TUN_CONFIG_DEFAULT_AF_SAVE_LEVEL             10
#define TUN_CONFIG_DEFAULT_FIRST_RUNDUM               2      // s
#define TUN_CONFIG_DEFAULT_SECOND_RUNDUM              4      // s
#define TUN_CONFIG_DEFAULT_THIRD_RUNDUM               12     // s
#define TUN_CONFIG_DEFAULT_PISTEP_MODE                0
#define TUN_CONFIG_DEFAULT_AUDIO_OFF_SCAN_MODE        0
#define TUN_CONFIG_DEFAULT_AM_LEARN_CYCLE             1
#define TUN_CONFIG_DEFAULT_PI_IGNORE                  0
//Byte 25 is made 50    PARAM_PI_SEARCH_TIME 
//Byte 26 is made to YES,   PARAM_DISBALE_SEAMLESS_BLENDING 
#define TUN_CONFIG_DEFAULT_FREE1                      50
#define TUN_CONFIG_DEFAULT_FREE2                      0
#define TUN_CONFIG_DEFAULT_SL_ADJ_THRESHOLD           52
#define TUN_CONFIG_DEFAULT_SL_MP_THRESHOLD            20
#define TUN_CONFIG_DEFAULT_SPECIAL_FM_START_FREQUENCY 0

/*==========================================================================
 * Stage 9:
 * Testmode and AF-List configuration:
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_TESTMODE_DATA_UPDATE_INT		25
#define TUN_CONFIG_DEFAULT_AFLIST_UPDATE_INT			50
#define TUN_CONFIG_DEFAULT_AFLIST_RELEASE_BEHAVIOUR		0

/*==========================================================================
 * Stage 10:
 * Station list configuration:
 *------------------------------------------------------------------------*/

#define TUN_CONFIG_DEFAULT_MAX_NO_STNS_IN_STATIONSLIST	0xff

 /*==========================================================================
  * Stage 11:
  * Preset list configuration (not audio tuner dependent):
  *------------------------------------------------------------------------*/
#define TUN_CONFIG_NUMBER_OF_PRESETS          18
  
  
#define TUN_CONFIG_DEFAULT_NO_FM_PRESET_BANKS         1
#define TUN_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK   12

/*DRM Preset Bank*/
#define TUN_CONFIG_DEFAULT_NO_DRM_PRESET_BANKS1        0
#define TUN_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK1  0
/** FM Preset List 1 */
#define TUN_CONFIG_DEFAULT_PRESET0                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET1                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET2                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET3                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET4                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET5                   104000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET6					 98300  // kHz
#define TUN_CONFIG_DEFAULT_PRESET7                   98300  // kHz
#define TUN_CONFIG_DEFAULT_PRESET8                   98300  // kHz
#define TUN_CONFIG_DEFAULT_PRESET9                   98300  // kHz
#define TUN_CONFIG_DEFAULT_PRESET10                  98300  // kHz
#define TUN_CONFIG_DEFAULT_PRESET11                  98300  // kHz
 
#define TUN_CONFIG_DEFAULT_NO_AM_PRESET_BANKS1        1
#define TUN_CONFIG_DEFAULT_NO_OF_AM_PRESET_PER_BANK1  6

/** AM Preset List 1 */
#define TUN_CONFIG_DEFAULT_PRESET12                   540  // kHz
#define TUN_CONFIG_DEFAULT_PRESET13                   540  // kHz
#define TUN_CONFIG_DEFAULT_PRESET14                   540  // kHz
#define TUN_CONFIG_DEFAULT_PRESET15                   540  // kHz
#define TUN_CONFIG_DEFAULT_PRESET16                   540  // kHz
#define TUN_CONFIG_DEFAULT_PRESET17                   540  // kHz

/** Config parameter defines ends */

#define TUN_CONFIG_DEFAULT_FEATURE_CONTROL_I         21
#define TUN_CONFIG_DEFAULT_FEATURE_CONTROL_II        1 

#define TUN_CONFIG_DEFAULT_RDS_LOST_TIMEOUT          120     // s
#define TUN_CONFIG_DEFAULT_BEHAVIOURAL_SWITCHES      0x00
#define TUN_CONFIG_DEFAULT_SEEKLEVEL_FM_RDS          15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_SEEKLEVEL_MW              15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_SEEKLEVEL_FM_NONRDS       15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_LISTLEVEL_FM_RDS          15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_LISTLEVEL_MW              15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_LISTLEVEL_FM_NONRDS       15      // dBuV or quality
#define TUN_CONFIG_DEFAULT_LEVEL_TYPE                enLevelType_quality
#define TUN_CONFIG_DEFAULT_SPECIAL_FEATURES          0xaa
#define DIA_TUNER_LANDSCAPESEEK_NEEDED                2
#define DIA_TUNER_FM_TMCSERVER						  1	

/*==========================================================================*/




/**============================= defines for KDS NEW AMFM PARAMETER SET =======================*/
  
#define TUN_CONFIG_DEFAULT_SHOWRADIOTEXT_STATUSMSG				0
#define TUN_CONFIG_DEFAULT_T_RADIOTEXT_NOTAVAILABLE				0
#define TUN_CONFIG_DEFAULT_T_TIMEOUT_STATUS_RT					0
#define TUN_CONFIG_DEFAULT_T_SHOWTEXTMIN						0
#define TUN_CONFIG_DEFAULT_T_MINDISPLAYDURATIONPER_RTPAGE		0
#define TUN_CONFIG_DEFAULT_RADIOTEXT_MINLENGTH					0	 
#define TUN_CONFIG_DEFAULT_RADIOTEXT_SPEEDTHRESHOLD				0
#define TUN_CONFIG_DEFAULT_RADIOTEXT_SPEEDTHRESHOLDHYSTERISIS	0


#define TUN_CONFIG_DEFAULT_EMERGENCYSEEKSCAN_NOOFSTNS			3
#define TUN_CONFIG_DEFAULT_SHOW_FREQDURING_FREQSCAN				0
#define TUN_CONFIG_DEFAULT_SEEKMODE								1

#define TUN_CONFIG_DEFAULT_AFBESTDELAY_TIMEAFTMANUALTUNING		0
#define TUN_CONFIG_DEFAULT_AFBEST_DISPLAYFREEZEAFTMANUALTUNING	0

#define TUN_CONFIG_DEFAULT_WRONGPIACCEPTDELAY_AFTSTNSEL			3
#define TUN_CONFIG_DEFAULT_WRONGPIACCEPT_AFTSTNLOST				3


#define TUN_CONFIG_DEFAULT_MULTIMANUALSTEPSWITH_INTERMEDIATEFREQ	0
#define TUN_CONFIG_DEFAULT_STATIONLIST								3 
#define TUN_CONFIG_DEFAULT_FMLISTSORTINGDEFAULT						3
#define TUN_CONFIG_DEFAULT_AMLISTSORTINGDEFAULT						3


#define TUN_CONFIG_DEFAULT_T_AM_MINTUNELISTREMOVE				30 
#define TUN_CONFIG_DEFAULT_T_AM_STNREMOVEAFTDESELECT			30 
#define TUN_CONFIG_DEFAULT_AMSTNLIST_UPDATESTRATEGY				1 

#define TUN_CONFIG_DEFAULT_AFLISTRESORT							0

#define TUN_CONFIG_DEFAULT_LANDSCAPEUPDATE_ONSHUTDOWN			3 
#define TUN_CONFIG_DEFAULT_TUNERSWITCHES						0

#define TUN_CONFIG_DEFAULT_ADR_SWITCHES4						0x0c

#define TUN_CONFIG_DEFAULT_FMSHARXLIMIT							0
#define TUN_CONFIG_DEFAULT_HWSUBCONFIG							0xFF


#define TUN_CONFIG_DEFAULT_FM2DAB_DELAY_TIME  					0x00

#define TUN_CONFIG_DEFAULT_AMFM_HICUT_EXTENDER								0x01		  
#define TUN_CONFIG_DEFAULT_FM_SOFTMUTE_TIMING								0x01
#define TUN_CONFIG_DEFAULT_AMFM_MISSCELLANEOUS_2							0x01
#define TUN_CONFIG_DEFAULT_FM_HICUT_EXTENDER_FIELDSTRENGTH_THRESHOLD		0x01  
#define TUN_CONFIG_DEFAULT_FM_HICUT_EXTENDER_FIELDSTRENGTH_FILTER_OFFSET	0x01  
#define TUN_CONFIG_DEFAULT_FM_CHANNEL_SEPERATION_MAXIMUM					0x01
#define TUN_CONFIG_DEFAULT_FM_CHANNEL_SEPERATION_TIMING						0x01
#define TUN_CONFIG_DEFAULT_FM_HICUT_FIELDSTRENGTH_THRESHOLD				    0x01
#define TUN_CONFIG_DEFAULT_FM_HICUT_TIMING									0x01
#define TUN_CONFIG_DEFAULT_FM_DMQ_SENSITIVITY								0x01
#define TUN_CONFIG_DEFAULT_FM_DEVIATION_ADAPTION							0x01
#define TUN_CONFIG_DEFAULT_AM_NOISE_BLANKER_228KHZ_SENSITIVITY				0x01
#define TUN_CONFIG_DEFAULT_AM_NOISE_BLANKER_45_6KHZ_SENSITIVITY				0x01
#define TUN_CONFIG_DEFAULT_AM_HICUT_EXTENDER_FIELDSTRENGTH_THRESHOLD		0x01  
#define TUN_CONFIG_DEFAULT_AM_HICUT_EXTENDER_FIELDSTRENGTH_FILTER_OFFSET	0x01

#define TUN_CONFIG_DEFAULT_DEMODULATION_SWITCH_AUDIO_TUNER_1	0x00  
#define TUN_CONFIG_DEFAULT_DEMODULATION_SWITCH_AUDIO_TUNER_2	0x00

#define TUN_CONFIG_DEFAULT_T_SPEEDTUNETRIGGER					250 
#define TUN_CONFIG_DEFAULT_N_SPEEDTUNETRIGGER					3
#define TUN_CONFIG_DEFAULT_N_SPEEDTUNEMULTIPLIER_FM				5
#define TUN_CONFIG_DEFAULT_N_SPEEDTUNEMULTIPLIER_AM				10
#define TUN_CONFIG_DEFAULT_NOOFPSCHANGES_FORSCROLLDETECT		3

/**============================= defines for KDS NEW AMFM PARAMETER SET Ends ==================*/



/**============================= defines for KDS NEW GENERIC PARAMETER SET =======================*/


#define TUN_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID						0x00000001
#define TUN_CONFIG_DEFAULT_AUTOSTORE_UNUSED_PRESET_PARAM				0x01
#define TUN_CONFIG_DEFAULT_INITIAL_AUTOSTORE_NO_OF_STATIONS				6 /** same as no of presets in each bank */
#define TUN_CONFIG_DEFAULT_USER_AUTOSTORE_NO_OF_STATIONS				6 /** same as no of presets in each bank */
#define TUN_CONFIG_DEFAULT_AUTOSTORE_SORTING_CRITERIA_FM				0x01
#define TUN_CONFIG_DEFAULT_AUTOSTORE_SORTING_CRITERIA_AM				0x01
#define TUN_CONFIG_DEFAULT_AUTOSTORE_SORTING_CRITERIA_DAB				0x01  
#define TUN_CONFIG_DEFAULT_AUTOSTORE_BEHAVIOURAL_SWITCHES				0x04
#define TUN_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE			0x10
#define TUN_CONFIG_DEFAULT_BANDTOTUNE_AFTR_USER_AUTOSTORE				0x01

#define TUN_CONFIG_DEFAULT_MUTEORATTENUATION_FORABSSTNCHNG_AMFM			0
#define TUN_CONFIG_DEFAULT_MUTEORATTENUATION_FORSEEK_AMFM				0
#define TUN_CONFIG_DEFAULT_MUTEORATTENUATION_FORMANUALTUNING_AMFM		0

#define TUN_CONFIG_DEFAULT_TIME_TO_RELEASE_ATTENUATION_AMFM				0
#define TUN_CONFIG_DEFAULT_TIME_TO_RELEASE_DAB_FMLINK					0
#define TUN_CONFIG_DEFAULT_TIME_TO_RELEASE_DABPLUS_FMLINK				0
#define TUN_CONFIG_DEFAULT_TIME_TO_RELEASE_DMBA_FMLINK					0
#define TUN_CONFIG_DEFAULT_LEVEL_COMPENSATION_FOR_STNLOAD				0

#define TUN_CONFIG_DEFAULT_MONITOR_FMTA									0x05
#define TUN_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK							0x01
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING						0x01


#define TUN_CONFIG_DEFAULT_BACKGROUNDFM_TA								1

#define TUN_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC						3

#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA						2
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31					1
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS					3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM					1

#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH		3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH			3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE		3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH		3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT			3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO			3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT			3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT		3

#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4				3
#define TUN_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5				3


#define TUN_CONFIG_DEFAULT_PRESETLISTTYPE					0

#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTFM				1

#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTMW				1

#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTLW				0
#define TUN_CONFIG_DEFAULT_NO_OFBANKSHMILW					0
#define TUN_CONFIG_DEFAULT_NO_OFPRESETPERBANKLW				0


/*DRM Preset Banks
 *Until ADR3 support DRM Presets, values are coded as 0 */

#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTDRM				0
#define TUN_CONFIG_DEFAULT_NO_DRM_PRESET_BANKS				0
#define TUN_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK		0
#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTDAB				0
#define TUN_CONFIG_DEFAULT_NO_OFBANKSHMIDAB					0
#define TUN_CONFIG_DEFAULT_NO_OFPRESETPERBANKDAB			0

#define TUN_CONFIG_DEFAULT_NO_OFPRESETLISTFOR_MIXEDALLBANDS				0
#define TUN_CONFIG_DEFAULT_NO_OFBANKSHMIFOR_MIXEDALLBANDS				0
#define TUN_CONFIG_DEFAULT_NO_OFPRESETPERBANKFOR_MIXEDALLBANDS			0


#define TUN_CONFIG_DEFAULT_PRESET18                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET19                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET20                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET21					  0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET22                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET23                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET24                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET25                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET26                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET27                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET28                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET29                   0x00000000  // kHz
#define TUN_CONFIG_DEFAULT_PRESET30                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET31                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET32                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET33                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET34                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET35                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET36                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET37                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET38                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET39                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET40                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET41                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET42                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET43                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET44                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET45                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET46                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET47                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET48                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET49                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET50                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET51                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET52                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET53                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET54                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET55                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET56                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET57                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET58                   0x00000000  // kHz unused
#define TUN_CONFIG_DEFAULT_PRESET59                   0x00000000  // kHz unused
/**============================= defines for KDS NEW GENERIC PARAMETER SET Ends ==================*/



/****************** HD Related Defines begins *********************************/

#define TUN_CONFIG_DEFAULT_HD_SCAN_EVERY_FREQ	      0

/* =========================================================================
* HD Radio Parameter Set
* =========================================================================*/

#define TUN_CONFIG_DEFAULT_HD_BLEND_THRESHOLD_FMHYBRID						0x03
#define TUN_CONFIG_DEFAULT_HD_DIGI_AUDIO_SCALING_FMHYBRID					0x9AB0
#define TUN_CONFIG_DEFAULT_HD_DIGI_AUDIO_DELAY_FMHYBRID_PRIMARY_BBRATE		0x208B
#define TUN_CONFIG_DEFAULT_HD_BLEND_RATE_FMHYBRID							0x03
#define TUN_CONFIG_DEFAULT_HD_BLEND_THRESHOLD_AMHYBRID						0x03
#define TUN_CONFIG_DEFAULT_HD_AM_MPS_AUDIO_SCALING							0x8020
#define TUN_CONFIG_DEFAULT_HD_AM_MPS_BLEND_RATE								0x03
#define TUN_CONFIG_DEFAULT_HD_DIGI_AUDIO_DELAY_AM_MPS_PRIMARY_BBRATE		0x06F7
#define TUN_CONFIG_DEFAULT_HD_DIGI_AUDIO_PHASEINVERSION						0x03
#define TUN_CONFIG_DEFAULT_HD_BLEND_DECISION								0x01				
#define TUN_CONFIG_DEFAULT_HD_FM_CDNO_BLEND_DECISION						0x3B
#define TUN_CONFIG_DEFAULT_HD_AM_CDNO_BLEND_DECISION						0x3A
#define TUN_CONFIG_DEFAULT_HD_FM_SPS_BLEND_THRESHOLD						0x04
#define TUN_CONFIG_DEFAULT_HD_FM_SPS_AUDIO_SCALING							0x9AB0
#define TUN_CONFIG_DEFAULT_HD_FM_SPS_BLEND_RATE								0x01
#define TUN_CONFIG_DEFAULT_HD_BALLGAME_MODE_AUDIO_OUTPUT					0x01
#define TUN_CONFIG_DEFAULT_HD_FILTERED_DSQM_TIME_CONSTANT					0x20
#define TUN_CONFIG_DEFAULT_HD_EZ_BLEND_ENABLE								0x01
#define TUN_CONFIG_DEFAULT_HD_DSQM_SEEK_THRESHOLD							0xF800
#define TUN_CONFIG_DEFAULT_HD_IMAGETYPE										0x01
#define TUN_CONFIG_DEFAULT_HD_PSD_FIELD_BITMASK								0xff
#define TUN_CONFIG_DEFAULT_HD_PSD_COMMENTS_BITMASK							0x07
#define TUN_CONFIG_DEFAULT_HD_PSD_COMMERCIAL_BITMASK						0x3f
#define TUN_CONFIG_DEFAULT_HD_PSD_UFID_BITMASK								0x00
#define TUN_CONFIG_DEFAULT_HD_TIMER1										0x00
#define TUN_CONFIG_DEFAULT_HD_TIMER2										0x00
#define TUN_CONFIG_DEFAULT_HD_TIMER3										0x00
#define TUN_CONFIG_DEFAULT_HD_TIMER4										0x00
#define TUN_CONFIG_DEFAULT_HD_TIMER5										0x00


/****************** HD Related Defines ends *********************************/

/****************** DRM TUNER PARAMETER SET *********************************/
#define TUN_CONFIG_DEFAULT_DRM_BAND_ENABLE									         	0x01
#define TUN_CONFIG_DEFAULT_DRM_MW_TUNNING_STEP_SIZE_FOR_SEARCH				         	0x01
#define TUN_CONFIG_DEFAULT_DRM_MW_TUNNING_STEP_SIZE_FOR_MANUAL_STEP						0x01
#define TUN_CONFIG_DEFAULT_DRM_SERVICE_FOLLOWING							            0x01
#define TUN_CONFIG_DEFAULT_DRM_DRM_AF_SEARCH_DELAY_TIME						            0x1E
#define TUN_CONFIG_DEFAULT_DRM_SERVICE_LIST_UNLEARN_TIME_THRESHOLD			      		0x0C
#define TUN_CONFIG_DEFAULT_DRM_SERVICE_LIST_LEARN_ACCEPTANCE_TIME			         	0x32
#define TUN_CONFIG_DEFAULT_DRM_SERVICE_LIST_LEARN_ACCEPTANCE_THRESHOLD					0x07
#define TUN_CONFIG_DEFAULT_DRM_QUALITY_THRESHOLD_FOR_AUDIO_MUTE				      		0x00
#define TUN_CONFIG_DEFAULT_DRM_AUDIO_ERROR_CONCEALMENT_LEVEL				            0x04
#define TUN_CONFIG_DEFAULT_DRM_SEEK_THRESHOLD                                           0x18 //int 24
#define TUN_CONFIG_DEFAULT_DRM_SWITCHES                                                 0x00

/****************** DRM TUNER PARAMETER SET ENDS ****************************/


#endif//TUN_PRJCONFIG_SUZUKI_H
/*** END OF FILE *************************************************************/
