/************************************************************************
* FILE:           tun_Msg_Types.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All defines required by Tuner interface are defined in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 19.08.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_MSG_TYPES_H
#define TUN_MSG_TYPES_H


/*------------------------------------------------------*/
/* Defines for Function ID: FID_TUN_S_AUDIO_FG_BG       */
/*------------------------------------------------------*/

enum T_e8_SubCommand {
  FI_EN_TUN_CHANGE_TO_FG = 0,
  FI_EN_TUN_CHANGE_TO_BG = 1
};


enum T_e8_AudioSink {
  FI_EN_TUN_USR1_CHANGE_TO_FG_BG = 0,
  FI_EN_TUN_TA_CHANGE_TO_FG_BG   = 1,
  FI_EN_TUN_TIM_CHANGE_TO_FG_BG  = 2,
  FI_EN_TUN_PTY_CHANGE_TO_FG_BG  = 3,
  FI_EN_TUN_NEWS_CHANGE_TO_FG_BG = 4
};

/*-----------------------------------------------------*/
/*-----------------------------------------------------*/



/*------------------------------------------------------*/
/* Defines for Function ID: FID_TUN_S_SEEK              */
/*------------------------------------------------------*/

enum T_e8_TunerSeek {
  FI_EN_TUN_SEEKTYPE_OFF = 0,
  FI_EN_TUN_SEEKTYPE_UP_AUTO = 1,
  FI_EN_TUN_SEEKTYPE_UP_SCAN_PRESET = 2,
  FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY = 3,
  FI_EN_TUN_SEEKTYPE_UP_CONTINOUS = 4,
  FI_EN_TUN_SEEKTYPE_UP_PRESET = 5,
  FI_EN_TUN_SEEKTYPE_UP_STATION_LIST = 6,
  FI_EN_TUN_SEEKTYPE_DOWN_AUTO = 7,
  FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PRESET = 8,
  FI_EN_TUN_SEEKTYPE_DOWN_SCAN_FREQUENCY = 9,
  FI_EN_TUN_SEEKTYPE_DOWN_CONTINOUS = 10,
  FI_EN_TUN_SEEKTYPE_DOWN_PRESET = 11,
  FI_EN_TUN_SEEKTYPE_DOWN_STATION_LIST = 12,
  FI_EN_TUN_SEEKTYPE_AUTOTP_UP = 13,
  FI_EN_TUN_SEEKTYPE_AUTOTP_DOWN = 14,
  FI_EN_TUN_PTY_UP = 15,
  FI_EN_TUN_PTY_DOWN = 16
};

enum T_e8_AudSink{
      FI_EN_BIT_USR1_SWITCHED_TUN_TOFG = 0x1UL,
      FI_EN_BIT_TA_SWITCHED_TUN_TOFG = 0x2UL,
      FI_EN_BIT_TIM_SWITCHED_TUN_TOFG = 0x4UL,
      FI_EN_BIT_PTY_SWITCHED_TUN_TOFG = 0x8UL,
      FI_EN_BIT_NEWS_SWITCHED_TUN_TOFG = 0x10UL,
      FI_EN_BIT_TEMPFM_SWITCHED_TUN_TOFG = 0x20UL,
      FI_EN_BIT_RESERVED = 0x40UL,
      FI_EN_BIT_RESERVED1 = 0x80UL
   };


/*-----------------------------------------------------*/
/*-----------------------------------------------------*/



/*------------------------------------------------------*/
/* Defines for Function ID:  FID_TUN_G_TUNER_DATA       */
/*------------------------------------------------------*/


enum T_e8_TunerBand {
  FI_EN_TUN_BAND_FM = 0,
  FI_EN_TUN_BAND_LW = 1,
  FI_EN_TUN_BAND_MW = 2,
  FI_EN_TUN_BAND_SW = 3,
  FI_EN_TUN_BAND_DCF77 = 4,
  FI_EN_TUN_BAND_TRAFFICBAND = 5,
  FI_EN_TUN_BAND_WEATHERBAND =6,
  FI_EN_TUN_BAND_CB1 = 20
};

enum T_e8_TunerAutostore {
  FI_EN_TUN_NO_AUTOSTORE = 0,
  FI_EN_TUN_AUTOSTORE_NORMAL = 1,
  FI_EN_TUN_AUTOSTORE_INITIAL = 2
};

enum T_e8_TunerMode {
  FI_EN_TUN_MODE_NORM = 0,
  FI_EN_TUN_MODE_BANDSCAN = 1,
  FI_EN_TUN_MODE_STATIC_LISTSCAN = 2,
  FI_EN_TUN_MODE_CONFIG_LISTSCAN = 3
};

enum T_e8_TunerState {
  FI_EN_TUN_STATE_PLAY = 0,
  FI_EN_TUN_STATE_SEEK = 1,
  FI_EN_TUN_STATE_STOP = 2
};


enum T_e8_TunerActType {
  FI_EN_TUN_ACTTYPE_NORM = 0,
  FI_EN_TUN_ACTTYPE_PERMANENT_MSTEP = 1,
  FI_EN_TUN_ACTTYPE_PERMANENT_SEEK = 2,
  FI_EN_TUN_ACTTYPE_TP_SEEK = 3,
  FI_EN_TUN_ACTTYPE_LEARN = 4,
  FI_EN_TUN_ACTTYPE_SEARCH = 5,
  FI_EN_TUN_ACTTYPE_INVALID = 6,
  FI_EN_TUN_ACTTYPE_TIM = 7
};

enum T_e8_Announcement {
  FI_EN_TUN_NO_ANNOUNCEMENT = 0,
  FI_EN_TUN_ANNOUNCEMENT_TA = 1,
  FI_EN_TUN_ANNOUNCEMENT_PTY = 2,
  FI_EN_TUN_ANNOUNCEMENT_PTY_31 = 3,
  FI_EN_TUN_ANNOUNCEMENT_NEWS = 4,
  FI_EN_TUN_ANNOUNCEMENT_TA_ACTIVE = 16,
  FI_EN_TUN_ANNOUNCEMENT_EON = 32
};


/*-----------------------------------------------------*/
/*-----------------------------------------------------*/





/*------------------------------------------------------*/
/* Defines for Function ID:  FID_TUN_G_TUNER_DATA       */
/*------------------------------------------------------*/

 enum T_e8_ManualFreqAdjustment {
  FI_EN_TUN_SEEK_DIRECTION_UP = 0,
  FI_EN_TUN_SEEK_DIRECTION_DOWN = 1
};


/*-----------------------------------------------------*/
/*-----------------------------------------------------*/









/*-----------------------------------------------------*/
/* Defines COMMAN to many Function IDs:                */
/*-----------------------------------------------------*/

/*-- Used in FIDs: FID_TUN_S_AUDIO_FG_BG | FID_TUN_S_SEEK | FID_TUN_S_SCAN_BAND  |
             FID_TUN_S_SET_STATIC_LIST   | FID_TUN_S_ATFREQUENCY                     -- */

enum T_e8_TunerResponseStatus {
  FI_EN_TUN_RES_REQ_SUCCEED = 0,
  FI_EN_TUN_RES_REQ_FAIL = 1,
  FI_EN_TUN_RES_PREV_REQ_INPROCESS = 2,
  FI_EN_TUN_RES_FUNCTIONALITY_CURRENTLY_NOT_SUPPORTED = 3,
  FI_EN_INVALID_TYPE = 255
};

enum T_e8_TunerResponseState {
  FI_EN_TUN_TUN_STATE_NORMAL = 1,
  FI_EN_TUN_STATE_DIAGNOSIS = 2,
  FI_EN_TUN_STATE_PAUSE = 3,
  FI_EN_TUN_STATE_OFF = 4
};

/*-------------------------------------------*/



/*-- Used in FIDs : FID_TUN_G_TUNER_DATA | FID_TUN_G_STATION_DATA --*/

enum T_e8_TunerHeader {
  FI_EN_TUN_FOREGROUND = 0,
  FI_EN_TUN_BACKGROUND = 1
};

/*-------------------------------------------*/

/*-- Used in FIDs: FID_TUN_G_TUNER_DATA | FID_TUN_G_STATIC_LIST_ELEMENT --*/
enum T_e8_StaticListID {
  FI_EN_TUN_TUN_STATIC_LIST_FM1 = 0,
  FI_EN_TUN_TUN_STATIC_LIST_FM2 = 1,
  FI_EN_TUN_TUN_STATIC_LIST_FM3 = 2,
  FI_EN_TUN_TUN_STATIC_LIST_AST = 3,
  FI_EN_TUN_TUN_STATIC_LIST_AM1 = 4,
  FI_EN_TUN_TUN_STATIC_LIST_LW1 = 5,
  FI_EN_TUN_TUN_STATIC_LIST_INVALID = 255
};

/*-----------------------------------------------------*/
/*-- Used in FID: FID_TUN_S_AUTOSTORE                --*/
/*-----------------------------------------------------*/

enum T_e8_Tun_ListID
{
    TUN_BANK_FM1 = 0,
    TUN_BANK_FM2 = 1,
    TUN_BANK_FM3 = 2,
    TUN_BANK_FM_AST = 3,
    TUN_BANK_AM_MW1 = 4,
    TUN_BANK_AM_MW2 = 5,
    TUN_BANK_AM_MW3 = 6,
    TUN_BANK_AM_MWAST = 7,
    TUN_BANK_AM_LW1 = 8,
    TUN_BANK_AM_LW2 = 9,
    TUN_BANK_AM_LW3 = 10,
    TUN_BANK_AM_LWAST = 11,
    TUN_BANK_AM_AST = 12,
   /* TUN_BANK_DAB1 = 11,
    TUN_BANK_DAB2 = 12,
    TUN_BANK_DAB3 = 13,
    TUN_BANK_DAB_AST = 14,*/
    TUN_BANK_MIX1 = 17,
    TUN_BANK_MIX2 = 18,
    TUN_BANK_MIX3 = 19,
    TUN_BANK_MIX_AST = 20,
	TUN_BANK_DRM1= 21,
	TUN_BANK_DRM_AST= 22,
    TUN_BANK_NONE = 254
};

/*-----------------------------------------------------*/
/*-- Used in FID: FID_TUN_S_SET_PI                  --*/
/*-----------------------------------------------------*/
enum T_e8_AbsOrRelType {
   FI_EN_TUN_PI_ABS = 0,
   FI_EN_TUN_PI_REL = 1,
   FI_EN_TUN_PI_NEXT_AVAIL = 2
};

/*-- Used in FID: FID_TUN_S_SET_PI                  --*/
enum T_e8_RelStepsType {
   FI_EN_TUN_PI_INC = 1,
   FI_EN_TUN_PI_DEC = 255
};

/*-- Used in FID: FID_TUN_S_SET_PI                  --*/
enum T_e8_DirectionType {
   FI_EN_TUN_PI_UP = 1,
   FI_EN_TUN_PI_DOWN = 255
};


/*-- Used in FID: FID_TUN_G_TUNER_SEEKMDOE         --*/
enum T_e8_SeekModeType {
   FI_EN_AUTO_SEEK = 0x0,
   FI_EN_MAN_SINGLE = 0x1,
   FI_EN_CONT_MANUAL = 0x2,
   FI_EN_TP_SEEK = 0x3,
   FI_EN_PTY = 0x4,
   FI_EN_INVALID = 0xff
};

enum T_e8_SeekOnOff {
   FI_EN_SEEK_OFF = 0x00,
   FI_EN_SEEK_ON = 0x01,
   FI_EN_SEEK_INVALID = 0xff
};

enum T_e8_ScanOnOff {
   FI_EN_NO_SCAN = 0x00,
   FI_EN_SCAN_ON = 0x01,
   FI_EN_SCAN_INVALID = 0xff
};

enum T_e8_AutostoreOnOff {
   FI_EN_NO_AUTOSTORE = 0x00,
   FI_EN_AUTOSTORE_ON = 0x01,
   FI_EN_AST_INVALID = 0xff
};

enum T_e8_TunerSeekMode {
   FI_EN_AUTOSTORE = 0x00,
   FI_EN_SCAN = 0x01,
   FI_EN_SEEK = 0x02,
   FI_EN_OFF_SEEK = 0x03,
   FI_EN_MODE_INVALID = 0xff
};

#define FI_EN_TUN_SEEKTYPE_MANSINGLE     0x17 


enum T_e8_AbsOrRelSharxType {
   FI_EN_TUN_SHARX_ABS = 0,
   FI_EN_TUN_SHARX_REL = 1
};

/*----------------------------------------------*/
/* Helper classes for BITFIELD ACCESS           */
/*----------------------------------------------*/




/*-------------------------------------------------------*/
/* T_b8_AudioSink used in FID: FID_TUN_G_AUDIO_FG_BG     */
/*-------------------------------------------------------*/

class midw_fi_tcl_b8_AudioSink 
{
public:
	 midw_fi_tcl_b8_AudioSink();//default constructor added for removing lint prio 3
   midw_fi_tcl_b8_AudioSink(tU8 u8_AudioSink):u8Value(u8_AudioSink) {}

   enum {
      FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG = 0x01,
      FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG = 0x02,
      FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG = 0x04,
      FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG = 0x08,
      FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG = 0x10,
      FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG = 0x20,
      FI_C_U8_BIT_RESERVED = 0x40,
      FI_C_U8_BIT_RESERVED1 = 0x80
   };
   tBool bUSR1_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bTA_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bTIM_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TIM_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bPTY_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bNEWS_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_NEWS_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bTEMPFM_SWITCHED_TUN_TOFG() const {return (u8Value & FI_C_U8_BIT_TEMPFM_SWITCHED_TUN_TOFG) != 0; }
   
   tBool bRESERVED() const {return (u8Value & FI_C_U8_BIT_RESERVED) != 0; }
   
   tBool bRESERVED1()  const {return (u8Value & FI_C_U8_BIT_RESERVED1) != 0; }
   
private:   
   
      tU8 u8Value;
     
   };



/*------------------------------------------------------------------------------*/
/* T_b32_AvailFlags used in FID: FID_TUN_G_TUNER_DATA, FID_TUN_G_STATION_DATA,  */
/* FID_TUN_G_STATIC_LIST_ELEMENT                                                */ 
/*------------------------------------------------------------------------------*/

class midw_fi_tcl_b32_AvailFlags 
{
public:
	 midw_fi_tcl_b32_AvailFlags();//default constructor added for removing lint prio 3
   midw_fi_tcl_b32_AvailFlags( tU32 u32_AvailFlags):u32Value(u32_AvailFlags) {}

   enum {
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE = 0x1UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE = 0x2UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE = 0x4UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE = 0x8UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE = 0x10UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_TMC_AVAILABLE = 0x20UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RDS_AVAILABLE = 0x40UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_REG_AVAILABLE = 0x80UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_AF_AVAILABLE = 0x100UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PTY_EON_AVAILABLE = 0x200UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE = 0x400UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_JAPAN_PS_AVAILABLE = 0x800UL,
      FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_AUTO_COMPARE_AVAILABLE = 0x1000UL
   };
   tBool bTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_PS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PS_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_PI_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PI_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_PTY_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PTY_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_CT_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_CT_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_TMC_AVAILABLE()  const{return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_TMC_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_RDS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RDS_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_REG_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_REG_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_AF_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_AF_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_PTY_EON_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_PTY_EON_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_RT_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_RT_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_JAPAN_PS_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_JAPAN_PS_AVAILABLE) != 0; }
   
   tBool bTUN_AVAILABLE_FLAGS_AUTO_COMPARE_AVAILABLE() const {return (u32Value & FI_C_U32_BIT_TUN_AVAILABLE_FLAGS_AUTO_COMPARE_AVAILABLE) != 0; }  
   
private: 
  
   tU32 u32Value; 
   
};



/*------------------------------------------------------------------------------------------------------*/
/* T_b32_Features used in FIDs: FID_TUN_G_TUNER_DATA | FID_TUN_G_SET_FEATURE | FID_TUN_S_SET_FEATURE    */
/*------------------------------------------------------------------------------------------------------*/

class midw_fi_tcl_b32_Features 
{
public:
	 midw_fi_tcl_b32_Features();//default constructor added for removing lint prio 3
   midw_fi_tcl_b32_Features(tU32 u32_Features):u32Value(u32_Features) {}

   enum {
      FI_C_U32_BIT_TUN_FEATURE_AF_MODE = 0x1UL,
      FI_C_U32_BIT_TUN_FEATURE_CT_MODE = 0x2UL,
      FI_C_U32_BIT_TUN_FEATURE_LOC_MODE = 0x4UL,
      FI_C_U32_BIT_TUN_FEATURE_UNUSED = 0x8UL,
      FI_C_U32_BIT_TUN_FEATURE_MONO_MODE = 0x10UL,
      FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE = 0x20UL,
      FI_C_U32_BIT_TUN_FEATURE_PTY_MODE = 0x40UL,
      FI_C_U32_BIT_TUN_FEATURE_REG_MODE = 0x80UL,
      FI_C_U32_BIT_TUN_FEATURE_RT_MODE = 0x100UL,
      FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE = 0x200UL,
      FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE = 0x400UL,
      FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE = 0x800UL,
      FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE = 0x1000UL,
      FI_C_U32_BIT_TUN_FEATURE_TA_MODE = 0x2000UL,
      FI_C_U32_BIT_TUN_FEATURE_TMC_MODE = 0x4000UL,
      FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE = 0x8000UL,
      FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE = 0x10000UL,
      FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE = 0x20000UL,
      FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE = 0x40000UL,
      FI_C_U32_BIT_TUN_FEATURE_RESERVED = 0x80000UL
   };
   tBool bTUN_FEATURE_AF_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_AF_MODE) != 0; }
   
   tBool bTUN_FEATURE_CT_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_CT_MODE) != 0; }
   
   tBool bTUN_FEATURE_LOC_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_LOC_MODE) != 0; }
   
   tBool bTUN_FEATURE_unused() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_UNUSED) != 0; }
   
   tBool bTUN_FEATURE_MONO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_MONO_MODE) != 0; }
   
   tBool bTUN_FEATURE_PSFIX_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PSFIX_MODE) != 0; }
   
   tBool bTUN_FEATURE_PTY_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_PTY_MODE) != 0; }
   
   tBool bTUN_FEATURE_REG_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_REG_MODE) != 0; }
   
   tBool bTUN_FEATURE_RT_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RT_MODE) != 0; }
   
   tBool bTUN_FEATURE_SEARCH_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SEARCH_MODE) != 0; }
   
   tBool bTUN_FEATURE_SEEK_SENSE_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SEEK_SENSE_MODE) != 0; }
   
   tBool bTUN_FEATURE_SHARX_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_SHARX_MODE) != 0; }
   
   tBool bTUN_FEATURE_TM_DATA_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_TM_DATA_MODE) != 0; }
   
   tBool bTUN_FEATURE_TA_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_TA_MODE) != 0; }
   
   tBool bTUN_FEATURE_TMC_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_TMC_MODE) != 0; }
   
   tBool bTUN_FEATURE_KHZ50_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_KHZ50_MODE) != 0; }
   
   tBool bTUN_FEATURE_REG_AUTO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_REG_AUTO_MODE) != 0; }
   
   tBool bTUN_FEATURE_NEWS_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_NEWS_MODE) != 0; }
   
   tBool bTUN_FEATURE_RDS_AUTO_MODE() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RDS_AUTO_MODE) != 0; }
   
   tBool bTUN_FEATURE_reserved() const {return (u32Value & FI_C_U32_BIT_TUN_FEATURE_RESERVED) != 0; }
   
  
private:  
  
    tU32 u32Value;
     
};

class midw_fi_tcl_e8_OperationFlags 
{
public:
	 midw_fi_tcl_e8_OperationFlags();//default constructor added for removing lint prio 3
   midw_fi_tcl_e8_OperationFlags(tU8 u8_operation):u8Value(u8_operation) {}

   enum {
      FI_C_U8_BIT_TUN_OPERATION_AFBEST = 0x1UL,
      FI_C_U8_BIT_TUN_OPERATION_PTY = 0x2UL,
      FI_C_U8_BIT_TUN_OPERATION_SEARCH = 0x4UL,
      FI_C_U8_BIT_TUN_OPERATION_TA = 0x8UL,
      FI_C_U8_BIT_TUN_OPERATION_TPSEEK = 0x10UL,
      FI_C_U8_BIT_TUN_OPERATION_ACTION = 0x20UL,
      FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC = 0x40UL,
      FI_C_U8_BIT_TUN_OPERATION_RESERVED = 0x80UL
   };
   tBool bTUN_OPERATION_AFBEST() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_AFBEST) != 0; }
   tBool bTUN_OPERATION_PTY() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_PTY) != 0; }
   tBool bTUN_OPERATION_SEARCH() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_SEARCH) != 0; }
   tBool bTUN_OPERATION_TA() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_TA) != 0; }
   tBool bTUN_OPERATION_TPSEEK() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_TPSEEK) != 0; }
   tBool bTUN_OPERATION_ACTION() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_ACTION) != 0; }
   tBool bTUN_OPERATION_SEEK_LEVEL_LOGIC() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_SEEK_LEVEL_LOGIC) != 0; }
   tBool bTUN_OPERATION_reserved() const {return (u8Value & FI_C_U8_BIT_TUN_OPERATION_RESERVED) != 0; }

private:  
  tU8 u8Value;
};

/* This is added for the Packed info of the Config list element data*/

class midw_fi_tcl_b8_PackedInfo 
{
public:
	 midw_fi_tcl_b8_PackedInfo();//default constructor added for removing lint prio 3
   midw_fi_tcl_b8_PackedInfo(tU8 u8_PackedInfo):u8Value(u8_PackedInfo) {}

   enum {
      FI_C_U8_BIT_TUN_TP = 0x1UL,
      FI_C_U8_BIT_TUN_TP_SELF = 0x2UL,
      FI_C_U8_BIT_TUN_PTY_DYNAMIC = 0x4UL,
      FI_C_U8_BIT_TUN_PS_DYNAMIC = 0x8UL,
      FI_C_U8_BIT_TUN_TMC_RESERVED = 0x10UL,
      FI_C_U8_BIT_TUN_TMC_YES = 0x20UL,
      FI_C_U8_BIT_TUN_TMC_NO = 0x40UL
   };

   tBool bTUN_TP_SELF() const {return (u8Value & FI_C_U8_BIT_TUN_TP_SELF) != 0; }

   tBool bTUN_PTY_DYNAMIC() const {return (u8Value & FI_C_U8_BIT_TUN_PTY_DYNAMIC) != 0; }

   tBool bTUN_PS_DYNAMIC() const {return (u8Value & FI_C_U8_BIT_TUN_PS_DYNAMIC) != 0; }

   tBool bTUN_TMC_reserved() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_RESERVED) != 0; }

   tBool bTUN_TMC_YES() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_YES) != 0; }

   tBool bTUN_TMC_NO() const {return (u8Value & FI_C_U8_BIT_TUN_TMC_NO) != 0; }

private:
   tU8 u8Value;


};

#endif
