/************************************************************************
* FILE:           tun_MsgToHMI.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages sent to HMI are handled in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 01.04.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_MSGTOHMI_H
#define TUN_MSGTOHMI_H

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"  
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#ifndef VARIANT_S_FTR_ENABLE_USE_MIDW_FI_INTERFACE
 #define FI_S_IMPORT_INTERFACE_FI_MESSAGE
 #include "midw_fi_if.h"
#endif
/*----------------------------------------------------------------------*/
#include "tun_MsgDefines.h"
#include "tun_Class_ForwardDecl.h"
#include "tun_Singleton.h"
#include "tun_defines.h"

#include "tun_MsgToADR.h"

/** vnd4kor: Store Command counter, Application Id and Registration ID for command*/
/** ------------------------------ */
/** struct MsgData definition	   */
/** ------------------------------ */
struct MsgData{
	tU16 u16AppID;
	tU16 u16RegID;
	tU16 u16CmdCounter;

	MsgData():u16AppID(0),u16RegID(0),u16CmdCounter(0)
	{
	}
};

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20  

#define INVALID_AUDIOPROGRAM	255
#define HDSTATIONINFOBITSTIMER	2000	//gds5kor: required to avoid grading out of SPS in HMI for tuning actions 2000 ms
#define FMHDDEMODULATION		0x02
#define AMHDDEMODULATION		0x04

/** vnd4kor: importing std map required for list id map */
#include <string>
#include <map>
#include <vector>

using namespace std;
/** vnd4kor: Store PSD information for audio Program*/


struct PSDCommentData
{
	midw_fi_tclString sLanguage,sShortContentDescription,sActualText;

	PSDCommentData():
			 sLanguage(NULL)\
			,sShortContentDescription(NULL)\
			,sActualText(NULL)
	{
	}

};

struct PSDUFIDData
{
	/*midw_fi_tclString sOwnerIdentifier;
	sIdentifier;

	PSDUFIDData():
			 sOwnerIdentifier(NULL)\
			,sIdentifier(NULL)
	{
	}*/
	std::vector<tU8> oOwnerIdentifier,oIdentifier;

	PSDUFIDData()			 
	{
	}

};

struct PSDCommercialData
{
	midw_fi_tclString sPriceString,sValidUntil,sContactURL,sReceivedAs\
		,sNameOfSeller,sDescription;

	PSDCommercialData():
			 sPriceString(NULL),sValidUntil(NULL),sContactURL(NULL)\
			,sReceivedAs(NULL),sNameOfSeller(NULL),sDescription(NULL)
	{
	}
};

struct XHDR
{
	tU32 u32FrameID;
	tU32 u32Size;
	tU16 u16Flags;
	tU32 u32MIMEHash;
	tU8 u8ParameterID;
	tU8 u8ParameterLength;
	tU16 u16ParameterValue;
	
	XHDR():
	u32FrameID(0),u32Size(0),u16Flags(0),u32MIMEHash(0),
	u8ParameterID(0),u8ParameterLength(0),u16ParameterValue(0)
	{
	}
};
/** ------------------------------ */
/** struct AudioProgPSDData definition	   */
/** ------------------------------ */
struct AudioProgPSDData{
	
	tU8 u8AudioProgNum;

	midw_fi_tclString sTitle, sArtist, sAlbum, sGenre;

	XHDR oXHDR;
	PSDCommentData oPSDCommentData;
	PSDUFIDData oPSDUFIDData;
	PSDCommercialData oPSDCommercialData;


	AudioProgPSDData():u8AudioProgNum(INVALID_AUDIOPROGRAM)\
			,sTitle(NULL)\
			,sArtist(NULL)\
			,sAlbum(NULL)\
			,sGenre(NULL)
	{
	}

	AudioProgPSDData(tU8 u8AudioProgram):u8AudioProgNum(u8AudioProgram)\
			,sTitle(NULL)\
			,sArtist(NULL)\
			,sAlbum(NULL)\
			,sGenre(NULL)
	{
	}
	
};
/** vnd4kor: Store PSD information for HD station */
/** ------------------------------ */
/** struct StationPSDData definition	   */
/** ------------------------------ */


struct StationPSDData {
  
  /** Map for storing PSD data of each audioprogram.*/
  typedef std::map<tU8, AudioProgPSDData> mapPSDData;

  mapPSDData m_mapPSDData;

  /** constructor */
  StationPSDData()
  {
	  vInstantiateMap();
  }

  tVoid vInstantiateMap()
  {
 	  for(tU8 u8Count =0; u8Count <= (tU8)midw_fi_tcl_e8_Tun_HDAudioProgram::FI_EN_TUN_AUDIO_PROGRAM_EIGHT; u8Count++)
	  {
		  AudioProgPSDData data(u8Count);
		  m_mapPSDData[u8Count] = data; 
	  }
  }
  
  /** store PSD info into the map */
  tVoid vAddAudioProgPSDData(AudioProgPSDData& data)
  {
	  if(data.u8AudioProgNum != INVALID_AUDIOPROGRAM)
	  {
		  m_mapPSDData[data.u8AudioProgNum] = data;
	  }
	  
  }
  
  /** Return PSD data for audio Program if available */
  AudioProgPSDData oGetAudioProgramPSDData(tU8 u8AudioProgNumber)
  {
	  AudioProgPSDData data;
	  mapPSDData::iterator it = m_mapPSDData.end();
	  if(!m_mapPSDData.empty())
	  {
		  it = m_mapPSDData.find(u8AudioProgNumber);
	  }
	  

	  if(it != m_mapPSDData.end() )
	  {
		  data = it->second;
	  }
	  
	  return data;
	  
  }

   /** Clear contents of the map */
  tVoid vClearPSDMap()
  {
	  m_mapPSDData.clear();
	  vInstantiateMap();
  }

  /** Get size of the map */
  tU8 u8PSDMapSize()
  {
	  return (tU8)m_mapPSDData.size();
  }

};


#define TUN_ADVISORY_BITS_MASK 0x07
#endif
/*--------------------------------*/
/* class tun_MsgToHMI definition  */
/*--------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
class clAars_ATPresetList_XX;
class clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
class clTmcTuner_Method_S_JAPAN_SET_AREA;
#endif

class clConfigInterface;
class clTmcTuner_GetConfigurationInfoStatus;

class tun_MsgToHMI : public TUN_Singleton< tun_MsgToHMI>
{
  friend class TUN_Singleton< tun_MsgToHMI>;

private:

     // Get the Data from AMT


   template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
   /* this function must not be used, therefore it is private */
   tun_MsgToHMI& operator=(const tun_MsgToHMI& c);
   
   	/** Set active preset list related member variables */
	/** ----------------------------------------------- */
   /** struct to store AppId, RegId, Cmndctr */
	MsgData m_rSetActivePresetListMsgData ;
	MsgData m_rConfigListUpdateData ;

	tU16 m_u16ListIdOfSetActivePresetList;
	tU16 m_u16AMActivePresetListId;
	tU16 m_u16FMActivePresetListId;
	tU16 m_u16DRMActivePresetListId;
	/** ----------------------------------------------- */
 
	tBool m_bSendAutostoreMthdResult;

	 tU8 m_u8RDSSwitchStatus;

	 tU32  m_u32AnnoInfoFreq;
	 tU16  m_u16AnnoInfoPI;
	 midw_fi_tclString m_utf8StringPSName;
	 tU8   m_u8AnnoInfoType;
	 tU8    m_u8AtStaInfoQuality;
	 tU32    m_u32AtStaInfoFreq;

	 tU8  m_u8AnnoMessage;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_INF4CV
	 tU8 m_u8BGAnnoMessage;
	 midw_fi_tcl_e8_Anno_Message m_enAnnoMsg;
#endif
	 tU8 m_u8AFSwitch;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	 clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
	 clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* m_poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST;
	 clTmcTuner_Method_S_JAPAN_SET_AREA* m_poclTmcTuner_Method_S_JAPAN_SET_AREA;
	 clTmcTuner_Method_S_USER_PROFILE_UPDATE* m_poclTmcTuner_Method_S_USER_PROFILE_UPDATE;
	 clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE* m_poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE;
	 clAars_DemodulationSwitch* m_poclAars_DemodulationSwitch;
	 clTmcTuner_GetConfigurationInfoStatus* m_poclTmcTuner_GetConfigurationInfoStatus;
	 clTmcTuner_Method_S_AUDIO_FG_BG_NEW* m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW;
#endif
	 clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;
	  tU8 m_u8TunFGBG;
	  tU8 m_u8RequestedPresetIndex;

public:

  tBool fFeatureFlag;
  tBool fAntennaFlag;
  tU8 m_u8PhysicalTuner ;
  tU8 m_u8TunerState;
  tU8 m_u8SeekState;
  tBool bSystemPresets;
  tU8  u8SystemPresets_Band;
  tU8 m_u8AnnoSwitchState;
  tU32 m_u32ATStationFreq;


  
	//Store the diagnosis register ID- to be used to send Method result for Remote control Method
    tU16 m_u16DiagRegID;

    //Store the diagnosis command counter- to be used to send Method result for Remote control Method
    tU16 m_u16CommandCntr;
	
	//Store the Tunermaster command counter- to be used to send Method result for Active_Tuner method
	tU16 m_u16TMCommandCntrActiveTuner;
	tU16 m_u16TMCommandCntrSetRdbid;

	tU16 m_u16TMCommandCntrBandChange;
	tU16 m_u16BandChangeRegID;
	
	tU16 m_u16TMCommandCntrFGBG;
	tU16 m_u16FGBGRegID;
	
	tU16 m_u16TMCommandCntrDirectFreq;
	
	tU16 m_u16DirectFreqID;

	//Store the Tunermaster register ID- to be used to send Method result for Active_Tuner method
	tU16 m_u16TMDiagRegID;
	tBool m_bDirectFreqReq;

	tU16 m_u16TMSetRDBISRegID;
	tU16 m_u16CmdCtrForPresetRecall;
	tU16 m_u16CmdCtrForTMCConfigList;

    tU16 m_u16CmdCtrForAutostore;



	tU8 m_u8PrevBand;

	tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,fi_tclTypeBase& oFIData )const;
	tBool bIsTunerFG();
	tBool bIsFMAnnouFG();
protected:
  /*-------------*/
  /* Constructor */
  /*-------------*/
  tun_MsgToHMI();
private:

  /** function to create preset list element */
  tVoid vCreatePresetListElement(midw_fi_tcl_TunerStaticListElement &oStatic_ListElem, \
											 tU8 u8HMIListID, tU8 u8Index, \
											 const tU8* pu8Message
											 );



  tVoid vPrintTestModeTraces(\
						midw_tunerfi_tclMsgFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus \
						&oTestModeDataStatusMsg
					)const;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  	StationPSDData m_oStationPsdData;


	tU8 m_u8CurrentAudioProgram;
	tU8 m_u8HDStationInfoBits;
	tU32 m_u32HDFrequency;
	tU32 m_u32StationInfoHDStationID;
	
	OSAL_tTimerHandle  m_hTimerAdvisoryTimer;
	OSAL_tTimerHandle  m_hHDStationInfoBitTimer;
  
	tBool m_bHDAudioDecodingBit;
	tBool m_bAdvisoryTimerSet;
	tBool m_bBit0and1OnceOn;
	tBool m_bHDStationInfoBitTimer;
	tBool m_bHDSeekSelected;
	tBool m_bHDAudioProgramSelected;
	tBool m_bHDStationListElementSelected;
	tBool m_bHDPresetSelected;
	tBool m_bHDAudioProgramDirectSelected;
	tBool m_bHDRotateEncoderSelected;
	midw_fi_tclString m_sHDActiveCallSign;

#endif
	tBool m_bPresetSelected;
	tBool m_bStationListElementSelected;


  tVoid vUpdatePresetListID();

  /* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */

public:
 /*-------------*/
 /* Destructors */
 /*-------------*/
 virtual ~tun_MsgToHMI( );

    tVoid vSendAutostoreMethodResult( \
	  midw_fi_tcl_e8_Tun_ResponseStatus::tenType e8MthdRsltstatus, tU8 u8Opcode);
  tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager );

  tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

  tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

  tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );

  tVoid vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface );

  tVoid vSet_tun_MsgFromHMI_Ptr( tun_MsgFromHMI* potun_MsgFromHMI );

  tVoid vSet_tuner_tclApp_Ptr( tuner_tclApp* potunerMainApp );

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSet_tun_GetConfigInfoStatus_Ptr( clTmcTuner_GetConfigurationInfoStatus* poclTmcTuner_GetConfigurationInfoStatus );
  tVoid vSet_tun_AudioFgBg_Ptr( clTmcTuner_Method_S_AUDIO_FG_BG_NEW* poclTmcTuner_Method_S_AUDIO_FG_BG_NEW );
  clTmcTuner_Method_S_AUDIO_FG_BG_NEW* getTun_AudioFgBg_Ptr()
  {
     return m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW;
  }
#endif


  /** vnd4kor : to update method result for preset handling */ 
  tU8 u8ReturnMethodResultStatus(PresetHandlingData data,const tU8* pu8Message, tU8 u8NoOfPresets);

  tVoid vSendPresetHandlingMethodResult(const tU8* pu8Message, tU8 u8NoOfPresets);



  /*----------------------------------------------------------------------*/
  /* Add new (HMI UpReg) Function ID registration in the Nototable table  */
  /*----------------------------------------------------------------------*/
  tBool bAddNotificationTable ( const amt_tclServiceData* poMessage );

  /*--------------------------------------------------------------------*/
  /* Remove (HMI UpReg) Function ID registration in the Nototable table */
  /*--------------------------------------------------------------------*/
  tBool bRemoveNotification( const amt_tclServiceData* poMessage );

  /*-----------------------------------------------------------------------------------*/
  /* Remove All entries (HMI UpReg) of Function ID registration in the Nototable table */
  /*-----------------------------------------------------------------------------------*/
  tVoid vRemoveAllEntriesWithRegID( tU16 u16ServiceID, tU16 u16RegisterID );


                                 

 tVoid vSendError( amt_tclServiceData* poMessage, tU16 u16ErrorCode  );
  
  tun_HMIManager* m_potun_HMIManager;
  tuner_tclApp*   poGWMain;

  /*------------------------------------*/
  /* Tuner Data is sored in this class  */
  /*------------------------------------*/
   tun_ActualData* m_potun_ActualData;

   /*---------------------------*/
   /* class sends message to RU */
   /*---------------------------*/
    tun_MsgToADR* m_potun_MsgToADR;


    tun_Utility* m_potun_Utility;

    // pointer to class tun_Config
    tun_Config* m_potun_Config; 

    clConfigInterface* 	m_poclConfigInterface;

    tun_MsgFromHMI* m_potun_MsgFromHMI;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
    tVoid vSet_TmcTuner_Method_S_SET_ACTIVE_PRESETLISTPtr( clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST* poclTmcTuner_Method_S_SET_ACTIVE_PRESETLIST );
	tVoid vSet_clAars_ATPresetList_XXPtr(clAars_ATPresetList_XX* poclAars_ATPresetList_XX);
	tVoid vSet_clAars_DemodulationSwitchPtr(clAars_DemodulationSwitch* poclAars_DemodulationSwitch);
	tBool blGetSendAutoStoreMethodeResult();
	tVoid vSetSendAutoStoreMethodeResult(tBool blSendAutostoreMthdResult);
	tVoid vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(clTmcTuner_Method_S_JAPAN_SET_AREA* poclTmcTuner_Method_S_JAPAN_SET_AREA);
	tVoid vSet_TmcTuner_Method_S_USER_PROFILE_UPDATEPtr( clTmcTuner_Method_S_USER_PROFILE_UPDATE* poclTmcTuner_Method_S_USER_PROFILE_UPDATE );
	tVoid vSet_TmcTuner_Method_S_PRESETLIST_CONTENT_UPDATEPtr( clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE* poclTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE );
	clTmcTuner_Method_S_JAPAN_SET_AREA* poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr();
#endif
    tVoid vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr( clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY );


  

  tVoid vHandle_r_Get_Data_Frq( const tU8* pu8Message, tU32 u32MessageLen );



  tVoid vHandle_r_Set_Feature( const tU8* pu8Message);
  
  tVoid vHandle_r_Get_EnhancedTestMode( const tU8* pu8Message);

  tVoid vHandle_r_Get_TestMode( const tU8* pu8Message);

  tVoid vHandle_r_Set_Highcut( const tU8* pu8Message);
  
  tVoid vHandle_r_Get_CalibrationData(  tU8* pu8Message, tU32 u32MessageLen );

  tVoid vHandle_r_Set_AFBestSwitch( const tU8* pu8Message);
  
  /**vnd4kor : Handles RDS Switch ON-OFF*/
  tVoid vHandle_r_RDSSwitch( const tU8* pu8Message);
  tVoid vHandle_r_REGMode( const tU8* pu8Message, tU32 u32MessageLen );
  
  tVoid vHandle_r_DDASwitch( const tU8* pu8Message);
  
  tVoid vHandle_r_TPSwitch( const tU8* pu8Message);
  
  tVoid vHandle_r_AFBestSwitch( const tU8* pu8Message);

  tU8 u8GetAFSwitchValue()const;

  tVoid vSetAFSwitchValue(tU8 u8newvalue);

  tVoid vHandle_r_AfList( const tU8* pu8Message);

 

  tVoid vHandle_r_OperationAvailability( const tU8* pu8Message, tU32 u32MessageLen );


  tVoid vHandle_r_Autostore(const tU8* pu8Message);
  tVoid vHandle_r_GetConfigList( const tU8* pu8Message);

  /** vnd4kor : removed unused parameter msgLength*/
  tVoid vHandle_r_CM_StationsList(tU8* pu8Message);

  //tVoid vHandle_r_UpdateConfigList ( const tU8* pu8Message, tU32 u32MessageLen );

  tVoid vHandle_r_Audio_Fg_Bg_new( const tU8* pu8Message, tU32 u32MessageLen );


  tVoid vHandle_r_Sharx_Level( const tU8* pu8Message);

  tVoid vHandle_r_Get_RadioText(const tU8* pu8Message);

  tVoid vHandle_r_Set_Antenna(const tU8* pu8Message);
  
  tVoid vHandle_r_Monitor_Station(const tU8* pu8Message);
  
  tVoid vHandle_r_AtStationInfo(tU8* pu8Message );
  /**pmn3kor:
   * created new function to solve logiscope issues
   * Handler for Updating Station Info*/
  tVoid vUpdateStationInfo\
  (midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg, tU8* pu8Message);
  /**pmn3kor:
     * created new function to solve logiscope issues
     * Handler for Japan Station count Updating Station Info*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vUpdateJapanStationCount(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg);
  tVoid vUpdateDRMData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg, tU8* pu8Message);
#endif
  /**pmn3kor:
   * created new function to solve logiscope issues
   * Handler for Updating Station Info when there is a band change*/
  tVoid vHandleChangeBandMethodResult\
  (tU8 u8Band, tU16 &u16PresetListID);
  /**pmn3kor:
   * created new function to solve logiscope issues
   * Handler for Updating Station Info for direct frequency input*/
  tVoid vHandleDirectFrequencyMethodResult (tU32 u32frequency );
  
  tVoid vHandle_r_TunerState( const tU8* pu8Message);
  
  tVoid vHandle_r_ATSeek( const tU8* pu8Message, tU32 u32MessageLen );

  tVoid vSendTMCInfo(tBool bTMCInfoFlag);

  tVoid vHandle_r_TMC_MonitoredStations_Update( const tU8* pu8Message, tU32 u32MessageLen);

  tVoid vHandle_r_TMC_Buffered_TrafficInfos( const tU8* pu8Message);
  
  tVoid vHandle_r_TMCStationsCount( const tU8* pu8Message );

  tVoid vHandle_r_TMCStations( const tU8* pu8Message);

  tVoid vSend_G_Audio_Fg_Bg( tU8 u8TunerHeader,  tU8 u8AudioSink);
  
  
  tVoid vHandle_r_AtBand( const tU8* pu8Message, tU32 u32MessageLen );
  
  tVoid vHandleFSMethodResult(const tU8* pu8Message);
  
  tVoid vHandle_r_SpecialDiagnosis( const tU8* pu8Message );
  
  tVoid vHandle_r_SystemPresets( const tU8* pu8Message, tU32 u32MessageLen );
  
  tVoid vHandle_r_TMCSelctionFilter( const tU8* pu8Message);

  tVoid vHandle_r_CM_AtPresetList(const tU8* pu8Message, tU32 u32MessageLen);

  tVoid vHandle_r_CM_ATPresetListSetActive();

  tVoid vSendSetActivePresetListMethodResult();

  tVoid vHandle_r_CM_EngineeringParameter(const tU8* pu8Message);
  
  /** TuningActionConfiguration related functions */
  tVoid vHandle_r_CM_TuningActionConfiguration(const tU8* pu8Message);


  tVoid vCreateTuningActionConfigParam(\
				const tU8* pu8Message,\
				tU8 &u8TunConfigParameterValueOffset,\
				tU8 u8ParamId,\
				midw_fi_tcl_TuningActionConfigParam* oTuningActionConfigParam)const;

	/** -------------------------------------------- */
  
  tU8 u8GetAudibleTuner() const;

  tU8 u8GetTunFGBGStatus() const;
  tVoid vSetTunFGBGStatus(tU8 u8TunFGBG);
  tU8 u8GetSeekMode();
  
  tVoid vClear_TunerStates();
     
   tVoid vSetDiagRegID(tU16 u16RegID);

  tU16 u16GetDiagRegID() const;

  tVoid vSetDiagCommandCntr(tU16 u16ComCntr);

  tU16 u16GetDiagCommandCntr() const;

  tU16 u16GetTunerMasterRegID() const;  

  tVoid vSetTunerMasterRegID(tU16 u16RegID);
  
  tU16 u16GetTunerMasterCommandCntrForActiveTuner() const;
  
  tVoid vSetTunerMasterCommandCntrForActiveTuner(tU16 u16ComCntr);

  tVoid vSetTPEGCommandCntrForSetRdbid(tU16 u16ComCntr);

  tU16 u16GetTPEGCommandCntrForSetRdbid() const;

  tVoid vSetTPEGRegIDForSetRdbid(tU16 u16RegID);

  tU16 u16GetTPEGRegIDForSetRdbid() const;

  tVoid vSetTunerMasterCommandCntrForBandChange(tU16 u16ComCntr);

  tU16 u16GetTunerMasterCommandCntrForBandChange() const;
  
  tVoid vSetTunerMasterCommandCntrForFGBG(tU16 u16ComCntr);
  
  tU16 u16GetTunerMasterCommandCntrForFGBG()const;

  tVoid vSetTunerMasterRegIDForBandChange(tU16 u16RegID);

  tU16 u16GetTunerMasterRegIDForBandChange() const;
  
  tVoid vSetTunerMasterRegIDForFGBG(tU16 u16RegID);

  tU16 u16GetTunerMasterRegIDForFGBG() const;
  
  tVoid vSetTunerMasterCommandCntrForDirectFreq(tU16 u16ComCntr);
  
  tU16 u16GetTunerMasterCommandCntrForDirectFreq() const;
  
  tVoid vSetTunerMasterRegIDForDirectFreq(tU16 u16RegID);
  
  tU16 u16GetTunerMasterRegIDForDirectFreq() const;
  
  tVoid vSetCmdCtrTMCConfigList(tU16 u16CmdCntr);
  
  tU16 u16GetCmdCtrTMCConfigList() const;

  tVoid vSetCmdCtrForAutostore(tU16 u16CmdCntr);

  tU16 u16GetCmdCtrForAutostore() const;

  /** ------------------------------------------------ */
  /** vnd4kor: Active preset list supporting functions */
  /** ------------------------------------------------ */
  tVoid vSetMsgDataForSetActivePresetList(tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr);

  MsgData rGetMsgDataForSetActivePresetList() const;

  tVoid vSaveListIDForSetActivePresetList(tU16 u16ADRListID);

  tU16 u16GetListIDForSetActivePresetList() const;

  
  /** ------------------------------------------------ */
  /** vnd4kor: Update ConfigList supporting functions */
  /** ------------------------------------------------ */
  tVoid vSetMsgDataForConfigListUpdate(tU16 u16AppId,tU16 u16RegId,tU16 u16CmdCntr);

  MsgData rGetMsgDataForConfigListUpdate() const;

  tVoid vHandle_r_ConfigList_Update(tU8 u8Status);

  /** ---------------------------------------------------------------- */
  /** Announcement related handlers */
  /** ---------------------------------------------------------------- */
  tVoid vHandle_r_CM_AnnouncementSwitch(const tU8* pu8Message);

  tVoid vHandle_r_CM_AnnouncementMessage( const tU8* pu8Message);

  midw_fi_tcl_e8_Anno_Message enGetAnnouncementMessage( tU8 u8AnnoMsg);

  tVoid vHandle_r_CM_AnnouncementInfo( const tU8* pu8Message);

 /** ---------------------------------------------------------------- */
 
  tVoid vHandle_r_CM_PiPsRelation( const tU8* pu8Message);

  tVoid vHandle_r_CM_EvaluationParameter( const tU8* pu8Message );

  tVoid vHandle_r_CM_UpdateLandscapeProgress( const tU8* pu8Message );

 
  tVoid vHandle_g_AvailableBandRange();
  
  tU32 u32CheckAMFreqRange(tU32 u32Freq , tU8 u8Sync_Signal = TUN_PWM_SYNC_GEN3) const;

  tVoid vSetDirectFreqRequested(tBool bDirectFreqReq);

  tBool vGetDirectFreqRequested()const;

   tU8 u8GetRDSSwitchStatus() const; 
   tVoid vSetRDSSwitchStatus(tU8 u8RdsSwitch); 

  virtual tVoid vSend_MuteDemuteReq(tBool bMute , tBool bMute_Interrupt);
  tVoid vHandleMuteDemuteAction();

  tVoid vSetAnnoInfoFreq(tU32 u32Frequency);

  tU32 u32GetAnnoInfoFreq() const;

  tVoid vSetAnnoInfoPSName(midw_fi_tclString sUtf8String);

  midw_fi_tclString utf8GetAnnoInfoPSName() const;

  tVoid vSetAnnoInfoPI(tU16 u16PI);

  tU16 u16GetAnnoInfoPI() const;

  tVoid vSetAnnoInfoType(tU8 u8AnnoType);

  tU8 u8GetAnnoInfoType() const;

  tU8 u8GetAnnoMessageType() const;

  tVoid vSetAtStaInfoQuality(tU8 u8AtStaInfoQuality);

  tU8 u8GetAtStaInfoQuality() const;

  tVoid vSetAtStaInfoFreq(tU32 u32Frequency);

  tU32 u32GetAtStaInfoFreq() const;
  tU8 u8Getmidw_fi_tcl_b8_Anno_Message(tU8 u8ADRAnnouncementType);

 virtual tVoid vSendMessage( tU16             u16DestAppID,
                      const fi_tclTypeBase&  oOutData,
                      tU16             u16Fid,
                      tU8              u8OpCode,
                      tU16             u16CmdCtr,
                      tU16             u16RegId);

 tVoid vCreateStationsListElement( tU8 u8ListId, 
									tU8 u8ElementId, const tU8* pu8Element ,
									midw_fi_tcl_TunerConfigListElement* TunerConfigListElement);

 tVoid vCreateTMCListElement(tU8 u8ElementId ,const tU8* pu8Element ,midw_fi_tcl_TunerConfigListElement* TunerConfigListElement);

 tVoid vGetCurrentStateUpdates();

 tVoid vUpdatePresetListID_DP(tU16 u16PresetListID);

 tVoid vGetStationLogoPath(tU32 u32PI, midw_fi_tclString &oUtf8String , tBool bRequireSmallLogo = FALSE);
 
 tVoid vSendAnnouncementInfo_Quality(tU8 u8Quality);
  /*-------------------------------------*/
  /* Notification table : HMI client     */
  /*-------------------------------------*/
  //ahl_tFunction            m_aFuncID_HMI_Array[TUNER_HMI_FUNID_CARRAY_SIZE];     
  //ahl_tNotification        m_aNotArray_HMI[TUNER_HMI_FUNID_NOTARRAY_SIZE]; 
  
  ahl_tclNotificationTable*  m_poHMINotTable;

  

  static OSAL_tSemHandle     m_hNotHMITableSem;  

    tU16 m_u16StationListCommandCtr;
  tU16 m_u16UIRegID;
  tU16 m_u16UIAppID;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20  
  tVoid vPSDAndAdvisoryHandling(const midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oAtStationInfoStatusMsg);

  /*--------------------------------------*/
  /* Call back function for PSD Data      */
  /*--------------------------------------*/
  
  tVoid vHandle_r_CM_ATHD_PSDDataFrame( const tU8* pu8Message );
  tVoid vSendPSDStatus(tU8 u8AudioProgNum);
  tVoid vPrintPSDStatus(AudioProgPSDData& data);
  tVoid vExtractPSDCommentData(tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData& oAP_PSDData);
  tVoid vExtractPSDCommercialData(tU8 &u8SubfieldMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData& oAP_PSDData);
  tVoid vExtractPSDUFIDData(tU8 &u8SubfieldMask,tU8 &u8SubFieldLength,const tU8* pu8Message,AudioProgPSDData& oAP_PSDData);
  tVoid vExtractPSDXHDRData(tU8 &u8SubFieldLength,const tU8* pu8Message,AudioProgPSDData& oAP_PSDData);
  tVoid vHandlePSDXHDRData(const AudioProgPSDData& oAP_PSDData, const bool& bIsInvalidMIMEHash);
  tBool bIsEqualsCurrentAudioProgram(unsigned char u8AudioProgram);
  tVoid vTriggerDisplayOfImage(const AudioProgPSDData& oAP_PSDData );
  tVoid vBlankImageDisplayTrigger(const AudioProgPSDData& oAP_PSDData );
  tVoid vFlushImageMemory(const AudioProgPSDData& oAP_PSDData );
  tVoid vSetTitleArtistAlbumGenre(const tU16 u16FieldBitMask,const tU8 u8SubFieldLength,\
	const tU8 u8SubfieldDataType, const tU8* pu8Message,AudioProgPSDData &oAP_PSDData);
  
  template<typename T>
  tVoid vReadLittleEndian(T &dataHolder, const tU8* pu8Message);
  
/* ---------------------------------------------------------------- */

  /*--------------------------------------*/
  /* Call back function for Advisory timer         */
  /*--------------------------------------*/
  static tVoid vAdvisoryTimerCallback(tVoid* pArg);
  static tVoid vHDStationInfoBitTimerCallback(tVoid* pArg);
  
  tVoid vHandle_Advisory_Info( tU8 u8HDStationInfoBits, const tU8 u8HDAudioProgNum);
  tVoid vHandleHDAudioDecodingTimer(const tU32 u32AtStationInfoFrequency, const tU32 u32AtStationInfoHDStationId);
  tVoid vClearAdvisoryStates();
  tVoid vClearHDTuningActionStates();
  tVoid vSend_HD_AdvisoryInfo(tU8 u8Advisory);
  tVoid vSend_HD_SignalLostTimer(tBool bTimerStatus);
  tVoid vAdvisoryTimerExpired();
  tVoid vHDStationInfoBitTimerExpired();
  tVoid vHandleAdvisoryMemberVariableStates(tU16 u16FunctionId);
  tVoid vHandleHDTuningActionVariableStates(tU16 u16FunctionId);
  tVoid vStopHDAudioDecodingTimer();
  tVoid vStartHDAudioDecodingTimer();
  tBool bIsHDTuningActionSelected(const tU32 u32AtStationInfoFrequency, const tU32 u32AtStationInfoHDStationId);
  tVoid vStripLeadingAndTrailingSpaces(const tU8* source, string& destination,tU8 u8StringLength);
  tVoid vReplaceUnusedCharactersWithSpace(string& destination);
  midw_fi_tclString strGetActiveHDCallSign();
  tVoid vGetActiveHDStationLogoPath(midw_fi_tclString& strActiveStationLogoPath, tU32 u32HDStationID, tU8 u8HDAudioProgNum);
  tU8 u8GetActiveAudioProgram() const;
  tVoid vOnNewDemodulationStatus(unsigned char u8DemodulationSwitch);
  bool bIsFMDemodulationON(midw_fi_tcl_e8_Tun_TunerBand::tenType eCurrentBand);
  bool bIsAMDemodulationON(midw_fi_tcl_e8_Tun_TunerBand::tenType eCurrentBand);
#endif 
/* ---------------------------------------------------------------- */

  /*gds5kor : clear announcement whenever service becomes unavailable */
  tVoid vClearAnnoMessage();
  /* ---------------------------------------------------------------- */
  tVoid vOnTunerStateChanged(tU8 u8TunerState);

  tU16 u16GetFMActivePresetListId();
  tU16 u16GetAMActivePresetListId();
  tU16 u16GetDRMActivePresetListId();
  tVoid vSetFMActivePresetListId(tU16 u16FMActivePresetListId);
  tVoid vSetAMActivePresetListId(tU16 u16AMActivePresetListId);
  midw_fi_tcl_e8_Tun_TunerBand u8GetBandFromFrequency(tU32 u32Frequency);
  tVoid vSetDRMActivePresetListId(tU16 u16DRMActivePresetListId);
  tVoid vSetStationName(midw_fi_tclString sStationName ) {m_utf8PSName = sStationName;}
  midw_fi_tclString sGetStationName() {return m_utf8PSName;}
  tVoid vSetRequestedPresetIndex(tU8 u8RequestedPresetIndex) { m_u8RequestedPresetIndex = u8RequestedPresetIndex; }
  midw_fi_tclString m_utf8PSName;
  
};


#endif /* TUN_MSGTOHMI_H */
