/************************************************************************
* FILE:           tun_MsgFromHMI.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All messages comming from HMI are handled in this file.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 17.03.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/



#ifndef TUN_MSGFROMHMI_H
#define TUN_MSGFROMHMI_H


#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

enum enMuteAction
{
	DirectFrequency=0,
	ManualTuning,
	PresetRecall,
	Seek,
	StationList,
	PISeek,
	None = 0xFF
};

struct stMuteHandlingRequest
{
	enMuteAction enMuteAction_curr;
	enMuteAction enMuteAction_next;
	tU8 u8SeekType;
	tU32 u32Frequency;
	tU32 u32Frequency_Direct;
	tU8 u8AcceptAF;
	tU8 u8NumberOfTicks;
	tU8 u8Direction;
	tU8 u8TunerHeader;
	tU16 u16ListID;
	tU8 u8ListElementID;
	tU16 u16StationListID;
	tU8  u8StationList_ElemID;
	tU8  u8PIStep_Direction;
	tU8  u8AbsRel;
	tU32 u32StationListElem_Frequency;
	tU16 u16StationListElem_PICode;
	tU32 u32StationListElem_HDStnID_DRMSrvID;
	tU8 u8StationListElem_ModulationType;
};


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#ifndef VARIANT_S_FTR_ENABLE_USE_MIDW_FI_INTERFACE
 #define FI_S_IMPORT_INTERFACE_FI_MESSAGE
 #include "midw_fi_if.h"
#endif

#define AM_FREQUENCY 540
#define FM_FREQUENCY 96200

#define SINGLE_TUNER  0x00
#define TMC_SELECTIONFILTER_MASK 2
#include "CcaApp/clCCAhandler.h"

#include "tun_Class_ForwardDecl.h"
/*
class ahl_tclServerPortMngr;

class tuner_tclApp;

#ifndef TUN_MSGTOHMI_H
class tun_MsgToHMI;
#endif
class tun_HMIManager;
class tun_Config;
*/

/*-----------------------------------*/
/* class tun_MsgFromHMI definition   */
/*-----------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
class clAars_ATPresetListSetActive;
class clTmcTuner_Method_S_AUDIO_FG_BG_NEW;
#endif
class clConfigInterface;
class tun_MsgFromHMI : public ahl_tclBaseWork , public tuner::CcaApp::clCCAhandler
{
private:
	tVoid vRemoveFromNotificationTable(amt_tclServiceData* poInMessage);
	static OSAL_tSemHandle     m_hMsgFromHMISem;

  tU32 m_u32TestModeFeatureValue;
   
   

  
   
    /** to send MtdRslt for Set Active Preset list during bandchange */
	tBool m_bSetActivePresetListRequested;

protected:
  virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
     tuner_tclApp*        poGWMain;

public:   
      
	tBool bUpRegDiag;
	
	tU8 m_u8Band;
	
	tBool m_bFSReqFromDiag;
	
	tBool m_bSrcInAM;
	
	tU32 m_u32DirectFreq;

	stMuteHandlingRequest m_MuteHandlingRequest;

	// Get the Data from AMT
	 virtual  tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,
	                          fi_tclTypeBase&     oFIData ) const;
   /*-------------*/
   /* constructor */
   /*-------------*/
   tun_MsgFromHMI( tuner_tclApp* poMain );
   tun_MsgFromHMI();//default constructor is added for lint warning

   /*------------*/
   /* destructor */
   /*------------*/
   virtual ~tun_MsgFromHMI( ); 

   tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );

   tVoid vSet_tu_Manager_Ptr( tu_Manager* potu_Manager );

   tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );

   tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData );

   tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config );

   tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

   tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* potun_HMIManager );

   tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

    tU32 u32GetTestModeFeatureValue() const;
   
	tVoid vSetTestModeFeatureValue(tU32 u32NewFeature);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   clAars_ATPresetListSetActive* m_poclAars_ATPresetListSetActive;//TODO
   clTmcTuner_Method_S_AUDIO_FG_BG_NEW* m_poclTmcTuner_AudioFGBGNew;
#endif
	tun_MsgToHMI*        m_potun_MsgToHMI;//TODO
    /*----------------*/
    /* Tuner Manager  */
    /*----------------*/   
    tu_Manager* m_potu_Manager;

    /*---------------------------*/
    /* class sends message to RU */
    /*---------------------------*/
    tun_MsgToADR* m_potun_MsgToADR;

    tun_ActualData*   m_potun_ActualData;
    
    tun_Utility* m_potun_Utility;
   
    /*--------------------------------*/
    /* communicate with config class  */
    /*--------------------------------*/
    tun_Config* m_potun_Config;

    clConfigInterface* 	m_poclConfigInterface;
   
    /*---------------------------*/
    tun_HMIManager*   m_potun_HMIManager;

	tU8 m_u8TunerMode;



	tU8 m_u8MeasurementMode;

	tU8 m_u8ConfigListID;

   // Send the message to HMI client
   virtual tVoid vSendMessage ( tU16             u16DestAppID,
                        const fi_tclTypeBase&  oOutData,
                        tU16             u16Fid,
                        tU8              u8OpCode,
                        tU16             u16CmdCtr,
                        tU16             u16RegId);


   /*---------------------------------------------------------------------*/
   
   tVoid bSendAnswer( const amt_tclServiceData* poMessage, tU16 u16Value, tU8 u8Opcode );   
   
   /*---------------------------------------------------------------------*/
   

   /*---------------------------------------------------------------------*/      
   
   tVoid vSendError( const amt_tclServiceData* poMessage, tU16 u16ErrorCode  );

   /*---------------------------------------------------------------------*/

   tVoid vSendErrorToClientsInNotTable( const amt_tclServiceData* poMessage, tU16 u16ErrorCode );
   
   /*---------------------------------------------------------------------*/
   
   
   
   /*--------------------------------*/
   /* Incomming messages from HMI    */
   /*--------------------------------*/
  
   tVoid vHandleAllMessages(amt_tclServiceData* poMessage);
   
   tVoid vHandle_s_Set_Static_List( amt_tclServiceData* /*poMessage */);
   tVoid vHandle_g_Station_Data( amt_tclServiceData* /*poMessage */);
   tVoid vHandle_g_Station_Info( amt_tclServiceData* poMessage );
   tVoid vSendStationInfoStatusMessage(amt_tclServiceData* poMessage);
   tVoid vSendStationInfoStatusMessage();
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   tVoid vUpdateHDStationData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oStatusMsg);
   tVoid vUpdateDRMStationData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oStatusMsg);
#endif
   tVoid vHandle_s_AtFrequency( amt_tclServiceData* poMessage );

   tVoid vHandle_s_AtFrequencyWithTickInfo( amt_tclServiceData* poMessage );

   tVoid vSend_AtFrequencyWithTickInfo();
   tVoid vHandle_s_AtSeek( amt_tclServiceData* poMessage );
      
   tVoid vSend_AtSeek();
   tVoid vHandle_Monitor_Station( amt_tclServiceData* poMessage );

   tVoid vHandle_g_Component_Status( amt_tclServiceData* poMessage );

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
   tVoid vHandleSetBandFrq( amt_tclServiceData* /*poMessage*/ );
   tVoid vHandleSetAntenna(amt_tclServiceData* poMessage);
#endif    

   tVoid vHandle_s_ChangeBand( amt_tclServiceData* poMessage );
   
   tVoid vHandle_StationList_Exit( amt_tclServiceData* poMessage );

   tVoid vHandle_SetFeature( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_TunerTestMode( amt_tclServiceData* poMessage );

   tVoid vHandle_SetHighCut( amt_tclServiceData* poMessage );

   tVoid vHandle_AfList( amt_tclServiceData* poMessage );   

   tVoid vHandle_StopAnnouncement( amt_tclServiceData* poMessage );

   tVoid vHandle_s_DirectFrequency( amt_tclServiceData* poMessage );
   tVoid vSend_DirectFrequency();

   tVoid vHandle_s_SelectListElem ( amt_tclServiceData* poMessage );

   tVoid vSend_SelectListElem();

   tVoid vHandle_s_SaveStaticListElem ( amt_tclServiceData* poMessage ); 

   tVoid vHandle_s_SetSeekLevel( amt_tclServiceData* poMessage );

   tVoid vHandle_GetConfigList( amt_tclServiceData* poMessage );

   tVoid vSetProperSortingCriteria( tU8& u8SortCriteria);

   //tVoid vHandle_UpdateConfigList( amt_tclServiceData* poMessage );

   tVoid vHandle_SetAudFGBG( amt_tclServiceData* poMessage );

   tVoid vHandle_SetPI( amt_tclServiceData* poMessage );

   tVoid vSend_AtPI();

   tVoid vHandle_SetSharxLevel( amt_tclServiceData* poMessage );

   tVoid vHandle_GetStaticList( amt_tclServiceData* poMessage );

   tVoid vHandle_g_RadioText( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_SetAF( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_SetTA( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_SetDDA( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_SetRDSREG( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_SetMeasureMode( amt_tclServiceData* poMessage );

   tVoid vHandle_GetCalibrationData( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_BandPlusStationInfo( amt_tclServiceData* poMessage );
   
   tVoid vHandleFieldStrength (amt_tclServiceData* poMessage );
   
   tVoid vHandleGetActiveTuner (amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_DiagRemoteControl( amt_tclServiceData* poMessage );
   
   tVoid vHandle_g_RdbidActuallist(amt_tclServiceData* poMessage);
   
   tVoid vHandle_g_AtSeek(amt_tclServiceData* poMessage);
   
   tBool bGetFSRequestStatus() const;
   
   tVoid vSetFSRequestStatus(tBool bFSStatus);
   
   tVoid vHandle_g_SetRDSSwitch(amt_tclServiceData* poMessage);
   tVoid vHandle_s_Preset_Handling( amt_tclServiceData* poMessage );
   
   tVoid vSend_PresetRecall();
   tVoid vHandle_s_Set_Active_PresetList( amt_tclServiceData* poMessage );
   tVoid vHandle_s_Get_Static_List( amt_tclServiceData* poMessage );

   tVoid vHandle_SetupDDADDS( amt_tclServiceData* poMessage );

   tVoid vHandle_s_TMCInfo( amt_tclServiceData* poMessage );
   
   tVoid vHandle_s_Set_RDBID( amt_tclServiceData* poMessage );

   tVoid vHandle_g_Get_Data_TMC( amt_tclServiceData* poMessage );
   
   tVoid vHandle_s_PSFreeze( amt_tclServiceData* poMessage );

   tVoid vHandle_s_Autostore(amt_tclServiceData* poMessage);

   tVoid vHandleAutostoreError(amt_tclServiceData* poMessage);

   tVoid vHandleAutostoreMethodStart(amt_tclServiceData *poMessage);
   
   tVoid vHandle_s_SurveilTP( amt_tclServiceData* poMessage );

   tVoid vHandle_s_Set_Engg_Param( amt_tclServiceData* poMessage );

   tVoid vHandle_s_Set_TuningActionConfig(amt_tclServiceData* poMessage);

   tVoid vHandle_s_Sel_Elem_From_AFLIST_V2(amt_tclServiceData* poMessage);

   /** ---------------------------------------------------------------- */
   /** Announcement related handlers */
   /** ---------------------------------------------------------------- */
   tVoid vHandle_s_Set_AnnouncementSwitch(amt_tclServiceData* poMessage);
   tVoid vHandle_g_AnnouncementMessageAndInfo(amt_tclServiceData* poMessage);
   tVoid vHandle_s_AnnouncementEscape(amt_tclServiceData* poMessage);
   /** ---------------------------------------------------------------- */

   tVoid vHandle_s_SetPI_PS_Relation(amt_tclServiceData* poMessage);


   tVoid vHandle_s_SetPresetStoragePSNameFreeze(amt_tclServiceData* poMessage);

   tVoid vHandle_s_SetSpeedinformation(amt_tclServiceData* poMessage);
   
   tVoid vHandle_g_GetAvailableBandRange(amt_tclServiceData* poMessage);
   tVoid vHandle_g_Mute_Request(amt_tclServiceData* poMessage);

   tVoid vHandle_g_UpdateLandscape_Progress(amt_tclServiceData* poMessage);

   tVoid vHandle_g_AtPISearch(amt_tclServiceData* poMessage);

   tVoid vHandle_s_AudioMuteRequest(amt_tclServiceData* poMessage);

   tVoid vHandleMuteRequest(enMuteAction enMute_Action);

   tVoid vHandle_s_ConfigListUpdate(amt_tclServiceData* poMessage);

   tVoid vHandle_s_DefaultSetting(amt_tclServiceData* poMessage);

   tBool bGetDiagUpRegStatus() const;	
   
   tVoid RestoreAudibleTunerMode();

   tU16 u16UpdateTunerStateInMethodResult( tU8 u8ClientResponse )const;

   tVoid vSetAMSrcStatus(tBool bAMStatus);

   tBool bGetAMSrcStatus() const;
   
   tU32 u32GetDirectFreqRequested()const;

   /** Validation Functions */

   tBool bIsBandValid(tU8 u8ReceivedBand)const;
   tBool bIsEqualPresetListBandCurrentBand(tU8 u8HMIListID);

   tU8 u8GetBandFromFrequency();
   tU8 u8GetBandFromStationListID();
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   tVoid vHandle_g_HD_PSD_Data(amt_tclServiceData* poMessage);
   tVoid vHandle_s_HD_AdvisoryInfo(amt_tclServiceData* poMessage);
   tVoid vHandle_g_HD_SignalLostTimer(amt_tclServiceData* poMessage);
#endif

   /** -------------------- */

   /** Send Method result to Client */
  template <class METHODRESULT>
  tVoid vSendMethodResult(METHODRESULT &oResponse, amt_tclServiceData* poMessage, tU8 u8Result);

  tVoid vSet_SetActivePresetListRequested(tBool bState);
  tBool bGet_SetActivePresetListRequested()const;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vSet_clAars_ATPresetListSetActive_Ptr(clAars_ATPresetListSetActive* poclAars_ATPresetListSetActive);
  tVoid vSet_clTmcTuner_AudioFGBGNEW_Ptr(clTmcTuner_Method_S_AUDIO_FG_BG_NEW* poclTmcTuner_AudioFGBGNew);
#endif
  tVoid vSetConfigListID(tU8 u8ConfigListID);
  tU8 u8GetConfigListID()const;
  tU8 u8GetCurrentBand();
  tU8 U8GetUserAutoSToreNoOfStations(tU8 u8PresetListID);
  tVoid vSetTunerBand(tU8 u8Band);
  tVoid vHandle_ChangeBand( tU8 u8Band );
   DECLARE_MSG_MAP( tun_MsgFromHMI )

};

#endif /* TUN_MSGFROMHMI_H */
