/************************************************************************
* FILE:           tun_Msg_Defines.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    All defines of Tuner Message, to / from  RU.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 24.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#ifndef TUN_MSG_DEFINES_H
#define TUN_MSG_DEFINES_H



/*----------------------------------------*/
/*  Outgoing Messages to RU               */
/*----------------------------------------*/


//#define TUN_R_REJECT                       0x0b //already defined in incoming msg

#define TUN_C_AUDIO_FG_BG                  0x22
#define TUN_C_COMPONENT_STATUS             0x24

#define TUN_C_GET_DATA                     0x26
#define TUN_C_HALT_MODE                    0x30

#define TUN_C_CALIBRATE                    0x34
#define TUN_C_ALIGN_TDA7528                0x36

#define TUN_C_SET_FRQ                      0x40
#define TUN_C_SET_PI                       0x42

#define TUN_C_SEEK                         0x44
#define TUN_C_SCAN_BAND                    0x46

#define TUN_C_PLAY                         0x48
#define TUN_C_STOP_ANNOUNCEMENT            0x4a

#define TUN_C_SET_BAND                     0x4e

#define TUN_C_GET_DATA_FRQ                 0x50
#define TUN_C_GET_DATA_TMC                 0x52

#define TUN_C_GET_DATA_CT                  0x54
#define TUN_C_GET_DATA_RADIOTEXT           0x56

#define TUN_C_GET_DATA_AFLIST              0x5a
#define TUN_C_GET_DATA_AFLIST_V2           0x5c

#define TUN_C_GET_DATA_RDS_RAW             0x6c
#define TUN_C_GET_DATA_LSM                 0x6e

#define TUN_C_ADJUST_SEEKLEVEL             0x60
#define TUN_C_ADJUST_TINA                  0x62

#define TUN_C_MEASURE                      0x64
#define TUN_C_SET_DIAG_MODE                0x66

#define TUN_C_CHECK_SUPPLY                 0x68
#define TUN_C_SET_SEEKLEVEL                0x70
#define TUN_C_SUPPLY_ERROR                 0x6A

#define TUN_C_SET_PTY                      0x72
#define TUN_C_SET_SCANTIME                 0x74

#define TUN_C_SET_HICUT                    0x7a
#define TUN_C_SET_RDBID                    0x7c

#define TUN_C_SET_FEATURE                  0x76
#define TUN_C_OPERATION                    0x78

#define TUN_C_SET_ANTENNA                  0xB2

#define TUN_C_MEASURE_MODE                 0x7e
#define TUN_C_SET_STATIC_LIST              0x80

#define TUN_C_AUTOSTORE_STATIC_LIST        0x82
#define TUN_C_SET_CONFIG_LIST              0x92

#define TUN_C_SCAN_LIST                    0x84
#define TUN_C_SEL_LIST_ELEM                0x86

#define TUN_C_ACT_LIST_ELEM                0x88
#define TUN_C_SAVE_STATIC_LIST_ELEM        0x8a

#define TUN_C_MAKE_CONFIG_LIST             0x8c
#define TUN_C_UPDATE_CONFIG_LIST           0x8e

#define TUN_C_GET_CONFIG_LIST              0x90
#define TUN_C_GET_CONFIG_LIST_ELEMENT      0x95

#define TUN_C_GET_STATIC_LIST              0x96
#define TUN_C_ACT_PTY_LIST_ELEM            0xa0

#define TUN_C_SAVE_PTY_LIST_ELEM           0xa2
#define TUN_C_GET_PTY_LIST                 0xa4 

#define TUN_C_SET_SHARX_LEVEL             0xA6
#define TUN_R_SET_SHARX_LEVEL             0xA7



/* Newly added    */
#define TUN_C_DELETE_STATIC_LIST_ELEM     0x32
#define TUN_C_CLEAR_STATIC_LIST           0x9A

#define TUN_C_ATM_CONTAINER               0xB0
#define TUN_C_NEW_PI_PS_COMBINATION       0xA8
#define TUN_C_SNAPSHOT                    0xBC
#define TUN_C_SET_AUTOCOMPARE_PARAMETERS  0x3A
#define TUN_C_CONFIGURE_ANTENNA           0XB8
//rrb1kor
#define TUN_C_MONITOR_STATION             0xBE




/*---------------------------------------------*/






/*----------------------------------------*/
/*  Incomming Messages from RU            */
/*----------------------------------------*/
#define TUN_R_REJECT                       0x0b
#define TUN_R_AUDIO_FG_BG                  0x23

#define TUN_R_COMPONENT_STATUS             0x25
#define TUN_R_GET_DATA                     0x27

#define TUN_R_HALT_MODE                    0x31
#define TUN_R_SET_FRQ                      0x41

#define TUN_R_CALIBRATE                    0x35
#define TUN_R_ALIGN_TDA7528                0x37


#define TUN_R_SET_PI                       0x43
#define TUN_R_SEEK                         0x45

#define TUN_R_SCAN_BAND                    0x47
#define TUN_R_PLAY                         0x49

#define TUN_R_STOP_ANNOUNCEMENT            0x4b
#define TUN_R_SET_BAND                     0x4f
#define TUN_R_GET_DATA_FRQ                 0x51

#define TUN_R_GET_DATA_TMC                 0x53
#define TUN_R_GET_DATA_CT                  0x55
                
#define TUN_R_GET_DATA_RADIOTEXT           0x57
#define TUN_R_GET_DATA_TESTMODE            0x59

#define TUN_R_GET_DATA_AFLIST              0x5b
#define TUN_R_GET_DATA_AFLIST_V2           0x5d

#define TUN_R_GET_DATA_AFLIST_V2_ELEMENT   0x5f
#define TUN_R_GET_DATA_RDS_RAW             0x6d

#define TUN_R_GET_DATA_LSM                 0x6f
#define TUN_R_ADJUST_SEEKLEVEL             0x61

#define TUN_R_ADJUST_TINA                  0x63
#define TUN_R_MEASURE                      0x65

#define TUN_R_SET_DIAG_MODE                0x67
#define TUN_R_CHECK_SUPPLY                 0x69

#define TUN_R_SUPPLY_ERROR                 0x6b
#define TUN_R_SET_SEEKLEVEL                0x71

#define TUN_R_SET_PTY                      0x73
#define TUN_R_SET_SCANTIME                 0x75

#define TUN_R_SET_HICUT                    0x7b
#define TUN_R_SET_RDBID                    0x7d

#define TUN_R_SET_FEATURE                  0x77
#define TUN_R_OPERATION                    0x79

#define TUN_R_MEASURE_MODE                 0x7f
#define TUN_R_SET_STATIC_LIST              0x81

#define TUN_R_AUTOSTORE_STATIC_LIST        0x83
#define TUN_R_SET_CONFIG_LIST              0x93

#define TUN_R_SCAN_LIST                    0x85
#define TUN_R_SEL_LIST_ELEM                0x87

#define TUN_R_ACT_LIST_ELEM                0x89
#define TUN_R_SAVE_STATIC_LIST_ELEM        0x8b

#define TUN_R_MAKE_CONFIG_LIST             0x8d
#define TUN_R_UPDATE_CONFIG_LIST           0x8f

#define TUN_R_GET_CONFIG_LIST              0x91
#define TUN_R_GET_CONFIG_LIST_ELEMENT      0x95

#define TUN_R_GET_STATIC_LIST              0x97

#define TUN_R_GET_STATIC_LIST_ELEMENT      0x99
#define TUN_R_ACT_PTY_LIST_ELEM            0xa1

#define TUN_R_SAVE_PTY_LIST_ELEM           0xa3
#define TUN_R_GET_PTY_LIST                 0xa5
#define TUN_R_SET_ANTENNA                  0xB3

/* Newly added    */

#define TUN_R_DELETE_STATIC_LIST_ELEM     0x33
#define TUN_R_CLEAR_STATIC_LIST           0x9B

#define TUN_R_ATM_CONTAINER               0xB1

#define TUN_R_SNAPSHOT                    0xBD
#define TUN_R_MONITOR_STATION             0xBF

#define TUN_R_CONFIGURE_ANTENNA           0XB9
/*---------------------------------------------*/

#define  TUN_C_CONFIGURE_ANTENNA_LEN		4

/*--------------------------------------------------*/
/*  Defines commam to All messages                  */
/*                                                  */
/*--------------------------------------------------*/

#define TU_FOREGROUND                      00
#define TU_BACKGROUND                      01

#define TU_ABS_VALUE                       0x00
#define TU_REL_VALUE                       0x01    

#define TUN_LIST_TYPE_STATIC               0x00
#define TUN_LIST_TYPE_CONFIG               0x01


/*--------------------------------------------------*/
/*  Parameter of Message TUN_C_AUDIO_FG_BG          */
/*  u8MsgCode ->  0x22                              */
/*--------------------------------------------------*/

#define TUN_AUDIO_FG                        0x00
#define TUN_AUDIO_BG                        0x01

#define TUN_C_AUDIO_FG_BG_LEN               4

#define TUN_C_AUD_FGBG_TEMP_FM              1
#define TUN_C_AUD_FGBG_REAL_FM              0

#define TUN_C_CHANGE_TO_BG                  0



/*--------------------------------------------------*/




/*--------------------------------------------------*/
/*  Parameter of Message TUN_C_COMPONENT_STATUS     */
/*  u8MsgCode ->  0x24                              */
/*--------------------------------------------------*/

#define TUN_COMPONENT_STATUS_ACTIVE         0x01
#define TUN_COMPONENT_STATUS_INACTIVE       0x02

#define TUN_C_COMPONENT_STATUS_LEN          02


/*--------------------------------------------------*/



/*--------------------------------------------------*/
/*  Parameter of Message TUN_C_SET_STATIC_LIST      */
/*  u8MsgCode ->  0x80                              */
/*--------------------------------------------------*/

#define TUN_C_SET_STATIC_LIST_LEN          5


/*--------------------------------------------------*/


/*--------------------------------------------------*/
/*  Parameter of Message TUN_C_SEL_STATIC_LIST_ELEM */
/*  u8MsgCode ->  0x86                              */
/*--------------------------------------------------*/

#define TUN_C_SEL_LIST_ELEM_LEN            6

/*--------------------------------------------------*/

/*--------------------------------------------------*/
/*  Parameter of Message TUN_C_GET_STATIC_LIST      */
/*  u8MsgCode ->  0x96                              */
/*--------------------------------------------------*/

#define TUN_C_GET_STATIC_LIST_LEN           5

#define TUN_STATIC_LIST_FIRST_ELEMENT       1

#define TUN_STATIC_LIST_LAST_ELEMENT_5      5   // 5 static elements

#define TUN_STATIC_LIST_LAST_ELEMENT_6      6    // 6 static elements

#define TUN_STATIC_LIST_LAST_ELEMENT_10     10   // 10 static elements


/*--------------------------------------------------*/


/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SAVE_STATIC_LIST_ELEM */
/*  u8MsgCode ->  0x8a                               */
/*---------------------------------------------------*/

#define TUN_C_SAVE_STATIC_LIST_ELEM_LEN           2


/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SAVE_STATIC_LIST_ELEM */
/*  u8MsgCode ->  0x40                               */
/*---------------------------------------------------*/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_TMCTUNER_VAG
#define TUN_C_SET_FRQ_LEN                 11   
#else
#define TUN_C_SET_FRQ_LEN                 10
#endif

/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SEEK                  */
/*  u8MsgCode ->  0x44                               */
/*---------------------------------------------------*/
#define TUN_C_SEEK_LEN                    9

#define TUN_STATE_PLAY                    0x00
#define TUN_STATE_SEEK                    0x01
#define TUN_STATE_STOP                    0x02

#define TUN_SEEK_NORM                     0x00
#define TUN_SEEK_PERMANENT_MSTEP          0x01
#define TUN_SEEK_PERMANENT_SEEK           0x02
#define TUN_SEEK_TP_SEEK                  0x03
#define TUN_SEEK_LEARN                    0x04
#define TUN_SEEK_PTY                      0x05
#define TUN_SEEK_TMC                      0x06
#define TUN_SEEK_UPDATE_LANDSCAPE         0x07


/* Seek direction ( u8Direction ) */

#define TUN_SEEK_DIRECTION_UP             0x01
#define TUN_SEEK_DIRECTION_DOWN           0xff




/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_PLAY_LEN              */
/*  u8MsgCode ->  0x48                               */
/*---------------------------------------------------*/
#define TUN_C_PLAY_LEN                 9         



/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SET_FEATURE           */
/*  u8MsgCode ->  0x76                               */
/*---------------------------------------------------*/

#define TUN_C_SET_FEATURE_LEN             13
#define TUN_FEATURE_SWITCH_TM_DATA			0x1000

/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SCAN_BAND             */
/*  u8MsgCode ->  0x46                               */
/*---------------------------------------------------*/
/*Different scan mode types */

#define TUN_SCAN_NEXT_AVAIL_PI              0x00
#define TUN_SCAN_NEXT_AVAIL_FRQ             0x01
#define TUN_SCAN_NEXT_SEEK_FRQ              0x02

/* length of scan band      */
#define TUN_C_SCAN_BAND_LEN             3


/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_GET_DATA              */
/*  u8MsgCode ->  0x26                               */
/*---------------------------------------------------*/

#define TUN_C_GET_DATA_LEN             4


// #define TUN_GET_DATA_ALL_DATA  -    Not supported.
#define TUN_GET_DATA_NO_LIST_DATA      0x02
#define TUN_GET_DATA_LIST_DATA         0x03
#define TUN_GET_DATA_AS_SPECIFIED      0x10



/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_SET_HICUT             */
/*  u8MsgCode ->  0x7A                               */
/*---------------------------------------------------*/

#define TUN_C_SET_HICUT_LEN             5

/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_GET_DATA_AFLIST_V2    */
/*  u8MsgCode ->  0x5C                               */
/*---------------------------------------------------*/

#define TUN_C_GET_DATA_AFLIST_V2_LEN                  3

#define TUN_GET_DATA_AFLIST_V2_NOTIF_OFF              0x00
#define TUN_GET_DATA_AFLIST_V2_NOTIF_ON_TESTMODE_ON   0x01
#define TUN_GET_DATA_AFLIST_V2_NOTIF_SING_REQ_ON      0x02



/*-------------------------------------------------*/
/*  Parameter of Message TUN_C_ADJUST_SEEKLEVEL    */
/*  u8MsgCode ->  0x60                             */
/*-------------------------------------------------*/

#define TUN_C_ADJUST_SEEKLEVEL_LEN                  3

#define TUN_ADJUST_SEEKLEVEL_DX1_DIST1              0x00
#define TUN_ADJUST_SEEKLEVEL_DX2_DIST2              0x01
#define TUN_ADJUST_SEEKLEVEL_DX3_DIST3              0x02
#define TUN_ADJUST_SEEKLEVEL_LOC1_LOCAL1            0x03
#define TUN_ADJUST_SEEKLEVEL_LOC2_LOCAL2            0x04
#define TUN_ADJUST_SEEKLEVEL_LOC3_LOCAL3            0x05
#define TUN_ADJUST_SEEKLEVEL_CALIBERATE_SEEK_LEVEL  0xff




/*-------------------------------------------------*/
/*  Parameter of Message TUN_C_ADJUST_SEEKLEVEL    */
/*  u8MsgCode ->  0x60                             */
/*-------------------------------------------------*/

#define TUN_C_MEASURE_LEN                  3

#define TUN_MEASURE_FIELD_STRENGTH         0x00

/*-------------------------------------------------*/
/*  Parameter of Message TUN_C_OPERATION           */
/*  u8MsgCode ->  0x78                             */
/*-------------------------------------------------*/

#define TUN_C_OPERATION_LEN                  4

#define TUN_OPERATION_DISABLE           0x00
#define TUN_OPERATION_ENABLE            0x01

#define TUN_OPERATION_TP_SEEK           0x10
#define TUN_OPERATION_BGACTION          0x20

/*-------------------------------------------------*/
/*  Parameter of Message TUN_C_STOP_ANNOUNCEMENT   */
/*  u8MsgCode ->  0x4A                             */
/*-------------------------------------------------*/

#define TUN_C_STOP_ANNOUNCEMENT_LEN          3

#define TUN_ANNOUNCEMENT_STOP_CURRENT      0x00
#define TUN_ANNOUNCEMENT_STOP_ALL          0x01

/*-------------------------------------------------*/
/*  Parameter of Msg TUN_C_AUTOSTORE_STATIC_LIST   */
/*  u8MsgCode ->  0x82                             */
/*-------------------------------------------------*/
#define TUN_C_AUTOSTORE_STATIC_LIST_LEN      5

/*  u8AutostoreType       */
#define TUN_AUTOSTORE_AS_NORMAL            0x00
#define TUN_AUTOSTORE_AS_INITIAL           0x01

/*  u8ListID              */
#define TUN_LIST_ID_FIRST                   0x00 

#define TUN_LIST_ID_LAST_4                  0x04   // 5 static Lists

#define TUN_LIST_ID_LAST_5                  0x05   // 6 static Lists



/*  u8SortingCriteria       */
#define TUN_NO_SORT                        0x00
#define TUN_SORT_PS                        0x01 
#define TUN_SORT_PI                        0x02   
#define TUN_SORT_FIELDSTRENGTH             0x03
#define TUN_SORT_FREQUENCY                 0x04   

// order of the List
#define TUN_SORT_DESCENDING                0x00
#define TUN_SORT_ASCENDING                 0x80

/*--------------------------------------------------*/
/* Parameter of the  Msg TUN_C_ACT_LIST_ELEM        */
/* u8MsgCode -> 0x88                                */
/*--------------------------------------------------*/
#define TUN_C_ACT_LIST_ELEM_LEN            0x03

/*--------------------------------------------------*/
/* Parameter of the  Msg TUN_C_MAKE_CONFIG_LIST     */
/* u8MsgCode -> 0x8C                                */
/*--------------------------------------------------*/
#define TUN_C_MAKE_CONFIG_LIST_LEN         0x8 

#define TUN_MAKE_CONFIG_FIRST_ELEM         00 
#define TUN_MAKE_CONFIG_LAST_ELEM         127 


/* u8GroupingCriteria */
#define TUN_CONFIG_NO_GROUP          0x00
#define TUN_CONFIG_NAME_TYPE         0x01
#define TUN_CONFIG_TMC               0x02
#define TUN_CONFIG_TP                0x03

/* u8ListID */
#define TUN_CONFIG_LIST_FM          0x00
#define TUN_CONFIG_LIST_TMC         0x01

/* u8ConfigListType  */
#define TUN_CONFIG_LIST_TYPE_FROZEN          0x10
#define TUN_CONFIG_LIST_TYPE_TRACKING        0x20
#define TUN_CONFIG_LIST_TYPE_DYNAMIC         0x40


/* u8FilterCriteria */
#define TUN_CONFIG_FILTER_TP          0x01
#define TUN_CONFIG_FILTER_TMC         0x02
#define TUN_CONFIG_FILTER_TP_SELF     0x04
#define TUN_CONFIG_FILTER_NO_FILTER   0x00

/*--------------------------------------------------*/
/* Parameter of the  Msg TUN_C_UPDATE_CONFIG_LIST   */
/* u8MsgCode -> 0x8E                                */
/*--------------------------------------------------*/
#define TUN_C_UPDATE_CONFIG_LIST_LEN  4

#define TUN_UPDATE_CONF_REFRESH       0x00
#define TUN_UPDATE_CONF_RELEASE       0x01

/*--------------------------------------------------*/
/* Parameter of the  Msg TUN_C_GET_CONFIG_LIST   */
/* u8MsgCode -> 0x90                                */
/*--------------------------------------------------*/
#define TUN_C_GET_CONFIG_LIST_LEN  5

/*--------------------------------------------------*/
/* Parameter of the  Msg TUN_C_SET_PI               */
/* u8MsgCode -> 0x42                                */
/*--------------------------------------------------*/
#define TUN_C_SET_PI_LEN              0x13  

/* u8AbsOrRel */
#define TUN_SET_PI_ABS                0x00
#define TUN_SET_PI_REL                0x01
#define TUN_SET_PI_NEXT_AVAIL         0x02

/*-----------------------------------------*/
/* Parameter of the  Msg TUN_C_SET_RDBID   */
/* u8MsgCode -> 0x7c                       */
/*-----------------------------------------*/
#define TUN_C_SET_RDBID_LEN           85

#define TUN_RDBID_LIST_MAX_SIZE       20

/*--------------------------------------------------*/
/* Parameter of the  Msg C_SET_SHARX_LEVEL          */
/* u8MsgCode -> 0xA6                                */
/*--------------------------------------------------*/
#define TUN_C_SET_SHARX_LEVEL_LEN     0x05



/*--------------------------------------------------*/
/* Parameter of the  Msg C_GET_DATA_RDS_RAW         */
/* u8MsgCode -> 0x6C                                */
/*--------------------------------------------------*/
#define TUN_C_GET_DATA_RDS_RAW_LEN     0x09

/*--------------------------------------------------*/
/* Parameter of the  Msg C_CHECK_SUPPLY          */
/* u8MsgCode -> 0x68                               */
/*--------------------------------------------------*/
//#define TUN_C_PHANTOM_ANTENNA      0x00
 #define TUN_C_IF_OUPUT1             0x01
//#define TUN_C_PHANTOM_ANTENNA2     0x02

#define TUN_C_CHECK_SUPPLY_LEN     3

/*--------------------------------------------------*/
/* Parameter of the  Msg C_SUPPLY_ERROR          */
/* u8MsgCode -> 0x6A                               */
/*--------------------------------------------------*/
#define TUN_C_CLEAR_PHANTOM_ERRORS      0x00

#define TUN_C_SUPPLY_ERROR_LEN     3

/*--------------------------------------------------*/
/* Parameter of the  Msg C_DELETE_STATIC_LIST_ELEM  */
/* u8MsgCode -> 0x32                                */
/*--------------------------------------------------*/
#define TUN_C_DELETE_STATIC_LIST_ELEM_LEN     0x04



/*--------------------------------------------------*/
/* Parameter of the  Msg C_CLEAR_STATIC_LIST */
/* u8MsgCode -> 0x9A                                */
/*--------------------------------------------------*/
#define TUN_C_CLEAR_STATIC_LIST_LEN     0x03

/*---------------------------------------------------*/
/* Parameter of C_SET_ANTENNA                        */
/*---------------------------------------------------*/
#define TUN_C_SET_ANTENNA_LEN     0x03

/*---------------------------------------------------*/
/* parameters for wire message C_PI_PS_COMBINATION                        */
/*---------------------------------------------------*/
#define TUN_C_NEW_PI_PS_COMBINATION_LEN     0x11
#define TUN_PS_NAME_LEN                     0x08

/*--------------------------------------------------------*/
/* parameters for wire message SET_AUTOCOMPARE_PARAMETERS */
/*--------------------------------------------------------*/
#define TUN_C_SET_AUTOCOMPARE_PARAMETERS_LEN     0x05

/*----------------------------------------------------*/
/* TMC Status				                          */
/*----------------------------------------------------*/
#define  TUN_RU_RESPONSE_TMC_UNDECODED              0x0400
#define  TUN_RU_RESPONSE_TMC_NO                     0x0800
#define  TUN_RU_RESPONSE_TMC_YES                    0x0c00
#define  TUN_RU_RESPONSE_TMC_QUALITY_LOST           0x1000
#define  TUN_RU_RESPONSE_TMC_8A_LOST                0x1400

//#define STATIC_LIST_NUM_OF_ELEMENTS          TUN_STATIC_LIST_LAST_ELEMENT_5

#define TUN_C_SET_DIAG_MODE_LEN          3

#define TUN_C_CALIBRATE_LEN                3
#define TUN_C_ALIGN_TDA7528_LEN            4

#define TUN_C_SET_BAND_LEN                  3
#define TUN_C_SNAPSHOT_LEN                  3

//Defines for Developer Testmode

#define TUN_MODE_DDA                      4
#define TUN_MODE_DDS                      8
#define TUN_MODE_SINGLE                   0x10


/*--------------------------------------------------*/
/* Defines of the  Msg RU_TUN_R_SET_FRQ (u8StateAndActType)   */
/* u8MsgCode -> 0x41                                */
/*--------------------------------------------------*/

#define TUN_ACT_STATE_UPDATE_LANDSCAPE        0x09

//rrb1kor

/*---------------------------------------------------*/
/*  Parameter of Message TUN_C_MONITOR_STATION       */
/*  u8MsgCode ->  0xBE                               */
/*---------------------------------------------------*/
#define TUN_C_MONITOR_STATION_LEN                    0x09



#endif /* TUN_MSG_DEFINES_H */

