/************************************************************************
* FILE:           tun_MessageQ.h
* PROJECT:        g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner message Que.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 25.01.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
                from NISSAN LCN2Kai
* 19.08.14  | VND4KOR    | Changed static user defined queue to dynamic STL queue
* 17.05.16  | LSH1HC     | Changed queue object pointer to object, Added semaphore for synchronization
*************************************************************************/

#ifndef TUN_MESSAGEQ_H
#define TUN_MESSAGEQ_H

#include "tun_defines.h"

#include <queue>

using namespace std;


class tun_Message
{
public:

  /* Constructor */
  tun_Message();
  tun_Message( tU8* pu8Message, tU32 u32MessageLen);

  /* Destructors */
  ~tun_Message( );
  /*Copy constructor*/
  tun_Message(const tun_Message &obj);
  /*assignment operator*/
  tun_Message& operator=(const tun_Message &obj);
  /** Getter for message length */
  inline tU32 u32GetMessageLength() {   return m_u32MessageLen;  }
  /** Getter for message data*/
  inline tU8* u8GetMessageData() {  return m_pu8Message;  }
 
private:

  /*------*/
  /* Data */
  /*------*/

  tU8*  m_pu8Message;
  tU32  m_u32MessageLen;  

};





/*--------------------------------*/
/* class tun_MessageQ definition  */
/*--------------------------------*/

class tun_MessageQ
{
public:
  /* Constructor */
  tun_MessageQ( );

  /* Destructors */
  ~tun_MessageQ( ); 


  /*----------------------------------------------------*/
  /* Sends the next message in the Q  for processing    */
  /*----------------------------------------------------*/
  tBool fGetNextMessage( tU8* pu8Message, tU32* u32MessageLen  );

  /*------------------------------------------------------------------*/
  /* All incoming messages to the tuner component are put in Q, with
     vAddNewMessageInQ                                                */
  /*------------------------------------------------------------------*/
  tVoid vAddNewMessageInQ( tU8* pu8Message, tU32 u32MessageLen, tU8 u8Priority);

  /*------------------------------------------------------------------
    Clearing all message in queue
  ------------------------------------------------------------------*/
  tVoid vClearQueue();
  /*------------------------------------------------------------*/
  /* Once the message is sent successfully below function will be called   */
  /*------------------------------------------------------------*/
  tVoid vMessageSuccessfullySent( );

  tBool fCheckWaitingForConfirmation( )const;

  tVoid vWaitingForConfirmation();
  tVoid vResetWaitingForConfirmation();

private:

  /* Message Queue */
  queue<tun_Message> m_SenderQueue;

  /*----------------------------------------------------*/
  /* When data is sent to SPI, waiting for confirmation */
  /*----------------------------------------------------*/ 
  tBool m_fWaitingForConfirmation;

  /** Remove message from the queue */
  tVoid vRemoveFrontMsgFromQueue( );
};

#endif /* TUN_MESSAGEQ_H */
