/************************************************************************
* FILE:           tun_ActualData.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    Actual Data of Tuner: Actual frequency, band, feature
                  will be contained in this class.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 23.02.05  | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

#ifndef TUN_ACTUALDATA_H
#define TUN_ACTUALDATA_H
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "tun_Class_ForwardDecl.h"
#include "tun_Singleton.h"

//class tun_Utility;
/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

/*------------------------------------------------------*/
/* class tun_MainStatus definition                      */
/*                                                      */
/* Description: Message contains the main tuner state   */
/*------------------------------------------------------*/
class clConfigInterface;
class clTmcTuner_Method_S_JAPAN_SET_AREA;
class tun_Data_MainStatus
{  

  public:
    
    /*---------------*/
    /* Constructor   */
    /*---------------*/
    tun_Data_MainStatus (  );

    /*---------------*/
    /* Destructors   */
    /*---------------*/
    ~tun_Data_MainStatus (  );     
      

    /*----------------*/
    /* Get functions  */
    /*----------------*/
    tU8 u8GetAudioSinkTuner( ) const;

    tU8 u8GetBackgroundModeTuner( ) const;

    tU8 u8GetStatus( ) const ;

    tU8 u8GetTunerHeader () const;
    
    tU8 u8GetBand () const ;
    
    tU8 u8GetAutostore () const;

    tU8 u8GetMode () const;
    
    tU8 u8GetState () const;

    tU8 u8GetActType () const;
    
    tU8 u8GetAnnouncement () const;
    
    tU8 u8GetLastActionState () const;
    
    tU32 u32GetFeatures () const;
    
    tU32 u32GetAvailFlags () const;
    
    tU8 u8GetStaticListID () const;
    
    tU8 u8GetStaticListElementID ()const;

    tU8 u8GetConfigListID ()const;

    tU8 u8GetConfigListElementID ()const; 

    tU32 u32GetSystemState ()const;

    


   
    /*------------------*/
    /* Set functions    */
    /*------------------*/ 

    tVoid vSetStatus( tU8 u8Status );

    tVoid vSetAudioSinkTuner( tU8 u8AudioSinkTuner );

    tVoid vSetBackgroundModeTuner( tU8 u8BackgroundModeTuner );

    tVoid vSetTunerHeader(tU8 u8TunerHeader);

    tVoid vSetBand(tU8 u8Band);

    tVoid vSetAutostore(tU8 u8Autostore);

    tVoid vSetMode(tU8 u8Mode);

    tVoid vSetState(tU8 u8State);

    tVoid vSetActType(tU8 u8ActType);

    tVoid vSetAnnouncement(tU8 u8Announcement);

    tVoid vSetLastActionState(tU8 u8LastActionState);

    tVoid vSetFeatures(tU32 u32Features);

    tVoid vSetAvailFlags(tU32 u32AvailFlags);

    tVoid vSetStaticListID(tU8 u8StaticListID);

	tVoid vSetStaticListID(tU8 u8StaticListID,tU8 u8BackGroundTuner);

    tVoid vSetStaticListElementID(tU8 u8StaticListElementID);

	tVoid vSetStaticListElementID(tU8 u8StaticListElementID,tU8 u8BackGroundTuner);

    tVoid vSetConfigListID(tU8 u8ConfigListID);

    tVoid vSetConfigListElementID(tU8 u8ConfigListElementID);

    tVoid vSetSystemState (tU32 u32SystemState);

    

  private:            
     

    /*--- 8Status ---*/
    /*----------------------
      ACTIVE            0x01
      INACTIVE          0x02
    ------------------------*/
    tU8 m_u8Status;


    /*-------- u8AudioSink ---------*/
    /*----------------------------------------------
      USR1 switched Tuner into FG   -------1 = 0x01
      USR1 switched Tuner into BG   -------0 = 0x00
                            
      TA switched Tuner into FG     ------1- = 0x02
      TA switched Tuner into BG     ------0- = 0x00 

      TIM switched Tuner into FG    -----1-- = 0x04
      TIM switched Tuner into BG    -----0-- = 0x00

      PTY switched Tuner into FG    ----1--- = 0x08
      PTY switched Tuner into BG    ----0--- = 0x00

      NEWS switched Tuner into FG   ---1---- = 0x10
      NEWS switched Tuner into BG   ---0---- = 0x00
    ------------------------------------------------*/
    tU8 m_u8AudioSinkTuner;

    tU8 m_u8BackgroundModeTuner;



    tU8 m_ou8TunerHeader; 
    
    
        
    /*--- u8Band ---*/
    /*-----------------------
      FM              0x00
      MW              0x01
      LW              0x02
      SW              0x03
      DCF77           0x04
      TRAFFICBAND     0x05
      WEATHERBAND     0x06
      Current band    0xFF
    -------------------------*/
    tU8 m_ou8Band; 
    
    
    
    tU8 m_ou8Autostore;      

    tU8 m_ou8Mode;

    
    
    tU8 m_ou8State;      

    tU8 m_ou8ActType;  

    
    /*--- u8Announcement ---*/
  /*--------------------------
    NO_ANNOUNCEMENT   -----000
    TA                -----001
    PTY               -----010
    PTY_31            -----011
    NEWS              -----100
    TA_ACTIVE         ---1----
    EON               --1-----
  ----------------------------*/    
    tU8 m_ou8Announcement;
    

    //  LAST_ACTION_NOT_OK
    //  LAST_ACTION_OK      
    tU8 m_ou8LastActionState;      

    
    //  Bit 0 AF_MODE
    //  Bit 1 CT _MODE
    //  Bit 2 LOC_MODE
    //  Bit 3 unused
    //  Bit 4 MONO_MODE
    //  Bit 5 PSFIX_MODE
    //  Bit 6 PTY_MODE
    //  Bit 7 REG_MODE
    //  Bit 8 RT_MODE
    //  Bit 9 SEARCH_MODE
    //  Bit 10  SEEK_SENSE_MODE
    //  Bit 11  SHARX_MODE
    //  Bit 12  TM_DATA_MODE
    //  Bit 13  TA_MODE
    //  Bit 14  TMC_MODE
    //  Bit 15  KHZ50_MODE
    //  - Bit 31  reserved      
    tU32 m_ou32Features;      

    
    //  Bit 0 FRQ available
    //  Bit 1 PS available
    //  Bit 2   PI available
    //  Bit 3   PTY available
    //  Bit 4   CT available
    //  Bit 5 TMC available
    //  Bit 6 RDS available
    //  Bit 7 REG available
    //  Bit 8 AF available
    //  Bit 9   PTY_EON available
    //  Bit 10  RT (Radiotext) available
    //  Bit 11  JapanPS available
    //  Bit 12-13 Autocompare available
    //  NO
    //  CURRENT_STATIC_LIST
    //  ANY_STATIC_LIST
    //  Bit 14-32 reserved      
    tU32 m_ou32AvailFlags;      

    
    //  FM1
    //  FM2
    //  FMT
    //  MW
    //  LW      
    tU8 m_ou8StaticListID;      
    
    tU8 m_ou8StaticListElementID;
    
    tU8 m_ou8ConfigListID;
    
    tU8 m_ou8ConfigListElementID; 

    tU32 m_u32SystemState;

};









/*--------------------------------------------------------*/
/* class tun_Data_Station definition                      */
/*                                                        */
/* Description: Message contains the current station data */
/*--------------------------------------------------------*/
class tun_Data_Station
{
  public:
      
      /*---------------*/
      /* Constructor   */
      /*---------------*/
      tun_Data_Station (  );

     /*---------------*/
     /* Destructors   */
     /*---------------*/
      ~tun_Data_Station (  );

      

      /*----------------*/
      /* Get functions  */
      /*----------------*/      
      /*u8TunerHeader*/
      tU8 u8GetTunerHeader () const;

      /*u32AvailFlags*/
      tU32 u32GetAvailFlags () const;

      /*u32Frequency*/
      tU32 u32GetFrequency () const;

      /*u16PI*/
      tU16 u16GetPI () const;

      /*sPSName*/
      const tChar* pcocGetPSName () const;

      /*e8Band*/
      tU8 u8GetBand () const ;

      /*e8AtStationTPinfo*/
      tU8 u8GetTPInfo() const;

      /*u16PresetListID*/
      tU16 u16GetStaticListID () const;

      /*u8ActiveStationList*/
      tU8 u8GetConfigListID ()const;

      /*u16StaticListElementID*/
      tU16 u16GetStaticListElementID ()const;

      /*u16ConfigListElementID*/
      tU16 u16GetConfigListElementID ()const;

      /*u8AtStationInfoBits*/
      tU8 vGetFrequencyQualification()const;

      /*u8PTY*/
      tU8 u8GetPTY () const;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

      /*u8FieldStrngth*/
      tU8 u8GetFieldStrength() const;

      /*u8Quality*/
      tU8 u8GetQuality() const;

      /*b8HDStationInfoBits*/
      tU8 u8GetHDStationInfoBits() const;

      /*u32StationInfoHDStationID*/
      tU32 u32GetStationInfoHDStationID() const;

      /*sHDCallSign*/
      const tChar* pcocGetHDCallSign() const;

      /*e8HDCallSignTextEncoding*/
      tU8 u8GetHDCallSignTextEncoding() const;

      /*u8HDStationGenre*/
      tU8 u8GetHDStationGenre() const;

      /*b8HDAudioPrgmAvail*/
      tU8 u8GetHDAudioPrgmAvail() const;

      /*u8HDQuality*/
      tU8 u8GetHDQuality() const;

      /*e8ActiveHDAudPrgm*/
      tU8 u8GetActiveHDAudPrgm() const;

      /*StationLogo*/
      //tChar* pcocGetStationLogo();

      /*b8DRMStationInfoBits*/
      tU8 u8GetDRMStationInfoBits() const;

      /*u32DRMServiceId*/
      tU32 u32GetDRMServiceId() const;

      /*sDRMServiceLabel*/
      const tChar* pcocGetDRMServiceLabel()  const;

      /*u8DRMPTY*/
      tU8 u8GetDRMPTY() const;

      /*b16DRMAnnouBits*/
      tU16 u16GetDRMAnnouBits() const;

      /*b8DRMNumberOfAudioServices*/
      tU8 u8GetDRMNumberOfAudioServices() const;

      /*u8DRMQuality*/
      tU8 u8GetDRMQuality() const;

      /*u8DRMServiceShortId*/
      tU8 u8GetDRMServiceShortId() const;

      /*u8Drmlanguage*/
      tU8 u8GetDrmlanguage() const;

      /*u32DrmlanguageCode*/
      tU32 u32GetDrmlanguageCode() const;

      /*u16DrmCountryCode*/
      tU16 u16GetDrmCountryCode() const;

      tS8 s8GetDrmFrequencyCorrection() const;
#endif
      tU8 u8GetOperationFlags () const;
      
      tU16 u16GetPackedInfo () const;
      
      tU32 u32GetBaseFrequency () const;

      tU32 u32GetBGFrequency () const;

      /*------------------*/
      /* Set functions    */
      /*------------------*/      
      /*u8TunerHeader*/
      tVoid vSetTunerHeader (tU8 u8TunerHeader);

      /*u32AvailFlags*/
      tVoid vSetAvailFlags (tU32 u32AvailFlags);

      /*u32Frequency*/
      tVoid vSetFrequency (tU32 u32Frequency);

      /*u16PI*/
      tVoid vSetPI (tU16 u16PI);

      /*sPSName*/
      tVoid vSetPSName (const tChar* pcocPSData);

      /*e8Band*/
      tVoid vSetBand(tU8 u8Band);

      /*e8AtStationTPinfo*/
      tVoid vSetTPInfo(tU8 u8TPInfo);

      /*u16PresetListID*/
      tVoid vSetStaticListID(tU16 u16StaticListID);

      /*u8ActiveStationList*/
       tVoid vSetConfigListID(tU8 u8ConfigListID);

       /*u16StaticListElementID*/
       tVoid vSetStaticListElementID(tU16 u16StaticListElementID);

       /*u16ConfigListElementID*/
       tVoid vSetConfigListElementID(tU16 u16ConfigListElementID);

       /*u8AtStationInfoBits*/
       tVoid vSetFrequencyQualification(tU8 u8FreqQualification);

       /*u8PTY*/
       tVoid vSetPTY (tU8 u8PTY);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

       /*u8FieldStrngth*/
       tVoid vSetFieldStrngth(tU8 u8FieldStrngth);

       /*u8Quality*/
       tVoid vSetQuality(tU8 u8Quality);

       /*b8HDStationInfoBits*/
       tVoid vSetHDStationInfoBits(tU8 u8HDStationInfoBits);

       /*u32StationInfoHDStationID*/
       tVoid vSetStationInfoHDStationID(tU32 u32StationInfoHDStationID);

       /*sHDCallSign*/
       tVoid vSetHDCallSign(const tChar* pcocPSData);

       /*e8HDCallSignTextEncoding*/
       tVoid vSetHDCallSignTextEncoding(tU8 u8HDCallSignTextEncoding);

       /*u8HDStationGenre*/
       tVoid vSetHDStationGenre(tU8 u8HDStationGenre);

       /*b8HDAudioPrgmAvail*/
       tVoid vSetHDAudioPrgmAvail(tU8 u8HDAudioPrgmAvail);

       /*u8HDQuality*/
       tVoid vSetHDQuality(tU8 u8HDQuality);

       /*e8ActiveHDAudPrgm*/
       tVoid vSetActiveHDAudPrgm(tU8 u8ActiveHDAudPrgm);

       /*StationLogo*/
       //tVoid vSetStationLogo(const tChar* pcocLogoData);

       /*b8DRMStationInfoBits*/
       tVoid vSetDRMStationInfoBits(tU8 u8DRMStationInfoBits);

       /*u32DRMServiceId*/
       tVoid vSetDRMServiceId(tU32 u32DRMServiceId);

       /*sDRMServiceLabel*/
       tVoid vSetDRMServiceLabel(const tChar* pcocPSData);

       /*u8DRMPTY*/
       tVoid vSetDRMPTY(tU8 u8DRMPTY);

       /*b16DRMAnnouBits*/
       tVoid vSetDRMAnnouBits(tU16 u16DRMAnnouBits);

       /*b8DRMNumberOfAudioServices*/
       tVoid vSetDRMNumberOfAudioServices(tU8 u8DRMNumberOfAudioServices);

       /*u8DRMQuality*/
       tVoid vSetDRMQuality(tU8 u8DRMQuality);

       /*u8DRMServiceShortId*/
       tVoid vSetDRMServiceShortId(tU8 u8DRMServiceShortId);

       /*u8Drmlanguage*/
       tVoid vSetDrmlanguage(tU8 u8Drmlanguage);

       /*u32DrmlanguageCode*/
       tVoid vSetDrmlanguageCode(tU32 u32DrmlanguageCode);

       /*u16DrmCountryCode*/
       tVoid vSetDrmCountryCode(tU16 u16DrmCountryCode);

       tVoid vSetDrmFrequencyCorrection(tS8 s8DrmFrequencyCorrection);
#endif

      tVoid vSetOperationFlags (tU8 u8OperationFlags);

      tVoid vSetPackedInfo (tU16 u16PackedInfo);

	  tVoid vSetFrequency (tU32 u32Frequency,tU8 u8BackGroundTuner);

	  tVoid vSetBaseFrequency (tU32 u32Frequency);

      tVoid vSetBGFrequency (tU32 u32Frequency);

	  tVoid vSetPSName (tChar* pcocPSData,tU8 u8BackGroundTuner); 

	  /*sPSName*/
	  tChar  m_acPSName[8];
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20

	  /*sHDCallSign*/
	  tChar  m_acHDCallSign[16];

	  /*sDRMServiceLabel*/
	  tChar  m_acDRMServiceLabel[64];

	  /*StationLogo*/
	  //tChar m_acStationLogo[128];
#endif

  private:

    // Data Members for Class Attributes     
	  /*u8TunerHeader*/
      tU8 m_ou8TunerHeader;

      /*u32AvailFlags*/
      tU32 m_ou32AvailFlags;

      /*u32Frequency*/
      tU32 m_ou32Frequency;

      // PI of station with ECC u16PI
      tU16 m_ou16PI;

      /*e8Band*/
      tU8 m_ou8Band;

      /*e8AtStationTPinfo*/
      tU8 m_ou8TPInfo;

      /*u16PresetListID*/
      tU16 m_ou16StaticListID;

      /*u8ActiveStationList*/
      tU8 m_ou8ConfigListID;

      /*u16StaticListElementID*/
      tU16 m_ou16StaticListElementID;

      /*u16ConfigListElementID*/
      tU16 m_ou16ConfigListElementID;

      /*u8AtStationInfoBits*/
      tU8 m_ou8FrequencyQualification;

      /*u8PTY*/
      tU8 m_ou8PTY;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
      /*u8FieldStrngth*/
      tU8 m_ou8FieldStrngth;

      /*u8Quality*/
      tU8 m_ou8Quality;

      /*b8HDStationInfoBits*/
      tU8 m_ou8HDStationInfoBits;

      /*u32StationInfoHDStationID*/
      tU32 m_ou32StationInfoHDStationID;

      /*e8HDCallSignTextEncoding*/
      tU8 m_ou8HDCallSignTextEncoding;

      /*u8HDStationGenre*/
      tU8 m_ou8HDStationGenre;

      /*b8HDAudioPrgmAvail*/
      tU8 m_ou8HDAudioPrgmAvail;

      /*u8HDQuality*/
      tU8 m_ou8HDQuality;

      /*e8ActiveHDAudPrgm*/
      tU8 m_ou8ActiveHDAudPrgm;

      /*b8DRMStationInfoBits*/
      tU8 m_ou8DRMStationInfoBits;

      /*u32DRMServiceId*/
      tU32 m_ou32DRMServiceId;

      /*u8DRMPTY*/
      tU8 m_ou8DRMPTY;

      /*b16DRMAnnouBits*/
      tU8 m_ou16DRMAnnouBits;

      /*b8DRMNumberOfAudioServices*/
      tU16 m_ou8DRMNumberOfAudioServices;

      /*u8DRMQuality*/
      tU8 m_ou8DRMQuality;

      /*u8DRMServiceShortId*/
      tU8 m_ou8DRMServiceShortId;

      /*u8Drmlanguage*/
      tU8 m_ou8Drmlanguage;

      /*u32DrmlanguageCode*/
      tU32 m_ou32DrmlanguageCode;

      /*u16DrmCountryCode*/
      tU16 m_ou16DrmCountryCode;
	  
	  /**/
	  tS8 m_os8DrmFrequencyCorrection;

#endif

      tU8 m_u8OperationFlags;

      tU16 m_ou16PackedInfo;

      tU32 m_ou32BaseFrequency;

      tU32 m_ou32BGTunerFrequency;

};








/*------------------------------------------------------*/
/* class tun_Data_GetStaticListElem definition          */
/*                                                      */
/* Description: Contains staticlist element details     */
/*------------------------------------------------------*/
class tun_Data_GetStaticListElem
{

public:   

   /*---------------*/
   /* Constructor   */
   /*---------------*/
   tun_Data_GetStaticListElem (  );

   /*---------------*/
   /* Destructors   */
   /*---------------*/
   ~tun_Data_GetStaticListElem(  );

   /*-------------------*/
   /* Get functions     */
   /*-------------------*/
   tU8  u8GetListID( ) const ;

   tU8  u8GetBand( ) const;

   tU8  u8GetElementID( ) const ;

   tU8  u8GetListElementInfo () const; 

   tU32 u32GetAvailFlags( ) const;

   tU32 u32GetFrequency( )const;

   tChar*  pcocGetPSName ();

#ifdef VARIANT_S_FTR_ENABLE_EXT_PRESETLIST

   tU32 u32GetPI(  ) const;

   tU16 u16GetPackedInfo(  ) const;

#endif
   /*------------------*/
   /* Set functions    */
   /*------------------*/

    tVoid u8SetListID( tU8 u8ListID );

    tVoid u8SetElementID( tU8 u8ElementID );

    tVoid u8SetListElementInfo(tU8 u8ListElementInfo);

    tVoid u32SetAvailFlags( tU32 u32AvailFlags );

    tVoid u32SetFrequency( tU32 u32Frequency );

    tVoid vSetPSName (const tChar* pcocPSName);
	
	tVoid vSetBand(tU8 u8Band );

	 tChar m_ocaPSName[8];

#ifdef VARIANT_S_FTR_ENABLE_EXT_PRESETLIST

    tVoid u32SetPI( tU32 u32PI);

    tVoid u16SetPackedInfo( tU16 u16PackedInfo );

#endif

private:

    tU8  m_ou8ListID;

    tU8  m_ou8ElementID;

	tU8  m_ou8Band;

    tU32 m_ou32AvailFlags;

    tU32 m_ou32Frequency;

    //  Bit 0 : List Element Info VALID/INVALID
    tU8 m_ou8ListElementInfo;


#ifdef VARIANT_S_FTR_ENABLE_EXT_PRESETLIST

	tU32 m_ou32PI;

	tU16 m_ou16PackedInfo;

#endif
};

/*------------------------------------------------------*/
/* class tun_Data_GetConfigListElem definition          */
/*                                                      */
/* Description: Contains Make config List elem details  */
/*------------------------------------------------------*/
class tun_Data_GetConfigListElem
{

public:   

   /*---------------*/
   /* Constructor   */
   /*---------------*/
   tun_Data_GetConfigListElem (  );

   /*---------------*/
   /* Destructors   */
   /*---------------*/
   ~tun_Data_GetConfigListElem(  );

   /*-------------------*/
   /* Get functions     */
   /*-------------------*/

    tU8  u8GetListID( )const;

    tU8 u8GetNumOfElementsInList( )const;
   
   /*------------------*/
   /* Set functions    */
   /*------------------*/

    tVoid vSetListID( tU8 u8ListID );

    tVoid vSetNumOfElementsInList( tU8 u8NumOfElementsInList );

private:

    tU8  m_ou8ListID;

    tU8 m_ou8NumOfElementsInList;

};


/*--------------------------------------------------------*/
/* class tun_Data_TMC definition                          */
/*                                                        */
/* Description: Message contains the TMC data             */
/*--------------------------------------------------------*/
class tun_Data_TMC
{
  public:
      
      /*---------------*/
      /* Constructor   */
      /*---------------*/
      tun_Data_TMC (  );

     /*---------------*/
     /* Destructors   */
     /*---------------*/
      ~tun_Data_TMC (  );

      

      /*----------------*/
      /* Get functions  */
      /*----------------*/      
      
      tU8 u8GetTunerHeader () const;
      
      tU16 u16GetTMCData1 () const;
      
      tU16 u16GetTMCData2 () const;
      
      tU16 u16GetTMCData3 () const;
      
      tU16 u16GetTMCData4 () const;


      
      /*------------------*/
      /* Set functions    */
      /*------------------*/      

      tVoid vSetTunerHeader (tU8 u8TunerHeader);

      tVoid vSetu16TMCData1 (tU16 u16TMCData1);

      tVoid vSetu16TMCData2 (tU16 u16TMCData2);

      tVoid vSetu16TMCData3 (tU16 u16TMCData3);

      tVoid vSetu16TMCData4 (tU16 u16TMCData4);

  private:

    // Data Members for Class Attributes     

      tU8 m_ou8TunerHeader;

      tU16 m_ou16TMCData1;

      tU16 m_ou16TMCData2;

      tU16 m_ou16TMCData3;

      tU16 m_ou16TMCData4;

};

/*--------------------------------------------------------*/
/* class tun_Data_Monitor_Station definition              */
/*                                                        */
/* Description: Message contains the Monitor station data */
/*--------------------------------------------------------*/
class tun_Data_Monitor_Station
{
  public:
      
      /*---------------*/
      /* Constructor   */
      /*---------------*/
      tun_Data_Monitor_Station (  );

     /*---------------*/
     /* Destructors   */
     /*---------------*/
      ~tun_Data_Monitor_Station (  );

      

      /*----------------*/
      /* Get functions  */
      /*----------------*/      
      
      tU8 u8GetClient () const;
      
      tU8 u8GetMode () const;
      
      tU8 u8GetQuality () const;
      
      tU32 u32GetPI () const;
      
  


      
      /*------------------*/
      /* Set functions    */
      /*------------------*/      

      tVoid vSetClient (tU8 u8Client);

      tVoid vSetMode (tU8 u8Mode);

      tVoid vSetQuality (tU8 u8Quality);

      tVoid vSetPI (tU32 u32PI);

      

  private:

    // Data Members for Class Attributes     

	  tU8 m_ou8Client;

      tU8 m_ou8Mode;

      tU8 m_ou8Quality;

      tU32 m_ou32PI;

};

/*----------------------------------*/
/* class tun_ActualData definition  */
/*----------------------------------*/
class tun_ActualData : public TUN_Singleton< tun_ActualData>
{
  friend class TUN_Singleton< tun_ActualData>;

public:


     //Low Voltage Start
   tBool m_fIsLowVoltageOnStartup;

   //Low Voltage End
   tBool m_fIsLowVoltageEnd;
	
   // is Testmode Active before Low Voltage ?
   tBool m_bIsTmActiveBeforeLowVoltage;	

   tBool m_bIsVdamfmaudAvailable;
   
   tBool m_bIsTunerShutdown;

  /*-------------*/
  /* Constructor */
  /*-------------*/
private:
  tun_ActualData( );
  clConfigInterface* m_poclConfigInterface;

public:
  /*-------------*/
  /* Destructors */
  /*-------------*/
  virtual ~tun_ActualData( );

  /*---------------------------------------------------------*/
  /* Data recieved from RU is updated in Actual data class.  */
  /*---------------------------------------------------------*/
  tVoid vUpdateDataFromRU( tU8* pu8NewData, tU32 u32MessageLen );
  /* ---- Fix for logiscope review ------------*/
  tVoid vUpdateDataFromRUExt(tU8* pu8NewData);

  tVoid vPackStationInfoData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oStatusMsg );
  tVoid vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface );
  tVoid vSet_TmcTuner_Method_S_JAPAN_SET_AREAPtr(clTmcTuner_Method_S_JAPAN_SET_AREA* poclTmcTuner_Method_S_JAPAN_SET_AREA);
 
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
  tVoid vUpdateHDData(tU8* pu8NewData);
  tVoid vUpdateDRMData(tU8* pu8NewData);
  tVoid vUpdateHDStationData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oStatusMsg);
  tVoid vUpdateDRMStationData(midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus &oStatusMsg);

#endif

  tun_Utility* m_potun_Utility;

  tun_MsgToHMI* m_potun_MsgToHMI;

  tun_MsgToADR* m_potun_MsgToADR;

  tun_HMIManager* m_potun_HMIManager;

  clTmcTuner_Method_S_JAPAN_SET_AREA* m_poclTmcTuner_Method_S_JAPAN_SET_AREA;

  tVoid vSet_tun_Utility_Ptr( tun_Utility* potun_Utility );

  tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR );

  tVoid vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );

  tVoid vSet_tun_HMIManager_Ptr(tun_HMIManager* potun_HMIManager);

  /*----------------------*/
  /* Tuner Actual Data    */
  /*----------------------*/

   tun_Data_MainStatus            m_otun_Data_MainStatus;

   

   tun_Data_Station               m_otun_Data_Station;

   tun_Data_GetStaticListElem     m_oatun_Data_GetStaticListElem; // This needs to be confirmed static list ???  

   tun_Data_GetConfigListElem     m_oatun_Data_GetConfigListElem;
   
   tun_Data_Monitor_Station       m_otun_Data_Monitor_Station;
   

   tun_Data_TMC    m_otun_Data_TMC;
   

   /*tun_Data_GetConfigListElem     m_oatun_Data_UpdateConfigList;*/

    /*---------------------------------------------------------*/
    /* This function is added for blocking of updation of the  */
    /* Actual Data incase of Background Tuner put into FG      */
    /*---------------------------------------------------------*/
   tBool bCheckforBackgroundTuner(const tU8* pu8NewData, tU32 u32MessageLen )const;

   tVoid vSendBandbasedOnPreset( );

   /** vnd4kor : to solve logiscope issue. 
   parameters sent are only used for printing in below function.
   Which is not needed as it is already printed in parent function */
   tVoid TraceGetActTunerData( tU8 u8WhichClass)const;


};




#endif /* TUN_ACTUALDATA_H */
