/************************************************************************
* FILE:         ccademo_diaghandler.cpp
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Demo Server diagnosis handler using the new diagnosis
* library.
* In order to use diaglib to provide diagnostic services, include a
* diaghandler object like this one in your component. Adjust it to your
* needs and create an instance of it in your main application. This class
* does not use traces by purpose in order not to pollute the important
* information for the diaglib-use. Look at the other parts of this
* demoserver to get an idea of the general concept of application, CCA-
* communication and trace functionality. This part concentrates on the
* diaglib.
* Parts that need modification by you are marked by special comments.
* depending on the file.
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - ccademo_DefSetHandler.x            => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                 | Modification
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/
#ifndef TUN_TCLDIAGHANDLER_H
#define TUN_TCLDIAGHANDLER_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// +++ Specify what kind of diagnostic services you provide. Consult documentation for details +++
#define DIAGLIB_INCLUDE_SYSTEM_SET
#define DIAGLIB_INCLUDE_ROUTINE_CONTROL
#define DIAGLIB_INCLUDE_IO_CONTROL
#include "diaglib_if.h"

#include "tun_main.h"
#include "tun_MsgToADR.h"
#include "kdsconfig/clConfigInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#include "AMFMTuner/clHDImageMemoryManagement.h"
#endif

#define TUN_DEFAULT_SETTING_FOR_ALLUSER 0
#define TUN_DEFAULT_SETTING_FOR_CURRENTUSER 1

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define AMFMTUN_REGISTERED_SYSTEMSETTYEP(u32SystemSetType)(u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		u32SystemSetType==(tU32)diaglib::EN_TYPE_CODING|| u32SystemSetType==diaglib::EN_TYPE_UM_RESET_ALL || u32SystemSetType==diaglib::EN_TYPE_UM_RESET_USER ||\
		u32SystemSetType==diaglib::EN_TYPE_UM_SWITCH_USER)
#else
#define AMFMTUN_REGISTERED_SYSTEMSETTYEP(u32SystemSetType)(u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		u32SystemSetType==(tU32)diaglib::EN_TYPE_CODING)
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define AMFMTUN_REGISTERED_DEFAULTSETTING(u32SystemSetType) (u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF ||\
		 u32SystemSetType==diaglib::EN_TYPE_UM_RESET_ALL || u32SystemSetType==diaglib::EN_TYPE_UM_RESET_USER)
#else
#define AMFMTUN_REGISTERED_DEFAULTSETTING(u32SystemSetType)(u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_HMI || u32SystemSetType==(tU32)diaglib::EN_TYPE_DEFAULT_TEF )
#endif
/**
 * Message are received by implementing ListenerInterfaces and registering 
 * them with diagnosis library.
 */
// +++ Adjust class prefix according to your component +++
class clConfigInterface;
class clAars_SpecialDiagnosisMode;
class tun_tclDiagHandler : public diaglib::tclSystemSetListenerIF ,public diaglib::tclIoControlListenerIF
{
public:
   tun_tclDiagHandler(tuner_tclApp* poTunMainApp );
   virtual ~tun_tclDiagHandler();
   tBool blGetSystemSetFinished();

private:
	tun_tclDiagHandler(); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
      // +++ Listeners you create +++


   // +++ Pointer to application +++
	tuner_tclApp* _poGWMain;
	diaglib::tContext m_MsgContext;

	diaglib::tclDiagnosisInterfaceFactory* poFactory;

   diaglib::tclDiagnosisIF*      _poDiagIF;
   diaglib::tclCCAServiceIF*     _poCcaIF;

   // +++ Interfaces you need +++
   diaglib::tclRoutineControlIF* _poRoutineCtrlIF;
   diaglib::tclSystemSetIF*		 m_poSystemSetIF;
   diaglib::tclIoControlIF* m_poIOCtrlIF;
   tun_MsgToADR* m_potun_MsgToADR;
   tBool m_blSystemSetFinished; 

   tVoid vHandleSystemSetRequest(diaglib::tenSystemSetType u32SystemSetType);
   tVoid vHandleSwitchUserRequest();

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   clHDStationLogoManagement* m_poclHDStationLogoManagement;
   clAars_SpecialDiagnosisMode* m_poSpecialDiagnosisMode;
#endif
   clConfigInterface* 	m_poclConfigInterface;

   public:

   tVoid vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState);
   tU16 u16GetServiceId();
   tVoid vSendSystemSetResponse();
   tBool bGetServiceVersion (tU16& rfu16MajorVersion, 
                             tU16& rfu16MinorVersion, 
                             tU16& rfu16PatchVersion);
   tVoid vDispatchMessage(amt_tclServiceData* poMessage);
   tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   tVoid vSetclAars_SpecialDiagnosisModePtr(clAars_SpecialDiagnosisMode* poclAars_SpecialDiagnosisMode);
#endif

    	virtual tU32 vOnSystemSetPrepare( tU32 u32SystemSetID,
			diaglib::tenSystemSetType u32SystemSetType,
			diaglib::tContext MsgContext
	);

virtual tU32 vOnSystemSet( tU32 u32SystemSetID,diaglib::tenSystemSetType u32SystemSetType,
				diaglib::tContext MsgContext );

	virtual tU32 vOnSystemSetFinished( tU32 u32SystemSetID,
				diaglib::tenSystemSetType u32SystemSetType,
				diaglib::tContext MsgContext
		);

	virtual tU32 vOnIoControlUnfreeze (tU32 u32IoControlId,diaglib::tContext MsgContext);
	virtual 	tU32 vOnIoControlFreeze (tU32 u32IoControlId,diaglib::tContext MsgContext);
	virtual tU32 vOnIoControl(tU32 u32IoControlId,
			diaglib::tenIoControlAction enActionId,
			const diaglib::tclParameterVector& oParameterVector,
			diaglib::tContext MsgContext);
	tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	tVoid vSetHDStationLogoManagement( clHDStationLogoManagement* poclHDStationLogoManagement);
#endif
};
#endif // TUNER_TCLDIAGHANDLER_H

