/************************************************************************
* FILE:         tun_diaghandler.cpp
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Tuner diagnosis handler using the new diagnosis
* library.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
 * Date      		 | Author                       | Modification
* 25.04.13           | NGP1KOR   				    | First version of the G3g after porting 
													from NISSAN LCN2Kai
*************************************************************************/

// +++ Look at the diaglib header file Version.h and
// change the major number here to the one given there +++
#define CCADEMO_U8_EXPECTED_DIAGLIB_MAJOR 1

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif

#include "tun_diaghandler.h"
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#include "Aars/clAars_SpecialDiagnosisMode.h"
#endif

#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_DIAGHANDLER
#include "trcGenProj/Header/tun_diaghandler.cpp.trc.h"
#endif

class tuner_tclApp;

#define AMFMTUN_SYSTEMSETID(u32SystemSetID)(u32SystemSetID==SYSSETID_TUNE_AMFM)

#define MODE_OFF 0x00

/** Define is missing in fc_diagnosis/framework/SystemAdapter/dia_IdSpec.h */
#ifndef IOCONTROLID_DIAG_REMOTE_CONTROL
#define IOCONTROLID_DIAG_REMOTE_CONTROL 17
#endif
#ifndef IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode
#define IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode 0
#endif
#ifndef IOCONTROLID_DIAG_REMOTE_CONTROL_RESULT_PARAM1
#define IOCONTROLID_DIAG_REMOTE_CONTROL_RESULT_PARAM1 (tU8)1
#endif
/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members and setup connection with diaglib
*
* PARAMETER: poCcademoMainApp Pointer to main application
*
* RETURNVALUE: n/a
*
*************************************************************************/
tun_tclDiagHandler::tun_tclDiagHandler(tuner_tclApp* poTunMainApp)
   :_poGWMain(poTunMainApp)
{
   poFactory = OSAL_NULL;

   // +++ Initialize your member variables here +++
   
   // +++ Initialize interface pointers that you need +++
   _poDiagIF = OSAL_NULL;
   _poCcaIF = OSAL_NULL;
   _poRoutineCtrlIF = OSAL_NULL;
   m_poSystemSetIF = OSAL_NULL;
   m_poIOCtrlIF = OSAL_NULL;
   m_potun_MsgToADR = NULL;
   m_blSystemSetFinished=TRUE;
   m_MsgContext=0;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
   m_poclHDStationLogoManagement = NULL;
   m_poSpecialDiagnosisMode = NULL;
#endif
   m_poclConfigInterface = NULL;

	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_CONSTR _ ET_EN_DONE);

   poFactory = diaglib::tclDiagnosisInterfaceFactory::poGetInstance();

   if(poFactory != OSAL_NULL)
   {
      tU8 u8MajorVersion;
      tU8 u8MinorVersion;
      if(poFactory->bGetVersion(u8MajorVersion, u8MinorVersion) == TRUE)
      {
         // +++ Trace info diaglib version number if wanted +++
         if(u8MajorVersion != CCADEMO_U8_EXPECTED_DIAGLIB_MAJOR)
         {
            // +++ Trace error/warning that major version differs from expected one +++
            //TRACE_WARN(TRC::FnConstructor, TRC::WarnDiagLibVersionNotValid);
			ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_INVALID_VER _ ET_EN_DONE );
         }
      }
      else
      {
         // +++ Trace warning +++
         //TRACE_WARN(TRC::FnConstructor, TRC::WarnDiagLibVersionNotKnown);
		 ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_UNKNOWN_VER _ ET_EN_DONE );
      }

      // +++ Provide pointer to your Main application that derives from ail_tclAppInterface as tVoid* +++
      _poDiagIF = poFactory->poCreateDiagnosisInterface( diaglib::EN_PROTOCOL_CCA, static_cast<tVoid*>(poTunMainApp) );
      ETG_TRACE_USR1(( " tun_tclDiagHandler created DiagIF interface"));
   }
   else
   {
      // +++ Trace error +++
       //TRACE_ERROR(TRC::FnConstructor, TRC::ErrNullPointerInstanceMissing);
	   ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_FACT_NULL_PTR _ ET_EN_DONE );
   }

   if(_poDiagIF != OSAL_NULL)
   {
	   ETG_TRACE_USR1(( " tun_tclDiagHandler created DiagIF != NULL"));
      _poDiagIF->bGetInterface<diaglib::tclCCAServiceIF>(&_poCcaIF);

      // Get the routine control interface
      _poDiagIF->bGetInterface<diaglib::tclRoutineControlIF>(&_poRoutineCtrlIF);
      _poDiagIF->bGetInterface<diaglib::tclIoControlIF>(&m_poIOCtrlIF);

      // +++ Create your listener objects here +++
      _poDiagIF->bGetInterface<diaglib::tclSystemSetIF>(&m_poSystemSetIF);

      if(m_poSystemSetIF != NULL)
      {
    	  ETG_TRACE_USR1(( " tun_tclDiagHandler created m_poSystemSetIF != NULL"));
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_CODING,(diaglib::tclSystemSetListenerIF *)this);
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_DEFAULT_HMI,(diaglib::tclSystemSetListenerIF *)this);
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_DEFAULT_TEF,(diaglib::tclSystemSetListenerIF *)this);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_UM_RESET_ALL,(diaglib::tclSystemSetListenerIF *)this);
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_UM_RESET_USER,(diaglib::tclSystemSetListenerIF *)this);
    	  m_poSystemSetIF->vRegisterListener(SYSSETID_TUNE_AMFM,diaglib::EN_TYPE_UM_SWITCH_USER,(diaglib::tclSystemSetListenerIF *)this);
#endif
      }
      if(m_poIOCtrlIF != NULL)
      {
    	  m_poIOCtrlIF->vRegisterListener(IOCONTROLID_DIAG_REMOTE_CONTROL,(diaglib::tclIoControlListenerIF *)this);
      }

   }
   else
   {
      // +++ Trace error +++
	   ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_DIAGIF_NULL_PTR _ ET_EN_DONE );
   }

   // +++ Check if an interface failed creation +++
   if (
         _poCcaIF == OSAL_NULL || 
         _poRoutineCtrlIF == OSAL_NULL
      )
   {
      // +++ Trace error +++
	   ET_TRACE_ERROR_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_INTF_PTR _ ET_EN_DONE );
   }
   else
   {
      // +++ Create your listener objects here +++

   }
}



/*************************************************************************
*
* FUNCTION:~tun_tclDiagHandler()
* 
* DESCRIPTION: All interfaces are made invalid and listeners are deleted
*
* PARAMETER:  void
*
* RETURNVALUE: void
*
*************************************************************************/
tun_tclDiagHandler::~tun_tclDiagHandler()
{
   //diaglib::tclDiagnosisInterfaceFactory* poFactory = OSAL_NULL;


   _poGWMain = OSAL_NULL;
   m_potun_MsgToADR = NULL;
   m_MsgContext=0;

  // poFactory = diaglib::tclDiagnosisInterfaceFactory::poGetInstance();

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_DESTR _ ET_EN_DONE);
   if( poFactory != OSAL_NULL )
   {
      // +++ Destroy your diaglib instance by calling the following function and providind ONE of +++
      // +++ your interfaces. All interfaces are invalid after this function returned true. +++
      if ( poFactory->bDeleteConnectionAndFreeInterfaces( _poDiagIF ) == TRUE )
      {
         // +++ Set all the interfaces you retrieved once back to NULL to prevent its usage +++
         _poDiagIF = OSAL_NULL;
         _poCcaIF = OSAL_NULL;
		 _poRoutineCtrlIF = OSAL_NULL;
		 m_poSystemSetIF = OSAL_NULL;
		 m_poIOCtrlIF = OSAL_NULL;
      }
      else
      {
         // +++ Trace error +++
      }
   }
   else
   {
      // +++ Trace error +++
   }

   // +++ Delete heap instances that are members of your object, for example listeners or worker threads/objects  +++

	_poDiagIF = OSAL_NULL;
	_poCcaIF = OSAL_NULL;
	_poRoutineCtrlIF = OSAL_NULL;
	m_poSystemSetIF = OSAL_NULL;
	poFactory = OSAL_NULL;
	m_poIOCtrlIF = OSAL_NULL;
	m_blSystemSetFinished=TRUE;
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
	m_poclHDStationLogoManagement = NULL;
	m_poSpecialDiagnosisMode = NULL;
#endif
	m_poclConfigInterface = NULL;
}
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_tclDiagHandler::vSetclAars_SpecialDiagnosisModePtr(clAars_SpecialDiagnosisMode* poclAars_SpecialDiagnosisMode)
{
	if(NULL != poclAars_SpecialDiagnosisMode)
	{
		m_poSpecialDiagnosisMode = poclAars_SpecialDiagnosisMode;
	}
}
#endif
/*************************************************************************
*
* FUNCTION: vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
* 
* DESCRIPTION: handles state - change messages form the spm
*
* PARAMETER: old state, new state
*
* RETURNVALUE: void
*
*************************************************************************/
tVoid tun_tclDiagHandler::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{
   if(u32OldAppState == u32AppState) 
   {
      return;
   }

   if( _poCcaIF == OSAL_NULL )
   {
      // +++ Trace Error +++
       //TRACE_ERROR(TRC::FnDestructor, TRC::ErrNullPointerInstanceMissing);
      return;
   }

   ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_NEWAPPSTATE _ ET_EN_DONE);
   ETG_TRACE_USR1(( " tun_tclDiagHandler::vOnNewAppState() -> %d",  u32AppState));
   _poCcaIF->vOnNewAppState(u32OldAppState, u32AppState);
}

/*************************************************************************
*
* FUNCTION: u16GetServiceId()
* 
* DESCRIPTION: Returns the service ID of the diag service
*
* PARAMETER: none
*
* RETURNVALUE: tU16 service ID
*
*************************************************************************/
tU16 tun_tclDiagHandler::u16GetServiceId()
{
   if( _poCcaIF == OSAL_NULL )
   {
      // +++ Trace Error +++
      // TRACE_ERROR(TRC::FnDestructor, TRC::ErrNullPointerInstanceMissing);
      return 0;
   }
	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_SERVID _ ET_EN_DONE);

	 ETG_TRACE_USR1(( " tun_tclDiagHandler::u16GetServiceId() -> %d",  _poCcaIF->u16GetServiceId()));
   return _poCcaIF->u16GetServiceId();
}

/*************************************************************************
*
* FUNCTION: vDispatchMessage(amt_tclServiceData* poMessage)
* 
* DESCRIPTION: Dispatches the incoming message to the diaglib
*
* PARAMETER: poMessage Incoming message
*
* RETURNVALUE: none
*
*************************************************************************/
tVoid tun_tclDiagHandler::vDispatchMessage(amt_tclServiceData* poMessage)
{
   if( _poCcaIF == OSAL_NULL )
   {
      // +++ Trace Error +++
      // TRACE_ERROR(TRC::FnDestructor, TRC::ErrNullPointerInstanceMissing);
      return;
   }
	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_DISPATCHMSG _ ET_EN_DONE);
	ETG_TRACE_USR1(( " tun_tclDiagHandler::vDispatchMessage called"));
   _poCcaIF->vDispatchMessage(poMessage);

   /*Handled in tunermaster main vOnNewMessage method */
   // +++ When you don't delete the message in the application you
   // have to do it here. Do it like that: +++
   // if(poMessage->bIsValid() == TRUE)
   // {
   //    poMessage->bDelete();
   // }
}

/*************************************************************************
*
* FUNCTION: bGetServiceVersion ( tU16& rfu16MajorVersion, 
                                 tU16& rfu16MinorVersion, 
                                 tU16& rfu16PatchVersion)
* 
* DESCRIPTION: Reads out the internal service version
*
* PARAMETER: out rfu16MajorVersion - Major service version
*            out rfu16MinorVersion - Minor service version
*            out rfu16PatchVersion - Patch service version
*
* RETURNVALUE: tBool - true if version is returned correctly, false if not
*
*************************************************************************/
tBool tun_tclDiagHandler::bGetServiceVersion ( tU16& rfu16MajorVersion, 
                                                   tU16& rfu16MinorVersion, 
                                                   tU16& rfu16PatchVersion)
{
   if( _poCcaIF == OSAL_NULL )
   {
      // +++ Trace Error +++
      return FALSE;
   }
	ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAGHANDLER, ET_EN_T16 _ TUN_TRACE_CLASS_DIAGHANDLER_SERVVER _ ET_EN_DONE);
	ETG_TRACE_USR1(( " tun_tclDiagHandler::bGetServiceVersion called"));
   return _poCcaIF->bGetServiceVersion(rfu16MajorVersion, 
                                       rfu16MinorVersion, 
                                       rfu16PatchVersion );
}


tU32 tun_tclDiagHandler::vOnSystemSetPrepare( tU32 u32SystemSetID,
		diaglib::tenSystemSetType u32SystemSetType,
		diaglib::tContext MsgContext
)
{
	ETG_TRACE_USR4(("vOnSystemSetPrepare()->SystemSetID=%d SystemSetType=%d ", u32SystemSetID, u32SystemSetType));
	tU32 u32RetValue =	diaglib::U32_DIAGLIB_RETURN_NOT_OK;
	if (m_poSystemSetIF == NULL)
	{
		return u32RetValue;
	}
	diaglib::tenSystemSetResult _enSysSetPrepareResult = diaglib::EN_SYSTEMSET_NOT_OK;
	diaglib::tclParameterVector _oErrorList;
	diaglib::trParameter rParam;
	rParam.enType = diaglib::EN_PARAMETER_TYPE_U8;
	if(AMFMTUN_SYSTEMSETID(u32SystemSetID))
	{
		if((tBool)AMFMTUN_REGISTERED_SYSTEMSETTYEP((tU32)u32SystemSetType))
		{
			_enSysSetPrepareResult=diaglib::EN_SYSTEMSET_OK;
			u32RetValue =	diaglib::U32_DIAGLIB_RETURN_OK;
		}
		else
		{

			rParam.u8Value = (tU8)diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
			_oErrorList.push_back(rParam);
		}
	}
	else
	{
		rParam.u8Value = (tU8)diaglib::EN_ERROR_ID_NOT_SUPPORTED;
		_oErrorList.push_back(rParam);

	}
	if (TRUE == m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetPrepareResult, _oErrorList, MsgContext ) )
	{
		ETG_TRACE_USR4(("vOnSystemSetPrepare()->bSendSystemSetPrepareResult has sent"));
	}
	else
	{
		ETG_TRACE_USR4(("vOnSystemSetPrepare()->bSendSystemSetPrepareResult has not sent"));
	}
	return u32RetValue;
}
/*************************************************************************
 * FUNCTION: 		vOnSystemSet
 *
 * DESCRIPTION:		Handler function for SystemSet
 *
 * PARAMETER:  		tU32 u32SystemSetID, diaglib::tenSystemSetType u32SystemSetType,
 *			  		diaglib::tContext MsgContext
 * RETURNVALUE:		U32_DIAGLIB_RETURN_OK
 *************************************************************************/
tU32 tun_tclDiagHandler::vOnSystemSet( tU32 u32SystemSetID,
		diaglib::tenSystemSetType u32SystemSetType,
		diaglib::tContext MsgContext
)
{
	tU32 u32RetValue =	diaglib::U32_DIAGLIB_RETURN_NOT_OK;
	m_MsgContext =MsgContext;
	if (m_poSystemSetIF == NULL)
	{
		return u32RetValue;
	}
	diaglib::tclParameterVector _oErrorList;
	diaglib::trParameter rParam;
	rParam.enType = diaglib::EN_PARAMETER_TYPE_U8;
	if(AMFMTUN_SYSTEMSETID(u32SystemSetID))
	{
		if((tBool)AMFMTUN_REGISTERED_SYSTEMSETTYEP((tU32)u32SystemSetType))
		{
			u32RetValue =	diaglib::U32_DIAGLIB_RETURN_OK;
			vHandleSystemSetRequest(u32SystemSetType);
		}
		else
		{

			rParam.u8Value = (tU8)diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
			_oErrorList.push_back(rParam);
		}
	}
	else
	{
		rParam.u8Value = (tU8)diaglib::EN_ERROR_ID_NOT_SUPPORTED;
		_oErrorList.push_back(rParam);

	}
	return u32RetValue;
}

tVoid tun_tclDiagHandler::vSendSystemSetResponse()
{
	diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
	diaglib::tclParameterVector _oErrorList;
	if(m_poSystemSetIF!=NULL)
	{
		if (TRUE == m_poSystemSetIF->bSendSystemSetResult( _enSysSetResult, _oErrorList, m_MsgContext) )
		{
			ETG_TRACE_USR4(("vOnSystemSet()->bSendSystemSetResult has sent"));
		}
	}
	m_MsgContext=0;
}
/*************************************************************************
 * FUNCTION: 		vOnSystemSetFinished
 *
 * DESCRIPTION:		Handler function  for SystemSeFinish
 *
 * PARAMETER:  		tU32 u32SystemSetID, diaglib::tenSystemSetType u32SystemSetType,
 *			  		diaglib::tContext MsgContext
 *
 * RETURNVALUE: U32_DIAGLIB_RETURN_OK
 *************************************************************************/
tU32 tun_tclDiagHandler::vOnSystemSetFinished( tU32 u32SystemSetID,
		diaglib::tenSystemSetType u32SystemSetType,
		diaglib::tContext MsgContext
)
{
	ETG_TRACE_USR4(("vOnSystemSetFinished()->SystemSetID=%d SystemSetType=%d ",u32SystemSetID, u32SystemSetType));
	tU32 u32RetValue =	diaglib::U32_DIAGLIB_RETURN_NOT_OK;
	if ((m_poSystemSetIF == NULL)|| (m_potun_MsgToADR==NULL))
	{
		return u32RetValue;
	}
	if(AMFMTUN_SYSTEMSETID(u32SystemSetID))
	{
		if((tBool)AMFMTUN_REGISTERED_SYSTEMSETTYEP((tU32)u32SystemSetType))
		{
			u32RetValue =	diaglib::U32_DIAGLIB_RETURN_OK;
		}
	}
	m_blSystemSetFinished=TRUE;
	if(m_potun_MsgToADR->bGetPersonalisationReq()==FALSE)
	{
		m_potun_MsgToADR->vGetDefaultPresetListAfterSetUser();
	}
	else if((AMFMTUN_REGISTERED_DEFAULTSETTING(u32SystemSetType) && (!m_potun_MsgToADR->blGetDefaultSettingMsgSent()))
			  	  	  	  	  || (u32SystemSetType == (tU32)diaglib::EN_TYPE_CODING))
	{
		m_potun_MsgToADR->vGetDefaultPresetListAfterDefaultSetting();
	}
	if (TRUE == m_poSystemSetIF->bAcknowledgeSystemSetFinished( MsgContext ) )
	{
		ETG_TRACE_USR4(("vOnSystemSetFinished()->vOnSystemSetFinishedresult has sent"));
	}
	else
	{
		ETG_TRACE_USR4(("vOnSystemSetFinished()->vOnSystemSetFinishedresult has not sent"));
	}
	return u32RetValue;
}


/*************************************************************************
*
* FUNCTION:     vSet_tun_MsgToADR_Ptr( )
*
* DESCRIPTION:
*
* PARAMETER:    tun_MsgToADR*
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_tclDiagHandler ::vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR)
{
  if( potun_MsgToADR != NULL )
  {
    m_potun_MsgToADR = potun_MsgToADR;
  }
  else
  {
    NORMAL_M_ASSERT ( potun_MsgToADR != NULL );

  }
}
/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSetHDStationLogoManagement( )
*
* DESCRIPTION:   set the clHDStationLogoManagement pointer
*
* PARAMETER:    clHDStationLogoManagement* poclHDStationLogoManagement
*
* RETURNVALUE:  void
*
*************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
tVoid tun_tclDiagHandler::vSetHDStationLogoManagement( clHDStationLogoManagement* poclHDStationLogoManagement)
{
	if(poclHDStationLogoManagement != NULL)
	{
		m_poclHDStationLogoManagement = poclHDStationLogoManagement;
	}
}
#endif

/*************************************************************************
*
* FUNCTION:     tun_MsgFromHMI::vSet_tun_ConfigInterface_Ptr( )
*
* DESCRIPTION:   With this config data can be accessed
*
* PARAMETER:    clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_tclDiagHandler::vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface )
{
  if( poclConfigInterface != NULL )
  {
	  m_poclConfigInterface = poclConfigInterface;
  }

}

tBool tun_tclDiagHandler ::blGetSystemSetFinished()
{
	ETG_TRACE_USR4(("blGetSystemSetFinished()->blSystemSetFinished=%d",m_blSystemSetFinished));
	return m_blSystemSetFinished;
}
/*************************************************************************
 * FUNCTION: 		vOnIoControl
 *
 * DESCRIPTION:
 *
 * PARAMETER:  		tU32 u32IoControlId, diaglib::tenIoControlAction enActionId,
 *			  		diaglib::tContext MsgContext
 *
 * RETURNVALUE:
 *************************************************************************/
tU32 tun_tclDiagHandler::vOnIoControl(tU32 u32IoControlId,
		diaglib::tenIoControlAction enActionId,
		const diaglib::tclParameterVector& oParameterVector,
		diaglib::tContext MsgContext)
{
	tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
	diaglib::tenIoCtrlResult oCtrlResult  = diaglib::EN_IO_CONTROL_NOT_OK;

	OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( enActionId );
	OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( MsgContext );
	OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( oParameterVector );
	switch(u32IoControlId)
	{
		case IOCONTROLID_DIAG_REMOTE_CONTROL:
		{
			// create object for response
			diaglib::tclParameterVector oTmpVec;
#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
			tBool bMode = oParameterVector[IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode].u8Value;
			if(m_potun_MsgToADR != NULL)
			{
				#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
				if((!bMode) && (m_poSpecialDiagnosisMode != NULL))
				{
					m_poSpecialDiagnosisMode->vSetSpecialDiagnosisMode(clCMSpecialDiagnosisMode::NORMAL_MODE, 0xff);
				}
				#endif
				m_potun_MsgToADR->vSendSnapshot(bMode);
			}
			oCtrlResult = diaglib::EN_IO_CONTROL_OK; // data valid                         
			diaglib::trParameter paramaStatus;
			paramaStatus.enType         = static_cast<diaglib::tenParameterType>(IOCONTROLID_DIAG_REMOTE_CONTROL_RESULT_PARAM1);
			paramaStatus.u8Value        = bMode; 
			oTmpVec.push_back(paramaStatus);
#endif
			u32Return=diaglib::U32_DIAGLIB_RETURN_OK;
			// send result to diaglib
			if(NULL!=m_poIOCtrlIF)
			{
				if(!m_poIOCtrlIF->bSendIoCtrlMethodResult( oCtrlResult,enActionId,oTmpVec,MsgContext) )
				{
					ETG_TRACE_ERR(("vOnIoControl() => ERROR: could not bSendIoControlResult"));
				}
			}
			 break;
		}
		default:
		{
			break;
		}
	}
	return u32Return;
}


/*************************************************************************
 * FUNCTION: vOnIoControlFreeze
 *
 * DESCRIPTION:
 *
 * PARAMETER:  tU32 u32IoControlId,diaglib::tContext MsgContext
 *
 * RETURNVALUE:
 *************************************************************************/
tU32 tun_tclDiagHandler::vOnIoControlFreeze (tU32 u32IoControlId,diaglib::tContext MsgContext)
{
	(tVoid)u32IoControlId;
	ETG_TRACE_USR4(("vOnIoControlFreeze()-> u32IoControlId=%u MsgContext=%u",
		u32IoControlId,MsgContext));
	tU32 u32Ret=0;

	return u32Ret;
}


/*************************************************************************
 * FUNCTION: vOnIoControlUnfreeze
 *
 * DESCRIPTION:
 *
 * PARAMETER:  tU32 u32IoControlId,diaglib::tContext MsgContext
 *
 * RETURNVALUE:
 *************************************************************************/
tU32 tun_tclDiagHandler::vOnIoControlUnfreeze (tU32 u32IoControlId,diaglib::tContext MsgContext)
{
	(tVoid)u32IoControlId;
	
	tU32 _u32RetValue=diaglib::U32_DIAGLIB_RETURN_NOT_OK;
	diaglib::tenIoCtrlResult _enIoCtrlUnfreezeResult = diaglib::EN_IO_CONTROL_NOT_OK;

	//Send Snapshot Mode ON/OFF
	if(m_potun_MsgToADR != NULL)
	{
		m_potun_MsgToADR->vSendSnapshot(MODE_OFF);
		_enIoCtrlUnfreezeResult=diaglib::EN_IO_CONTROL_OK;
		_u32RetValue=diaglib::U32_DIAGLIB_RETURN_OK;
	}
	
	ETG_TRACE_USR4(("vOnIoControlUnFreeze()-> u32IoControlId=%u MsgContext=%u _enIoCtrlUnfreezeResult=%u",
	u32IoControlId,MsgContext,_enIoCtrlUnfreezeResult));

	return _u32RetValue;
}
tVoid tun_tclDiagHandler::vHandleSystemSetRequest(diaglib::tenSystemSetType u32SystemSetType)
{
	ETG_TRACE_USR4(("vHandleSystemSetRequest()->SystemSetType=%d ", u32SystemSetType));
	switch(u32SystemSetType)
	{
		case diaglib::EN_TYPE_DEFAULT_HMI:
		case diaglib::EN_TYPE_DEFAULT_TEF:
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			case diaglib::EN_TYPE_UM_RESET_ALL:
			case diaglib::EN_TYPE_UM_RESET_USER:
		#endif
			{
				tU8 u8DefaultSettingOption = TUN_DEFAULT_SETTING_FOR_ALLUSER;
				if(NULL!=m_potun_MsgToADR)
				{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
					if (diaglib::EN_TYPE_UM_RESET_USER == u32SystemSetType)
					{
						u8DefaultSettingOption = TUN_DEFAULT_SETTING_FOR_CURRENTUSER;
					}
#endif
					m_blSystemSetFinished=FALSE;
					m_potun_MsgToADR->vSendDefaultSetting(u8DefaultSettingOption);

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		 /** Delete all HD station logos on factory setting**/
		 if(m_poclHDStationLogoManagement != NULL && m_poclConfigInterface != NULL)
		 {
			 if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
			 {
				 m_poclHDStationLogoManagement->vDeleteAllStationLogos();
			 }
		 }
#endif
				}
				break;
			}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		case diaglib::EN_TYPE_UM_SWITCH_USER:
		{
			m_blSystemSetFinished=FALSE;
			vHandleSwitchUserRequest();
			break;
		}
#endif
		case diaglib::EN_TYPE_CODING:
		{
			vSendSystemSetResponse();
			//Once the system set coding is enabled for tunermaster and fc_tmctuner, below section has to be uncommneted
			/*m_blSystemSetFinished = FALSE;
			m_potun_MsgToADR->bSendCM_SetConfiguration( enTraceSetConfiguration_SendAndTracePlain, OSAL_NULL);*/
			break;
		}
		default:
		{
			break;
		}
	}
}
tVoid tun_tclDiagHandler::vHandleSwitchUserRequest()
{
	if(m_potun_MsgToADR!=NULL)
	{
		dp_tclSrvIf oSrvEndUser;
		tU8 u8UserID = 0xFF;
		oSrvEndUser.s32GetEndUser(u8UserID);
		if(u8UserID <= 0x03)
		{
			ETG_TRACE_USR4(("vHandleSwitchUserRequest -> user id = %d", u8UserID));
			m_potun_MsgToADR->vSetPersonalisationReq(TRUE);
			m_potun_MsgToADR->vSendSetUser(u8UserID);
		}
	}
}

