/************************************************************************
* FILE:           tun_Diagnostics.h
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All Diagnostics related actions will be performed here.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 25.07.06  | ( RBIN ) Pushpa M.Hulimani   | Initial version.
** 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/




//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#ifndef TUN_DIAGNOSTICS_H
#define TUN_DIAGNOSTICS_H

// ----------------------------------------------------------------------------
// includes
// ----------------------------------------------------------------------------
#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"                 // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//#include "..\fc_tmctuner_if.h"


#include "tun_PrjConfig.h"
#include "tun_Class_ForwardDecl.h"


/*class tuner_tclApp;
#ifndef _TUNER_MAIN_H_ 

class tuner_tclservice;
#ifndef TUN_MSGTOHMI_H
class tun_HMIManager;
#endif
class tun_DiaglogHandler;

#endif

#ifndef TUN_MSGTOHMI_H
class tun_DiagManager;
#endif

#ifndef TUN_MsgToADR_H
#ifndef   TUN_IPNINTERFACE_H
class tun_MsgToADR;
#endif
#endif
class tun_Config;
class tun_ActualData;*/

class clConfigInterface;

// ----------------------------------------------------------------------------
// class definition
// ----------------------------------------------------------------------------
class tun_DiagService : public ahl_tclBaseWork
{
private:

     // Access to main app
   tuner_tclApp*                poGWMain;

//   // Acces to Main service to send communication cmd to RU
//   tuner_tclservice     *_potunCCAService;   

   // Get the Data from AMT
   tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,
                          fi_tclTypeBase&     oFIData ) const;

   // To store the App state 
   //tU32 u32Appstate;

public: 
   // Send the message to diagnostics client
   tVoid vSendMessage ( tU16             u16DestAppID,
                        const fi_tclTypeBase&  oOutData,
                        tU16             u16Fid,
                        tU8              u8OpCode,
                        tU16             u16CmdCtr,
                        tU16             u16RegId);

 
   tVoid vSendGenMessage(amt_tclServiceData poMessage);

   tVoid vSendAnswer( const amt_tclServiceData* poMessage, tU8 u8Data, tU8 u8Opcode );
   // --------------------------------------------------------------------

   tun_DiagManager* m_potun_DiagManager;

   tun_MsgToADR*     m_potun_MsgToADR;

   tun_Config*      m_potun_Config;

   clConfigInterface* 	m_poclConfigInterface;

   tun_DiaglogHandler* m_potun_DiaglogHandler;

   tun_DiagService(tuner_tclApp* poCCAMainApp);
   tun_DiagService(); // default constructor added for removing lint prio3 warning

  tun_ActualData* m_potun_ActualData;

   tun_HMIManager* m_potun_HMIManager;
   
   virtual ~tun_DiagService( );

   tVoid vSet_tun_DiagManager_Ptr( tun_DiagManager* potun_DiagManager );

   tVoid vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR);

   tVoid vSet_tun_Config_Ptr( tun_Config* potun_Config);

   tVoid vSet_tun_DiaglogHandler_Ptr( tun_DiaglogHandler* potun_DiaglogHandler);

   tVoid vSet_tun_ActualData_Ptr( tun_ActualData* potun_ActualData);

   tVoid vSet_tun_HMIManager_Ptr( tun_HMIManager* m_potun_HMIManager);

   tVoid vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

   virtual tVoid vOnUnknownMessage ( amt_tclBaseMessage* poMessage );

   // --------------------------------------------------------------------

  // On New application state / low voltage state / copro state by SPM
   //tVoid vOnNewAppState ();
   tVoid vHandleADR_Container(amt_tclServiceData* poMessage);

   // --------------------------------------------------------------------

   tVoid vSendError( tU16 u16SourceID, 
                     tU16 u16TargetID, 
                     tU16 u16RegisterID, 
                     tU16 u16CmdCounter, 
                     tU16 u16Sid, 
                     tU16 u16Fidt,
                     tU8  u8ErrorCode);

   DECLARE_MSG_MAP ( tun_DiagService )

};

#endif //TUN_DIAGNOSTICS_H

