/************************************************************************
 * FILE:         tun_Diaglog.h
 * PROJECT:      g3g
 * SW-COMPONENT: FC TMCTUNER server
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: Header of Tuner client  to Diaglog handler
 *
  *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                           | Modification
 * 10.08.06  | RBIN/EDI1 Pushpa M. Hulimani     | initial version
 * 25.04.13  | NGP1KOR    | First version of the G3g after porting
				from NISSAN LCN2Kai
 *************************************************************************/

#ifndef _TUN_DIAGLOG_H_
#define _TUN_DIAGLOG_H_

#include "tun_Class_ForwardDecl.h"
class tun_DiaglogHandler : public ahl_tclBaseWork
{
private:
	tuner_tclApp*   poGWMain;
	tU16  m_u16RegID;

	virtual tVoid vRegisterForService();
	tVoid vUnregisterForService();
	tVoid vGetDataFromAmt ( amt_tclServiceData* poFIMsg,
			fi_tclTypeBase&     oFIData )const;
	tVoid vSendMessage  ( tU16 u16DestAppID,const fi_tclTypeBase&  oOutData,tU16 u16Fid,tU8 u8OpCode,
			tU16 u16CmdCtr,tU16 u16RegId);
public:
	tun_DiaglogHandler (tuner_tclApp* poMain);
	tun_DiaglogHandler();
	virtual ~tun_DiaglogHandler();
	virtual tVoid vOnUnknownMessage ( amt_tclBaseMessage* poMessage );
	tVoid vOnNewAppState (  tU32 u32OldAppState,
			tU32 u32AppState    );
	tVoid vOnServiceState( tU16 u16ServiceId,tU16 u16ServerId,tU16 u16RegisterId, tU8  u8ServiceState,tU16 u16SubId);
	tVoid vUpdateTunerSystemFailureErrorLog(tBool blUpdateSystemFailure);
};

#endif //_TUN_DIAGLOG_H_


