/************************************************************************
* FILE:           tun_DiagManager.cpp
* PROJECT:        g3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    All Diagnostics related actions will be performed here.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                       | Modification
* 3.08.06   | ( RBIN ) Pushpa M.Hulimani   | Initial version.
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"         
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#include "tun_trace.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNDIAGFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 

// Include Diaglog interface
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

/*----------------------------------------------------------------------*/

#include "tun_DiagManager.h"
#include "tun_Diagnostics.h"
#include "tun_Utility.h"
#include "tun_MsgToADR.h"
#include "tun_ActualData.h"
#include "tun_Config.h"
#include "tun_main.h"
#include "tun_diagHelpFn.h"
#include "tun_Diaglog.h"
#include "tun_DrvAdrIf.hpp"

/*--------------------------------------*/
/* class tun_DiagManager implementation */
/*--------------------------------------*/

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::tun_DiagManager( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tun_DiagManager :: tun_DiagManager(  tuner_tclApp*  potunerMainApp) : 
                                        m_potun_DiagService(NULL),\
                                        m_potun_MsgToADR(NULL),\
                                        m_potun_Utility (NULL),\
                                        m_potun_DiaglogHandler(NULL),\
										m_potun_tclDiagHandler(NULL)
{
   poGWMain = potunerMainApp;
   u16DiagRegID = 0; //Initialize the Diagnosis Register ID
   u16CommandCntr = 0;

}

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::~tun_DiagManager( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/

tun_DiagManager ::~tun_DiagManager()
{
   //u8FidIndex=0;

   //StatusIndex=0;

   m_potun_DiagService = NULL;

   m_potun_MsgToADR     = NULL ;

   m_potun_Utility     = NULL;

   m_potun_DiaglogHandler = NULL;
	
   m_potun_tclDiagHandler = NULL;

   poGWMain = NULL;

}

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::~vSet_tun_Diagnostics_Ptr( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagManager::vSet_tun_Diagnostics_Ptr( tun_DiagService* potun_DiagService )
{
  if( potun_DiagService != NULL )
  {
    m_potun_DiagService = potun_DiagService;
  }

  else
  {
    NORMAL_M_ASSERT ( potun_DiagService != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::vSet_tun_MsgToADR_Ptr( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagManager :: vSet_tun_MsgToADR_Ptr( tun_MsgToADR* potun_MsgToADR)
{
  if( potun_MsgToADR != NULL )
  {  

    m_potun_MsgToADR = potun_MsgToADR;

  }

  else
  {
    NORMAL_M_ASSERT ( potun_MsgToADR != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::vSet_tun_Utility_Ptr( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagManager :: vSet_tun_Utility_Ptr( tun_Utility* potun_Utility)
{ 
  if( potun_Utility != NULL )
  { 
    
    m_potun_Utility = potun_Utility;

  }

  else
  {
    NORMAL_M_ASSERT ( potun_Utility != NULL );

  }
}

/*************************************************************************
*
* FUNCTION:     tun_DiagManager::vSet_tun_DiaglogHandler_Ptr( )
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagManager :: vSet_tun_DiaglogHandler_Ptr( tun_DiaglogHandler*   
                                                      potun_DiaglogHandler)
{ 
  if( potun_DiaglogHandler != NULL )
  {  

    m_potun_DiaglogHandler = potun_DiaglogHandler;

  }

  else
  {
    NORMAL_M_ASSERT ( potun_DiaglogHandler != NULL );

  }
}


/*************************************************************************
*
* FUNCTION:     tun_DiagManager::vSet_tun_DiagHandler_Ptr( )
* 
* DESCRIPTION:  
*
* PARAMETER:    void
*
* RETURNVALUE:  void
*
*************************************************************************/
tVoid tun_DiagManager::vSet_tun_DiagHandler_Ptr(tun_tclDiagHandler* potun_tclDiagHandler)
{
	if(potun_tclDiagHandler != NULL)
	{
		m_potun_tclDiagHandler = (tun_tclDiagHandler*)potun_tclDiagHandler;
	}
}


/*************************************************************************
*
* FUNCTION:     tun_DiagManager::vHandleMessagesfromRU( )
* 
* DESCRIPTION:  Handle the received messages
*
* PARAMETER:    tU8 * tU32
*
* RETURNVALUE:  None
*
*************************************************************************/
tVoid tun_DiagManager :: vHandleMessagesfromRU (tU8* pu8Message, tU32 u32MessageLen)
{
   // Validate the incoming data
  if ( NULL == pu8Message )
  {

    NORMAL_M_ASSERT ( pu8Message != NULL );
    
    return;

  } 


  if ( 0 == u32MessageLen )
  {

    NORMAL_M_ASSERT ( u32MessageLen != 0 );
    
    return;

  } 

  if(NULL == m_potun_DiaglogHandler)
  {
    NORMAL_M_ASSERT ( m_potun_DiaglogHandler != NULL );
    return;
  }

  // Check the response status and then call respective handlers
  //switch(pu8Message[0])
  switch( TUN_DRVADRIF_GET_U16( &pu8Message[enAdrMsgOffset_FKT_ID]) )//Function ID
  {  
    case enMsg_CM_Container:
      {
        vHandleADRContainer(pu8Message, u32MessageLen);
        break;
      }
    default:
      {
        break;
      }
  }
}


/**************************************************************************
*
* FUNCTION:     tun_DiagManager::vHandleADRContainer( )
* 
* DESCRIPTION:  Handle the received messages
*
* PARAMETER:    tU8 *, tU32
*
* RETURNVALUE:  None

*Author:        she4kor
*************************************************************************/
tVoid tun_DiagManager ::vHandleADRContainer(const tU8* pu8Message, tU32 u32MessageLen)
{

  tU32 u32Dummy_val = u32MessageLen;  //Added to remove lint warning.
  u32MessageLen = u32Dummy_val;        //Added to remove compiler warning.
  // Check the validity of incoming data
    if ( m_potun_DiagService == NULL )
    {
       NORMAL_M_ASSERT (m_potun_DiagService != NULL);
       return;
    }
    else if ( pu8Message == NULL )
    {
       NORMAL_M_ASSERT (pu8Message != NULL);
       return;
    }
    else
    {
		midw_tundiagfi_tclMsgFID_TUN_S_ADR_CONTAINERMethodResult oADRResponse;
		oADRResponse.u8AdrContainerResult.u8DataLength = pu8Message[(tU8)enAdrMsgOffset_DATA_LEN+1];
		
		for(tU8 u8index=0;u8index<(pu8Message[(tU8)enAdrMsgOffset_DATA_LEN+1]);u8index++)
        {
           oADRResponse.u8AdrContainerResult.GenericBytes.push_back(pu8Message[(tU8)enAdrMsgOffset_DATA + u8index]);
        }
		
		ET_TRACE_INFO_BIN( TUN_TRACE_CLASS_DIAG_MGR,
                               ET_EN_T16 _ MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER _\
                               ET_EN_T8 _ oADRResponse.u8AdrContainerResult.u8DataLength _\
                               ET_EN_DONE );
		
		
		//------------------------------
        // Send the response to diagnosis
        //------------------------------
        m_potun_DiagService->vSendMessage( CCA_C_U16_APP_DIAGDEBUG,
                      oADRResponse,
                      MIDW_TUNDIAGFI_C_U16_FID_TUN_S_ADR_CONTAINER,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
                      u16CommandCntr,
                      u16DiagRegID 
                    );
    }
  }

 
/* *****************************************************************************

   FUNCTION:      vDeleteNoThrow

   DESCRIPTION:   Deletes memory without throwing an exception.

   PARAMETERS:    rfpArg: reference of pointer to memory, to be deleted

   RETURN TYPE:   void

   HINT:          Why this function? If delete is called inside the destructor,
                  Lint complains with warning 1551 that delete might throw an
                  execption, which is not caught.

                  But try / catch must not be used, and delete does not throw
                  an exception, anyway. To prevent a Lint warning deactivation,
                  this function guarantees that no exception is thrown.
                  Furthermore, it sets the given pointer to 0, and Lint is
                  happy.

                  It is a template, because two different memory types have to
                  be deleted inside this class.

----------------------------------------------------------------------------- */

template< class T > void tun_DiagManager::vDeleteNoThrow( T*& rfpArg ) throw()
{
   OSAL_DELETE rfpArg;
   rfpArg = 0;
}


/*******************************************************************************
* FUNCTION:     tun_DiagManager::vSetDiagRegID( )
* 
* DESCRIPTION:  To store the Diagnosis Register ID
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None
*
* HISTORY
* Date      | Author                       | Modification
*-------------------------------------------------------------------------------
* 08/11/10  | Sushma Manjunath             | Initial Version 
*******************************************************************************/
tVoid tun_DiagManager :: vSetDiagRegID(tU16 u16RegID)
{
    u16DiagRegID = u16RegID;
}

/*******************************************************************************
* FUNCTION:     tun_DiagManager::u16GetDiagRegID( )
* 
* DESCRIPTION:  To retrieve the Diagnosis Register ID
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
* HISTORY
* Date      | Author                       | Modification
*-------------------------------------------------------------------------------
* 08/11/10  | Sushma Manjunath             | Initial Version 
*******************************************************************************/
tU16 tun_DiagManager :: u16GetDiagRegID() const
{
    return  u16DiagRegID;
}

/*******************************************************************************
* FUNCTION:     tun_DiagManager::vSetDiagCommandCntr( )
* 
* DESCRIPTION:  To store the Diagnosis Command Counter
*
* PARAMETER:    tU16 
*
* RETURNVALUE:  None
*
* HISTORY
* Date      | Author                       | Modification
*-------------------------------------------------------------------------------
* 08/11/10  | Sushma Manjunath             | Initial Version 
*******************************************************************************/
tVoid tun_DiagManager :: vSetDiagCommandCntr(tU16 u16ComCntr)
{
    u16CommandCntr = u16ComCntr;
}

/*******************************************************************************
* FUNCTION:     tun_DiagManager::u16GetDiagCommandCntr( )
* 
* DESCRIPTION:  To retrieve the Diagnosis Command Counter
*
* PARAMETER:    None 
*
* RETURNVALUE:  tU16
* HISTORY
* Date      | Author                       | Modification
*-------------------------------------------------------------------------------
* 08/11/10  | Sushma Manjunath             | Initial Version 
*******************************************************************************/
tU16 tun_DiagManager :: u16GetDiagCommandCntr() const
{
    return  u16CommandCntr;
}







