/************************************************************************
* FILE:         ipod_selftesthandler.h
* PROJECT:      g3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION: Example implementation of a routine control listener
* that provides access to demodata. The difference of this example
* compared to a realworld usecase is the fact, that usually for a routine
* control you would have longer running tests.
* In case of longer running tests you probably delegate a test request to
* a worker thread. It is no problem to send the response from this worker
* thread instead of how it is done in this example. When you have a worker
* thread the RoutineControlAbort functionality also makes more sense :)
* See general documentation, when you have questions on the sequence of
* a test that you have to implement or consult diagnosis team.
* Anyway take this class as a template for your own listener classes and
* adjust the parts marked with
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                 | Modification
* 15.07.08  | CM-AI/PJ-FO45 Evers    | Inital version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/
//#define VARIANT_S_FTR_ENABLE_FEAT_IPOD_DIAGLIB_SUPPORT

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tun_trace.h"

#include "tun_ConfigAntennaListener.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_CONFIG_LISTENER
#include "trcGenProj/Header/tun_ConfigAntennaListener.cpp.trc.h"
#endif

//#include "ccademo_msgtypes.h"


/*************************************************************************
*
* FUNCTION:     tun_tclConfigAntennaListener()
* 
* DESCRIPTION:  Constructor
*
* PARAMETER:    poIF : reference to Diaglib Interface 
*               poMain   : reference to Main application
*
* RETURNVALUE:  tU32 : status
*
*************************************************************************/
tun_tclConfigAntennaListener::tun_tclConfigAntennaListener(tuner_tclApp* poMainApp) 
{
   m_poSystemSetIF=NULL;
	m_poDiagIF=NULL;
	m_poFactory=NULL;
	
	m_potun_Main = poMainApp;
   blStatusReceived =  FALSE;
   m_blAntennaConfigResponse = FALSE;
   m_MsgContext = 	0x00;
   _poRoutineCtrlIF = OSAL_NULL;
   m_potun_Config = NULL;
   m_potun_MsgToADR = NULL;
   //vRegisterForDiagLib();
}

/*************************************************************************
*
* FUNCTION:    ~tun_tclConfigAntennaListener
* 
* DESCRIPTION:  Destructor
*
* PARAMETER:    None
*
* RETURNVALUE:  None
*
*************************************************************************/
tun_tclConfigAntennaListener::~tun_tclConfigAntennaListener()
{
   // +++ Free resources you might have created/used +++
   _poRoutineCtrlIF = OSAL_NULL;
   m_poSystemSetIF=NULL;
	m_poDiagIF=NULL;
	m_poFactory=NULL;
    m_potun_Config = NULL;
   m_potun_MsgToADR = NULL;
   m_potun_Main = NULL;
   blStatusReceived = FALSE;
   m_blAntennaConfigResponse = FALSE;
}


