/************************************************************************
 * FILE:           clAars_SetConfigSections.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_SetConfigSections
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   6-Aug-2015          vnd4kor
				
 *************************************************************************/

///////////////////////////////////////////////////////////
//  clAars_SpecialDiagnosisMode.cpp
//  Implementation of the Class clAars_SpecialDiagnosisMode
//  Created on:      14-Jan-2015 10:20:45
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clAars_SpecialDiagnosisMode.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"




#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_SpecialDiagnosisMode.cpp.trc.h"
#endif


clAars_SpecialDiagnosisMode::clAars_SpecialDiagnosisMode(){

}



clAars_SpecialDiagnosisMode::~clAars_SpecialDiagnosisMode(){

}





clAars_SpecialDiagnosisMode::clAars_SpecialDiagnosisMode(tuner::AarsApp::clAarsHandler* poAarsHandler): 
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_SPECIALDIAGNOSISMODE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}


void clAars_SpecialDiagnosisMode::vStatus(tunerVector<unsigned char> &/*bitStream*/){

}



void clAars_SpecialDiagnosisMode::vSetSpecialDiagnosisMode(clCMSpecialDiagnosisMode::tenMode enMode, unsigned char PhysicalTunerId){
   clCMSpecialDiagnosisMode oData;
   oData.Mode = (unsigned char)(enMode);
   oData.PhysicalTunerId = PhysicalTunerId;
   vSetGet(oData);
}
