/************************************************************************
 * FILE:           clAars_SetConfigSections.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Implementation of the Class clAars_SetConfigSections
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   6-Aug-2015			
				
 *************************************************************************/


///////////////////////////////////////////////////////////
//  clAars_SetConfigSections.cpp
//  Implementation of the Class clAars_SetConfigSections
//  Created on:      6-Aug-2015
///////////////////////////////////////////////////////////

#include "clAars_SetConfigSections.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_SetConfigSections.cpp.trc.h"
#endif


clAars_SetConfigSections::clAars_SetConfigSections(){

}

clAars_SetConfigSections::~clAars_SetConfigSections(){

}

clAars_SetConfigSections::clAars_SetConfigSections(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_SETCONFIGSECTIONS, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}

void clAars_SetConfigSections::vResult(tunerVector<unsigned char> bitStream){
   clADRInMsg oMsg(bitStream);
   clCMSetConfigSectionsResult oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_SetConfigSections::vResult: u8Result = %d",oData.getResult() ));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewSetConfigSectionsResult(oData.getResult());
}


void clAars_SetConfigSections::vSetConfigSections(unsigned short u8NumberOfBytes, tunerString sVersionInfo, tunerVector<unsigned char> payload)
{
   ETG_TRACE_USR4(("clAars_SetConfigSections::vSetConfigSections: u8NumberOfBytes = %d sVersionInfo = %s", u8NumberOfBytes, sVersionInfo.c_str() ));
   clCMSetConfigSectionsStartResult oData;
   oData.setVersionInfo(sVersionInfo);
   oData.setNumberOfBytes(u8NumberOfBytes);
   oData.setByte0_n(payload);
   vMethodStartResult(oData);
}
