/************************************************************************
 * FILE:           clAars_HDFirmwareInfo.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   implementation of the Class clAars_HDFirmwareInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   14-Jan-2015			pad1cob
				
 *************************************************************************/



#include "clAars_HDFirmwareInfo.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#include "kdsconfig/clConfigInterface.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_HDFirmwareInfo.cpp.trc.h"
#endif


clAars_HDFirmwareInfo::clAars_HDFirmwareInfo(){
	m_poclConfigInterface = NULL;
}



clAars_HDFirmwareInfo::~clAars_HDFirmwareInfo(){
	m_poclConfigInterface = NULL;
}





clAars_HDFirmwareInfo::clAars_HDFirmwareInfo(tuner::AarsApp::clAarsHandler* poAarsHandler,clConfigInterface* poclConfigInterface):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_HD_FIRMWAREINFO, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL)
  ,m_poclConfigInterface(poclConfigInterface){

}


void clAars_HDFirmwareInfo::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMHDFirmwareInfoStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clCMHDFirmwareInfoStatus::vStatus: HD Firmware VersionInfo : %s",oData.getHDFirmwareInfo()));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewHDFirmwareInfoStatus(oData.getHDFirmwareInfo());
}



void clAars_HDFirmwareInfo::vGetHDFirmwareInfo(){
   clCMHDFirmwareInfoGet oData;
   vGet(oData);
}


void clAars_HDFirmwareInfo::vOnServiceAvailable()
{
if(m_poclConfigInterface != NULL)
	if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
		vGetHDFirmwareInfo();
}
