/************************************************************************
 * FILE:           clAars_EnhancedTestMode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_EnhancedTestMode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clAars_EnhancedTestMode.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_FI_HelpFunc.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_EnhancedTestMode.cpp.trc.h"
#endif


clAars_EnhancedTestMode::clAars_EnhancedTestMode(){

}

clAars_EnhancedTestMode::~clAars_EnhancedTestMode(){

}

clAars_EnhancedTestMode::clAars_EnhancedTestMode(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ENHANCEDTESTMODE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}

void clAars_EnhancedTestMode::vStatus(tunerVector<unsigned char> &bitStream)
{
    unsigned char u8PhysicalTuner = 0x00;
    clTmcTuner_TMCTunerControl oTunerControl;
    clCMEnhancedTestModeStatus oMEnhancedTestModeStatusData;
    clADRInMsg oMsg(bitStream);

    oMsg.vGetDataFromPayload(oMEnhancedTestModeStatusData);
    u8PhysicalTuner = oMsg.getHeader().getu8InstanceId();
    oTunerControl.vOnEnhancedTestModeStatus(u8PhysicalTuner, oMEnhancedTestModeStatusData);
}

void clAars_EnhancedTestMode::vSetEnhancedTestModeActivity(clCMEnum_TestmodeActivity e8EnhancedTestModeActivity)
{
   ETG_TRACE_USR4(("clAars_EnhancedTestMode::vSetEnhancedTestModeActivity: %d", e8EnhancedTestModeActivity.enType ));
   clCMEnhancedTestModeSet oData;
   oData.TestmodeActivity.enType =  e8EnhancedTestModeActivity.enType;
   vSet(oData);
}
