/************************************************************************
 * FILE:           clAars_DRMTestMode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_DRMTestMode
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clAars_DRMTestMode.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#include "interface/clTmcTuner_TMCTunerControl.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_DRMTestMode.cpp.trc.h"
#endif


clAars_DRMTestMode::clAars_DRMTestMode(){

}



clAars_DRMTestMode::~clAars_DRMTestMode(){

}





clAars_DRMTestMode::clAars_DRMTestMode(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DRMTESTMODE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}

void clAars_DRMTestMode::vStatus(tunerVector<unsigned char> &bitStream)
{
   clADRInMsg oMsg(bitStream);
   clCMDrmTestModeStatus oData;
   oMsg.vGetDataFromPayload(oData);
   
   vPrintTestModeData(&oData);

   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewDRMTestModeStatus(oData);
}

void clAars_DRMTestMode::vPrintTestModeData(clCMDrmTestModeStatus *oData)
{

   ETG_TRACE_USR4(("clAars_DRMTestMode::vStatus -> data got from ADR... " ));
   ETG_TRACE_USR4(("part 1: u8TunerInfo = %u u32Frequency = %u u8FieldStrength = %u",
         oData->TunerInfo, oData->Frequency ,oData->FieldStrength))
   ETG_TRACE_USR4(("part 2: u8SyncStatus = %u, u8RobustnessMode = %u, u32ChannelParams = %u",
         oData->SyncStatus, oData->RobustnessMode, oData->ChannelParams));

   ETG_TRACE_USR4(("part 3 - tU8ListDRMService = %08x%04x", oData->getInt(oData->Service, 0),oData->getWord(oData->Service[5], oData->Service[4])));

   tunerString oServiceLabelData = oData->ServiceLabelData;
   ETG_TRACE_USR4(("part 4: sDRMServiceLabelData = %s", oServiceLabelData.c_str()));
   ETG_TRACE_USR4(("part 4: u32AudioConfig=%u u8ProtectionLevels=%u s32MSC_BER=%d",
          oData->AudioConfig, oData->ProtectionLevels, oData->MSC_BER));
   ETG_TRACE_USR4(("part 5: u8AudioCRCFails = %u u8AudioMute=%u u8ServiceQuality=%u u16FAC_ERRS=%u",
         oData->AudioCRCFails, oData->AudioMute, oData->ServiceQuality, oData->FAC_ERRS));
   ETG_TRACE_USR4(("part 6: u8FAC_CRC_Fails=%u u16SDC_ERRS=%u u8SDC_CRC_Fails=%u",
         oData->FAC_CRC_Fails, oData->SDC_ERRS, oData->SDC_CRC_Fails));
}

void clAars_DRMTestMode::vSetDRMTestModeActivity(clCMEnum_TestmodeActivity e8DRMTestModeActivity)
{
   ETG_TRACE_USR4(("clAars_DRMTestMode::vSetDRMTestModeActivity: %d", e8DRMTestModeActivity.enType ));
   clCMDrmTestModeSet oData;
   oData.TestmodeActivity.enType =  e8DRMTestModeActivity.enType;
   vSet(oData);
}

