/************************************************************************
 * FILE:          clAars_DRMAudioStreamDecoderStatus.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_DRMAudioStreamDecoderStatus
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#ifndef CLAARS_DRMAUDIOSTREAMDECODERSTATUS_H
#define CLAARS_DRMAUDIOSTREAMDECODERSTATUS_H

#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_DRMAudioStreamDecoderStatus : public tuner::AarsApp::clClientProperty
{

public:
   clAars_DRMAudioStreamDecoderStatus();
   virtual ~clAars_DRMAudioStreamDecoderStatus();
   clAars_DRMAudioStreamDecoderStatus(tuner::AarsApp::clAarsHandler* poAarsHandler);

   void vOnNewStatus(clCMDRMAudioStreamDecoderStatusSet oData);

   void vUpdateDatatoAudioStreamDecoderStatus(clCMDRMAudioLogicalFrameStatus* m_poFrame);
   unsigned int u32GetSuperFrameCRCFailCount();
   unsigned int u32GetAudioFrameCRCFailCount();
   void vSetAudioFrameCRCFailCount(unsigned int u32NewValue);
   void vSetSuperFrameCRCFailCount(unsigned int u32NewValue);

protected:
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
   
   void vCalculateCRCFailCount();
   void vCalculateSuperFrameCRCFailCount();
   void vCalculateAudioCRCFailCount();
   unsigned int u32GetPreviousValueOfSuperFrameCRCFailCount();
   unsigned int u32GetPreviousValueOfAudioFrameCRCFailCount();
   void vSetPreviousValueOfAudioFrameCRCFailCount(unsigned int u32NewValue);
   void vSetPreviousValueOfSuperFrameCRCFailCount(unsigned int u32NewValue);
   bool bIsSuperFrameCorruptCountSame();
   bool bIsAudioFrameCorruptCountSame();
   void vResetSuperFrameCounterToZero();
   void vResetAudioFrameCounterToZero();
   unsigned int u32GetDifference_PreviousAndCurrentSuperFrameCRCFail();
   unsigned int u32GetDifference_PreviousAndCurrentAudioFrameCRCFail();
   bool bIsAudioNotMuted();

   static unsigned int m_SuperFrameCRCFailCount_PreviousValue;
	static unsigned int m_AudioFrameCRCFailCount_PreviousValue;
   static unsigned int m_SuperFrameCounter;
	static unsigned int m_AudioFrameCounter;
};

#endif

