/************************************************************************
 * FILE:           clAars_CM_UpdateLandscapeProgress.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_UpdateLandscapeProgress
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  Jul 30, 2015        rrb1kor
				
 *************************************************************************/

#include "clAars_CM_UpdateLandscapeProgress.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"

#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_DRVADRIF
#include "trcGenProj/Header/clAars_CM_UpdateLandscapeProgress.cpp.trc.h"
#endif

clAars_CM_UpdateLandscapeProgress::clAars_CM_UpdateLandscapeProgress(){

}



clAars_CM_UpdateLandscapeProgress::~clAars_CM_UpdateLandscapeProgress(){

}


clAars_CM_UpdateLandscapeProgress::clAars_CM_UpdateLandscapeProgress(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_UPDATELANDSCAPEPROGRESS, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){
	  //ETG_TRACE_USR4(("clAars_CM_UpdateLandscapeProgress()"));

}
void clAars_CM_UpdateLandscapeProgress::vStatus(tunerVector<unsigned char> &bitStream){
	 //ETG_TRACE_USR4(("clAars_CM_UpdateLandscapeProgress()-->vStatus"));
	   clADRInMsg oMsg(bitStream);
	   clCMUpdateLandscapeProgressStatus oData;
	   oMsg.vGetDataFromPayload(oData);
	   clTmcTuner_TMCTunerControl oTunerControl;
	   oTunerControl.vOnCM_UpdateLandscapeProgressStatus(oData.ScannedFrequenciesRatio);

}

