/************************************************************************
 * FILE:           clAars_CM_UpdateLandscape.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_UpdateLandscape
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Jul 1, 2015        rrb1kor
				
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "clAars_CM_UpdateLandscape.h"
#include "clAars_CM_Commit.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tun_Manager.h"
#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#endif
#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clAars_CM_UpdateLandscape.cpp.trc.h"
#endif

/*****************************************************************************

******************************************************************************/
clAars_CM_UpdateLandscape::~clAars_CM_UpdateLandscape() {
	m_bLandscapeRequested=false;
	m_potu_Manager=NULL;
	m_poclAars_CM_Commit=NULL;
}
/*****************************************************************************

******************************************************************************/
clAars_CM_UpdateLandscape::clAars_CM_UpdateLandscape(tuner::AarsApp::clAarsHandler* poAarsHandler,clAars_CM_Commit* poclAars_CM_Commit,tu_Manager* potu_Manager):
  tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_UPDATELANDSCAPE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){
	  m_bLandscapeRequested=false;
	  m_potu_Manager=potu_Manager;
	  m_poclAars_CM_Commit=poclAars_CM_Commit;

}
/*****************************************************************************

******************************************************************************/
void clAars_CM_UpdateLandscape::vUpdateLandscape(unsigned int  Band)
{
	//ETG_TRACE_USR4(("vUpdateLandscape()"));
	clCMUpdateLandscapeStartResult oData;
	oData.setBands(Band);
	vMethodStartResult(oData);
	m_bLandscapeRequested=true;

}

/*****************************************************************************

******************************************************************************/
void clAars_CM_UpdateLandscape::vMethodResult(tunerVector<unsigned char> /*bitStream*/){
	//ETG_TRACE_USR4(("vMethodResult()"));
	clTmcTuner_TMCTunerControl oTunerControl;
	oTunerControl.vOnCM_UpdateLandscapeResult();
	m_bLandscapeRequested = false;
	if(AMT_C_U32_STATE_NORMAL!=m_potu_Manager->u8GetTunerSystemState())
	{
		m_poclAars_CM_Commit->vSendCommitMsg();
	}
}
/*****************************************************************************

******************************************************************************/
bool clAars_CM_UpdateLandscape::bIsLandscapeRequested()
{
	return m_bLandscapeRequested;
}
void clAars_CM_UpdateLandscape::vError(tunerVector<unsigned char> /*bitStream*/)
{
	m_bLandscapeRequested = false;
	clTmcTuner_TMCTunerControl oTunerControl;
	oTunerControl.vOnCM_UpdateLandscapeError();
}
