/************************************************************************
 * FILE:           clAars_CM_StationsList.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_StationsList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#include "clAars_CM_StationsList.h"
#include "AarsApp/clAarsHandler.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_StationsList.cpp.trc.h"
#endif
/*****************************************************************************
* Constructor
******************************************************************************/
clAars_CM_StationsList::clAars_CM_StationsList()
{
}
/*****************************************************************************
* Destructor
******************************************************************************/
clAars_CM_StationsList::~clAars_CM_StationsList(){
}
/*****************************************************************************z

******************************************************************************/
clAars_CM_StationsList::clAars_CM_StationsList(tuner::AarsApp::clAarsHandler* poAarsHandler):
tuner::AarsApp::clClientProperty(poAarsHandler,ADR_MSG_FID_CM_STATIONSLIST,ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL)
{
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationsList::vGetStationList(unsigned char u8List){
	clCMStationsListGet oData;
	clCMADRBaseType_Pos pos;
	pos.x=0;
	pos.y=0;
	oData.setPos(pos);
	oData.setListId(u8List);
	vGet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationsList::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMStationsListStatus oData;
   oMsg.vGetDataFromPayload(oData);
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnCM_StationListStatus(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_CM_StationsList::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_CM_StationsList::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnStationListSelectionError(oData);
}