/************************************************************************
 * FILE:           clAars_CM_EvaluationParameter.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_EvaluationParameter
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#include "clAars_CM_EvaluationParameter.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#include "interface/clTmcTuner_TMCTunerControl.h"

#define HD_SECTION 7
#define SECTION_TUNERBAND 4


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_EvaluationParameter.cpp.trc.h"
#endif


clAars_CM_EvaluationParameter::clAars_CM_EvaluationParameter()
{
    memset(m_u8PhysicalTuner, 0x00, sizeof(unsigned char) * PHYSICAL_TUNER_INSTANCES);
}



clAars_CM_EvaluationParameter::~clAars_CM_EvaluationParameter(){

}





clAars_CM_EvaluationParameter::clAars_CM_EvaluationParameter(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_EVALUATIONPARAMETER, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL)
{
    memset(m_u8PhysicalTuner, 0x00, sizeof(unsigned char) * PHYSICAL_TUNER_INSTANCES);
}

unsigned char clAars_CM_EvaluationParameter::pu8GetPhysicalTunerValue(unsigned short iTunerID)
{
    if(iTunerID < PHYSICAL_TUNER_INSTANCES)
    {
        return m_u8PhysicalTuner[iTunerID];
    }
    return 0xFF;
}

void clAars_CM_EvaluationParameter::vStatus(tunerVector<unsigned char> &bitStream)
{
   clADRInMsg oMsg(bitStream);
   clCMEvaluationParameterStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_CM_EvaluationParameter::vStatus: Section: %d, ParameterId: %d, ParameterValue: %d", oData.Section, oData.ParameterId, oData.ParameterValue ));
   clTmcTuner_TMCTunerControl oTunerControl;

   switch(oData.Section)
   {
       case SECTION_TUNERBAND:
       {
           if(oData.ParameterId < PHYSICAL_TUNER_INSTANCES)
           {
               m_u8PhysicalTuner[oData.ParameterId] = oData.ParameterValue;
           }
       }
       break;
       case HD_SECTION:
       {
			 oTunerControl.vOnNewAudioSplitModeStatus(oData.ParameterValue);
             oTunerControl.vOnNewHDSectionParameterStatus(oData.ParameterId,oData.ParameterValue);
       }
       break;
       default:
       break;
   }
}

void clAars_CM_EvaluationParameter::vSetHDSectionParameter(unsigned short u16ParameterID, char s8ParameterValue)
{
   ETG_TRACE_USR4(("clAars_CM_EvaluationParameter::vSetHDSectionParameter: Parameter value : %d", s8ParameterValue ));
   clCMEvaluationParameterSetGet oData;
   oData.setSection(HD_SECTION);
   oData.setParameterId(u16ParameterID);
   oData.setParameterValue(s8ParameterValue);
   vSetGet(oData);
}

void clAars_CM_EvaluationParameter::vSetTunerband(unsigned short u16ParamterID, char s8ParameterValue)
{
   ETG_TRACE_USR4(("clAars_CM_EvaluationParameter::vSetTunerband: Parameter value : %d", s8ParameterValue ));
   clCMEvaluationParameterSetGet oData;
   oData.setSection(SECTION_TUNERBAND);
   oData.setParameterId(u16ParamterID);
   oData.setParameterValue(s8ParameterValue);
   vSetGet(oData);
}

void clAars_CM_EvaluationParameter::vGetHDSectionParameter(unsigned short u16ParamterID)
{
	ETG_TRACE_USR4(("clAars_CM_EvaluationParameter::vGetHDSectionParameter: "));
	clCMEvaluationParameterGet oData;
	oData.setSection(HD_SECTION);
	oData.setParameterId(u16ParamterID);
	vGet(oData);
}

void clAars_CM_EvaluationParameter::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("clAars_CM_EvaluationParameter::vOnServiceAvailable: "));
    clCMEvaluationParameterGet oData;
    oData.setSection(SECTION_TUNERBAND);
    for(int iTunerID = 0; iTunerID < PHYSICAL_TUNER_INSTANCES; iTunerID++)
    {
    	oData.setParameterId((unsigned short)iTunerID);
        vGet(oData);
    }
}
