/************************************************************************
 * FILE:           clAars_CM_CopyUserContent.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_CopyUserContent
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author       aso9kor            | Modification


 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_CM_CopyUserContent.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_MsgToADR.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_CopyUserContent.cpp.trc.h"
#endif

clAars_CM_CopyUserContent::clAars_CM_CopyUserContent()
{

}
clAars_CM_CopyUserContent::~clAars_CM_CopyUserContent()
{

}

clAars_CM_CopyUserContent::clAars_CM_CopyUserContent(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_COPYUSERCONTENT, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{
}


void clAars_CM_CopyUserContent::vCopyUser(unsigned char u8DestinationUserId)
{
    ETG_TRACE_USR4(("clAars_CM_CopyUserContent::vCopyUser: DestinationUserId = %d",u8DestinationUserId));
    clCMCopyUserContentStartResult oData;
    oData.setDestinationUserID(u8DestinationUserId);
    vMethodStart(oData);
}

/*****************************************************************************

******************************************************************************/
void clAars_CM_CopyUserContent::vMethodResult(tunerVector<unsigned char> bitStream){
   clADRInMsg oMsg(bitStream);
   clCMCopyUserContentResult oData;
   oMsg.vGetDataFromPayload(oData);
   clTmcTuner_TMCTunerControl oTunerControl;
   ETG_TRACE_USR4(("clAars_CM_CopyUserContent::vMethodResult: vMethodResult"));
   oTunerControl.vOnCopyUserContentResult();
}

/*****************************************************************************

******************************************************************************/
void clAars_CM_CopyUserContent::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_CM_CopyUserContent::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnCM_CopyUserContentError(oData);
}
