/************************************************************************
 * FILE:           clAars_CM_ChangeOfSurveilledStations.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_ChangeOfSurveilledStations
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					   auj1kor
				
 *************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "clAars_CM_ChangeOfSurveilledStations.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_CM_ChangeOfSurveilledStations.cpp.trc.h"
#endif


clAars_CM_ChangeOfSurveilledStations::clAars_CM_ChangeOfSurveilledStations(){
}

clAars_CM_ChangeOfSurveilledStations::~clAars_CM_ChangeOfSurveilledStations(){
}

clAars_CM_ChangeOfSurveilledStations::clAars_CM_ChangeOfSurveilledStations(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_CHANGEOFSURVEILLEDSTATIONS, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
}

void clAars_CM_ChangeOfSurveilledStations::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMChangeOfSurveilledStations oData;
   oMsg.vGetDataFromPayload(oData);
   if(oData.u8GetInvolvedModulations())
   {
	    clTmcTuner_TMCTunerControl oTunerControl;
	    oTunerControl.vOnCM_ChangeOfSurveilledStationsStatus();
   }
}

