/************************************************************************
 * FILE:          clAars_CM_ChangeLsm.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_CM_ChangeLsm
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					   auj1kor
				
 *************************************************************************/

#ifndef CLAARS_CM_CHANGELSM_H_
#define CLAARS_CM_CHANGELSM_H_


#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}
class tun_MsgToHMI;
class clAars_CM_ChangeLsm : public tuner::AarsApp::clClientProperty
{

public:
	clAars_CM_ChangeLsm();
    virtual ~clAars_CM_ChangeLsm();

   /**
    *
    * @param poAarsHandler
    */
    clAars_CM_ChangeLsm(tuner::AarsApp::clAarsHandler* poAarsHandler);
	void vSet_tun_MsgToHMI_Ptr(tun_MsgToHMI* potun_MsgToHMI);
    void vSendChangeLSMDirectFreqInput(unsigned char u8Band , unsigned int u32Frequency , unsigned short u16PI);
    void vSendChangeLSMHDAudioProgramInput(unsigned char u8Band , unsigned int u32Frequency , unsigned int u32HDStationID ,  unsigned int u8HDAudioProgramNumber);
    void vSendChangeLSMDRMStationIDInput(unsigned char u8Band , unsigned int u32Frequency , unsigned int u32DRMServiceID);
    void vSendChangeLSMPresetNumberInput(unsigned short u16PresetList , unsigned char u8PresetListKey);

protected:
   /**
    *
    * @param bitStream
    */
	
	 virtual void vStatus(tunerVector<unsigned char> &bitStream);
	 virtual void vError(tunerVector<unsigned char> &bitStream);
private:
	tun_MsgToHMI* m_potun_MsgToHMI;
};


#endif /* CLAARS_CM_CHANGELSM_H_ */
