/************************************************************************
 * FILE:          clAars_CM_ChangeLsm.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_ChangeLsm
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						auj1kor
				
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_CM_ChangeLsm.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_MsgToHMI.h"
#include "tun_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOADR
#include "trcGenProj/Header/clAars_CM_ChangeLsm.cpp.trc.h"
#endif

clAars_CM_ChangeLsm::clAars_CM_ChangeLsm()
{
    m_potun_MsgToHMI = NULL;
}
clAars_CM_ChangeLsm::~clAars_CM_ChangeLsm()
{
    m_potun_MsgToHMI = NULL;
}

clAars_CM_ChangeLsm::clAars_CM_ChangeLsm(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_CHANGELSM, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{
    m_potun_MsgToHMI = NULL;
}

void clAars_CM_ChangeLsm::vSet_tun_MsgToHMI_Ptr(tun_MsgToHMI* potun_MsgToHMI)
{
	if( potun_MsgToHMI != NULL )
	{  
		m_potun_MsgToHMI = potun_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potun_MsgToHMI != NULL );
	}
}

void clAars_CM_ChangeLsm::vSendChangeLSMDirectFreqInput(unsigned char u8Band , unsigned int u32Frequency , unsigned short u16PI)
{
    ETG_TRACE_USR4(("vSendChangeLSMDirectFreqInput: u8Band = %d, u32Frequency = %d, u16PI = %d", u8Band , u32Frequency , u16PI));
    clCMChangeLsmSet oData;
    oData.setOption(0x00);
    oData.setBand(u8Band);
    oData.setFrequency(u32Frequency);
    oData.setPI(u16PI);
    oData.setHDStationID(0);
    oData.setHDAudioProgramNumber(0);
    oData.setDRMServiceID(0);
    oData.setPresetList(0);
    oData.setPresetListKey(0);
	vSetGet(oData);
}

void clAars_CM_ChangeLsm::vSendChangeLSMHDAudioProgramInput(unsigned char u8Band , unsigned int u32Frequency , unsigned int u32HDStationID ,  unsigned int u8HDAudioProgramNumber)
{
    ETG_TRACE_USR4(("vSendChangeLSMHDAudioProgramInput: u8Band = %d, u32Frequency = %d, u32HDStationID = %d , u8HDAudioProgramNumber = %d",
    							u8Band , u32Frequency , u32HDStationID , u8HDAudioProgramNumber));
    clCMChangeLsmSet oData;
    oData.setOption(0x01);
    oData.setBand(u8Band);
    oData.setFrequency(u32Frequency);
    oData.setPI(0);
    oData.setHDStationID(u32HDStationID);
    oData.setHDAudioProgramNumber((unsigned char)u8HDAudioProgramNumber);
    oData.setDRMServiceID(0);
    oData.setPresetList(0);
    oData.setPresetListKey(0);
	vSetGet(oData);
}

void clAars_CM_ChangeLsm::vSendChangeLSMDRMStationIDInput(unsigned char u8Band , unsigned int u32Frequency , unsigned int u32DRMServiceID)
{
    ETG_TRACE_USR4(("vSendChangeLSMDRMStationIDInput: u8Band = %d, u32Frequency = %d, u32DRMServiceID = %d", u8Band , u32Frequency , u32DRMServiceID));
    clCMChangeLsmSet oData;
    oData.setOption(0x02);
    oData.setBand(u8Band);
    oData.setFrequency(u32Frequency);
    oData.setPI(0);
    oData.setHDStationID(0);
    oData.setHDAudioProgramNumber(0);
    oData.setDRMServiceID(u32DRMServiceID);
    oData.setPresetList(0);
    oData.setPresetListKey(0);
	vSetGet(oData);
}

void clAars_CM_ChangeLsm::vSendChangeLSMPresetNumberInput(unsigned short u16PresetList , unsigned char u8PresetListKey)
{
	if(m_potun_MsgToHMI == NULL)
	{
		ETG_TRACE_USR4(("vSendChangeLSMPresetNumberInput, m_potun_MsgToHMI NULL"));
		return;
	}
    ETG_TRACE_USR4(("vSendChangeLSMPresetNumberInput: u8PresetList = %d, u8PresetListKey = %d", u16PresetList , u8PresetListKey));
	m_potun_MsgToHMI->vSetRequestedPresetIndex(u8PresetListKey);
    clCMChangeLsmSet oData;
    oData.setOption(0x03);
    oData.setBand(0);
    oData.setFrequency(0);
    oData.setPI(0);
    oData.setHDStationID(0);
    oData.setHDAudioProgramNumber(0);
    oData.setDRMServiceID(0);
    oData.setPresetList(u16PresetList);
    oData.setPresetListKey(u8PresetListKey);
    vSetGet(oData);
}


void clAars_CM_ChangeLsm::vStatus(tunerVector<unsigned char> &/*bitStream*/)
{
	ETG_TRACE_USR4(("clAars_CM_ChangeLsm::vStatus received"));
	clTmcTuner_TMCTunerControl oTunerControl;
	oTunerControl.vOnChangeLsmStatus();
}

void clAars_CM_ChangeLsm::vError(tunerVector<unsigned char> &/*bitStream*/)
 {
	ETG_TRACE_USR4(("clAars_CM_ChangeLsm::vError received"));
	clTmcTuner_TMCTunerControl otunercontrol;
	otunercontrol.vOnChangeLsmError();
 }


