/************************************************************************
 * FILE:          clAars_CM_ATDRM_AudioServiceDirect.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_CM_ATDRM_AudioServiceDirect
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "clAars_CM_ATDRM_AudioServiceDirect.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_DRVADRIF
#include "trcGenProj/Header/clAars_CM_ATDRM_AudioServiceDirect.cpp.trc.h"
#endif

clAars_CM_ATDRM_AudioServiceDirect::clAars_CM_ATDRM_AudioServiceDirect(){

}



clAars_CM_ATDRM_AudioServiceDirect::~clAars_CM_ATDRM_AudioServiceDirect(){

}


clAars_CM_ATDRM_AudioServiceDirect::clAars_CM_ATDRM_AudioServiceDirect(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_DRMAUDIOSERVICEDIRECT, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){

}
void clAars_CM_ATDRM_AudioServiceDirect::vStatus(tunerVector<unsigned char> &/*bitStream*/){

}

void clAars_CM_ATDRM_AudioServiceDirect::vSetDRMAudioServiceDirect(unsigned long u32Frequency,unsigned long u32DRMServiceId){
	ETG_TRACE_USR4(( " clAars_CM_ATDRM_AudioServiceDirect()Frequency=%d DRMServiceId=%x",u32Frequency,u32DRMServiceId));
	clCMATDRMAudioServiceDirectSet oData;
	oData.setFrequency(u32Frequency);
	oData.setDRMServiceId(u32DRMServiceId);
	vSet(oData);
}

