/************************************************************************
 * FILE:           clAars_AudioSource.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_AudioSource
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   14-Jan-2015         pad1cob
				
 *************************************************************************/
 


#include "clAars_AudioSource.h"
#include "clAars_CM_UpdateLandscape.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tun_ActualData.h"
#include "tun_Config.h"
#include "tun_MsgFromHMI.h"
#include "tun_SPM_Client.h"
#include "tuner_trace.h"
#include "tun_MsgToADR.h"
#include "tun_defines.h"
#include "tun_main.h"
#include "tun_Manager.h"
#include "kdsconfig/clConfigInterface.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_AudioSource.cpp.trc.h"
#endif


clAars_AudioSource::clAars_AudioSource(){
	m_poGWMain = NULL;
	m_potun_ActualData=NULL;
	m_potun_Config=NULL;
	m_potun_MsgToAdr=NULL;
	m_poclConfigInterface=NULL;
	m_potun_MsgFromHMI=NULL;
	m_poclAars_CM_UpdateLandscape=NULL;
}



clAars_AudioSource::~clAars_AudioSource(){
	m_poGWMain = NULL;
	m_potun_ActualData=NULL;
	m_potun_Config=NULL;
	m_potun_MsgToAdr=NULL;
	m_poclConfigInterface=NULL;
	m_potun_MsgFromHMI=NULL;
	m_poclAars_CM_UpdateLandscape=NULL;
}





clAars_AudioSource::clAars_AudioSource(tuner_tclApp* poGWMain, tuner::AarsApp::clAarsHandler* poAarsHandler,tun_ActualData* potun_ActualData,tun_Config* potun_Config,tun_MsgToADR* potun_MsgToAdr,clConfigInterface* poclConfigInterface, clAars_CM_UpdateLandscape* poclAars_CM_UpdateLandscape):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_AUDIOSOURCE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){
    m_poGWMain = poGWMain;
	m_potun_ActualData=potun_ActualData;
	m_potun_Config=potun_Config;
	m_potun_MsgToAdr=potun_MsgToAdr;
	m_poclConfigInterface=poclConfigInterface;
	m_potun_MsgFromHMI=NULL;
	m_poclAars_CM_UpdateLandscape = poclAars_CM_UpdateLandscape;
}


void clAars_AudioSource::vStatus(tunerVector<unsigned char> &bitStream){
	if((NULL ==m_potun_ActualData) || (NULL==m_potun_Config)|| (NULL==m_potun_MsgToAdr) || (NULL==m_poclConfigInterface) || (NULL==m_potun_MsgFromHMI) || (NULL == m_poGWMain)
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
		|| (NULL == m_poclAars_CM_UpdateLandscape)
#endif
		)
	{
		return;
	}
	clADRInMsg oMsg(bitStream);
	clCMAudioSource oData;
	oMsg.vGetDataFromPayload(oData);
   /* Send landscape command only if ADR is in BG and system is in STANDBY mode and system should not be received OFF state */
	if((m_potun_ActualData->m_otun_Data_MainStatus.u32GetSystemState()==SPM_SYSTEM_STATE_STANDBY) && (oData.AudioSource.enType==clCMEnum_AudioSource::No_Audio) && m_poGWMain->m_potu_Manager->u8GetTunerSystemState() != AMT_C_U32_STATE_OFF)
	{
		if( m_potun_Config->fGetLandscapeSeekNeeded())
		{
            tU32 u32Band = m_poclConfigInterface->u32GetConfigData("AvailableBands");
            u32Band = u32Band & TUN_KDS_AVAILABLEBANDS_FM_MW_LW_MASK;
            if (m_poclConfigInterface->u32GetConfigData("DRMSupported") && (m_poclConfigInterface->u32GetConfigData("CombiBands") & (KDS_BIT_31)))
            {
         	   u32Band = u32Band | TUN_UPDATELANDSCAPE_CB1_BIT;
            }
#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
			m_poclAars_CM_UpdateLandscape->vUpdateLandscape(u32Band);
#else
			m_potun_MsgToAdr->vUpdateLandscape(u32Band);
#endif
		}
	}
   
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewTunerFGBGStatus((tU8)oData.AudioSource.enType);
   if(oData.AudioSource.enType == clCMEnum_AudioSource::No_Audio)
   {
	   m_potun_MsgFromHMI->vSetTunerBand(0xff);
	   ETG_TRACE_USR4((" clAars_AudioSource::vStatus, tunerInBG "));
   }
   /*set PWM values for BG, TA and PTY source to high frequency range, For User_audio it will be taken care after receving AtStationInfo status */
   if(oData.AudioSource.enType != clCMEnum_AudioSource::User_Audio)
   {
	   /*Fix for - NCG3D-44370. Set PWM frequency if tuner is in BG to TUN_PWM_HIGH_CORRECTEDFREQUENCY*/
	   #ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			/*Set PWM12 to 50% duty cycle - NCG3D-44370*/
			m_poGWMain->vSetPWM(DUTYCYCLE_50 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
	   #else
			m_poGWMain->vSetPWM( DUTYCYCLE_100 ,TUN_PWM_HIGH_CORRECTEDFREQUENCY);
	   #endif
	   ETG_TRACE_USR4((" clAars_AudioSource::vStatus, tuner in %d, Corrected PWM Frequency = %d", oData.AudioSource.enType, TUN_PWM_HIGH_CORRECTEDFREQUENCY));
   }
}



void clAars_AudioSource::vSetAudioSource(clCMEnum_AudioSource::enAudioSource audioSource){

   ETG_TRACE_USR4(("clAars_AudioSource::vSetAudioSource: %d", audioSource ));
   clCMAudioSource oData;
   oData.AudioSource.enType = audioSource;
   vSetGet(oData);
}
void clAars_AudioSource::vSettun_MsgFromHMIImpl(tun_MsgFromHMI* potun_MsgFromHMI)
{
	m_potun_MsgFromHMI=potun_MsgFromHMI;
}