/************************************************************************
 * FILE:           clAars_ATTunerState.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATTunerState
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#include "clAars_ATTunerState.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tuner_trace.h"
#include "interface/clTmcTuner_TMCTunerControl.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATTunerState.cpp.trc.h"
#endif

using namespace Mute::MuteHandling;


clAars_ATTunerState::~clAars_ATTunerState(){

	m_poMuteImpl = 0;
	m_poAarsAtPiSearch = 0;
	m_poTunMsgToHMI = 0;
	m_poMethod_S_AUDIO_FG_BG_NEW = 0;
	m_u16TuningFktId = 0xFFFF;
	m_u8TuningState = clCMEnum_TuningState::Idle;
	bIsMixedPresetRecall = false;
}


clAars_ATTunerState::clAars_ATTunerState(tuner::AarsApp::clAarsHandler* poAarsHandler, clAars_AtPiSearch* m_poclAars_AtPiSearch,
		tun_MsgToHMI* m_potun_MsgToHMI,
		clTmcTuner_Method_S_AUDIO_FG_BG_NEW* m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW):
		tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATTUNERSTATE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL),
		m_poAarsAtPiSearch(m_poclAars_AtPiSearch),
		m_poTunMsgToHMI(m_potun_MsgToHMI),
		m_poMethod_S_AUDIO_FG_BG_NEW(m_poclTmcTuner_Method_S_AUDIO_FG_BG_NEW){

	m_u16TuningFktId = 0xFFFF;
	m_u8TuningState = clCMEnum_TuningState::Idle;
	m_poMuteImpl = clMuteImpl::instance();
	bIsMixedPresetRecall = false;
}

void clAars_ATTunerState::vStatus(tunerVector<unsigned char> &bitStream)
{
	if(m_poTunMsgToHMI == NULL || m_poMuteImpl == NULL || m_poAarsAtPiSearch == NULL)
	{
		NORMAL_M_ASSERT( m_poTunMsgToHMI != NULL );
		NORMAL_M_ASSERT( m_poMuteImpl != NULL );
		NORMAL_M_ASSERT( m_poAarsAtPiSearch != NULL );
		return;
	}


	clADRInMsg oMsg(bitStream);
	clCMATTunerStateStatus oData;
	oMsg.vGetDataFromPayload(oData);

	/*PSARCCB-6359 - Detect tuning action complete and handle demute */
	if(bIsTuningActionRunning())
	{
		if(bIsTuningActionAborted(oData.getFunctionId()))
		{
			/*NCG3D-102693: send method result in case of mixed preset recall as soon tuning state become idle for preset recall*/
			if(oData.getFunctionId() == ADR_MSG_FID_CM_ATPRESETLIST_00)
			{
				bIsMixedPresetRecall = true;
			}
			if(bIsDemuteRequired(getMuteActionIDForADRFktId(m_u16TuningFktId)))
			{
				m_poMuteImpl->vOnNewMuteState(Mute::MuteHandling::DEMUTE);
			}
		}
	}
	
	m_u16TuningFktId = oData.getFunctionId();
	
	vPrintTestModeData(&oData);
	m_u8TuningState = oData.getTuningState();
	m_poTunMsgToHMI->vOnTunerStateChanged(m_u8TuningState);
	
	if(m_u8TuningState == clCMEnum_TuningState::Idle)
	{
		vHandleFGBGMethodResult();
		m_poTunMsgToHMI->vHandleHDTuningActionVariableStates(oData.getFunctionId());
		m_poTunMsgToHMI->vHandleAdvisoryMemberVariableStates(oData.getFunctionId());
		if(oData.getFunctionId() != ADR_MSG_FID_CM_ATPISEARCH)
		{
			m_poAarsAtPiSearch->vSendAtPiSearchStatus((tU8)midw_fi_tcl_e8_PISearch_Status::FI_EN_IDLE, 0x00);
		}
		if(m_poMuteImpl != 0)
		{
			//mhv6kor : do not send DEMUTE which is not current tuning action - NCG3D-28844
			unsigned short u16FktId = oData.getFunctionId();
			if(bIsMuteFunction(u16FktId) && bIsDemuteRequired(getMuteActionIDForADRFktId(u16FktId)))
			{
				m_poMuteImpl->vOnNewMuteState(Mute::MuteHandling::DEMUTE);
			}
		}
	}
}

void clAars_ATTunerState::vClearStates()
{
	m_u16TuningFktId = 0xFFFF;
	m_u8TuningState = clCMEnum_TuningState::Idle;
}

void clAars_ATTunerState::vHandleFGBGMethodResult()
{
	if(m_poMethod_S_AUDIO_FG_BG_NEW == NULL)
	{
		NORMAL_M_ASSERT( m_poMethod_S_AUDIO_FG_BG_NEW != NULL );
		return;
	}
	if(bIsTuningActionAudioSource())
	{
		ETG_TRACE_USR4((" tun_MsgToHMI::vHandleChangeBandMethodResult(), on CM_AudioSource Response"));
		m_poMethod_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
	}
	/*NCG3D-102693: send method result in case of mixed preset recall as soon tuning state become idle for preset recall
	Mixed preset recall request will be sent, only when tuner is in FG and requested preset element band is already active.
	if not CM_ChangeLSM request will be sent, hence no need to send the method result on tuning state idle for mixed preset recall
	if((m_u16TuningFktId == ADR_MSG_FID_CM_ATPRESETLIST_00) && bIsMixedPresetRecall))
	{
		bIsMixedPresetRecall = false;
		m_poMethod_S_AUDIO_FG_BG_NEW->vSendFGBGMethodResult();
	}*/
}

bool clAars_ATTunerState::bIsTuningActionAudioSource()
{
	/* In case TA or PTY send FGBG response to client upon receiving idle*/
	ETG_TRACE_USR1(("bIsTuningActionAudioSource()-> bIsBandChangeRequested=%d IsUseSwitchedTunerToFG=%d",m_poMethod_S_AUDIO_FG_BG_NEW->bIsBandChangeRequested(),m_poMethod_S_AUDIO_FG_BG_NEW->IsUserSwitchedTunerToFG()));
	if(NULL != m_poMethod_S_AUDIO_FG_BG_NEW)
	{
		if(!(m_poMethod_S_AUDIO_FG_BG_NEW->bIsBandChangeRequested()))
		{
			if(!m_poMethod_S_AUDIO_FG_BG_NEW->IsUserSwitchedTunerToFG())
			{
				return((m_u16TuningFktId == ADR_MSG_FID_CM_AUDIOSOURCE) || (m_u16TuningFktId == SBR_MSG_FID_CM_MTC_AUDIOSOURCE)) ? true : false;

			}
		}
		return false;
	}
	else
	{
		ETG_TRACE_USR1(("clAars_ATTunerState::bIsTuningActionAudioSource() m_poTunMsgToHMI NULL"));
		return false;
	}
}

void clAars_ATTunerState::vPrintTestModeData(clCMATTunerStateStatus *oData)
{
	ETG_TRACE_USR4(("clAars_ATTunerState::vStatus -> data received from ADR for function ID = %d, Band = %d, TunerState = %d ",
			oData->FunctionId, oData->Band.enType, oData->TuningState.enType));
}

bool clAars_ATTunerState::bIsTuningActionRunning()
{
	return m_u8TuningState == clCMEnum_TuningState::Tuning_action_started ? true : false;
}

bool clAars_ATTunerState::bIsTuningActionAborted(unsigned short u16FktId)
{
   ETG_TRACE_USR4(("clAars_ATTunerState::bIsTuningActionAborted u16FktId=%04x m_u16TuningFktId=%04x", u16FktId, m_u16TuningFktId));
   //rrb1kor : in constructor tuning state FktID will always be initialzed as ffff. So Ignore it.
   if(m_u16TuningFktId == 0xffff )
   {
      return false;
   }
   else
   {
      return m_u16TuningFktId != u16FktId ? true : false;
   }
}

bool clAars_ATTunerState::bIsDemuteRequired(Mute::MuteHandling::enMuteTuningAction action)
{
	if(m_poMuteImpl == 0)
	{
		return false;
	}
	return action == m_poMuteImpl->getCurrentMuteTuningAction() ? true : false ;
}

