/************************************************************************
 * FILE:           clAars_ATSeek.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   clAars_ATSeek method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATSeek.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATSeek.cpp.trc.h"
#endif

clAars_ATSeek::clAars_ATSeek()
{
    m_u8SeekMode = 0xFF;
}
clAars_ATSeek::~clAars_ATSeek()
{

}

clAars_ATSeek::clAars_ATSeek(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATSEEK, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{
	m_u8SeekMode = 0xFF;
}

unsigned char clAars_ATSeek::getSeekMode() const
{
    return m_u8SeekMode;
}

void clAars_ATSeek::vStatus(tunerVector<unsigned char> &bitStream)
{
    clADRInMsg oMsg(bitStream);
    clATSeekStatus oData;
    oMsg.vGetDataFromPayload(oData);
    m_u8SeekMode = oData.getSeekMode();
    ETG_TRACE_USR4(("clAars_ATSEEK::vStatus: m_u8SeekMode  = %d", m_u8SeekMode));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnNewATSeekStatus(m_u8SeekMode);
}

void clAars_ATSeek::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_ATSeek::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnATSeekError(oData);
}

void clAars_ATSeek::vSendSeekStart(unsigned char u8SeekMode, unsigned int u32Frequency)
{
    ETG_TRACE_USR4(("clAars_ATSeek::vSendSeekStart: u8SeekMode = %d, u32Frequency = %d", u8SeekMode , u32Frequency));
    clATSeekSetGet oData;
    oData.setSeekMode(u8SeekMode);
    oData.setFrequency(u32Frequency);
    vSetGet(oData);
}
