/************************************************************************
 * FILE:          clAars_ATPresetSave.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_ATPresetSave method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#include "clAars_ATPresetSave.h"
#include "AarsApp/clAarsHandler.h" 
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATPresetSave.cpp.trc.h"
#endif
/*****************************************************************************

******************************************************************************/

clAars_ATPresetSave::clAars_ATPresetSave(){

}

/*****************************************************************************

******************************************************************************/

clAars_ATPresetSave::~clAars_ATPresetSave(){

}
/*****************************************************************************

******************************************************************************/

clAars_ATPresetSave::clAars_ATPresetSave(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATPRESETSAVE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){

}

/*****************************************************************************

******************************************************************************/
void clAars_ATPresetSave::vSavePreset(unsigned short  u16List,unsigned char u8ListElementID)
{
	clCMATPresetSave oData;
	oData.Setu16FktId(u16List);
	oData.Setu8PresetNumber(u8ListElementID);
	vSet(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetSave::vStatus(tunerVector<unsigned char> &/*bitStream*/)
{
}
