/************************************************************************
 * FILE:         clAars_ATPresetList_XX.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_ATPresetList_XX method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/

#ifndef CLAARS_ATPRESETLIST_XX
#define CLAARS_ATPRESETLIST_XX

#include "AarsApp/clClientProperty.h"

/**
 * @author pad1cob
 * @version 1.0
 * @created 14-Jan-2015 10:20:45
 */
class tun_Config;
class tun_MsgToHMI;
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_ATPresetList_XX : public tuner::AarsApp::clClientProperty
{

public:
   virtual ~clAars_ATPresetList_XX();
   clAars_ATPresetList_XX(tuner::AarsApp::clAarsHandler* poAarsHandler,tun_Config* potun_Config);

   void vSet_tun_MsgToHMI_Ptr( tun_MsgToHMI* potun_MsgToHMI );
   void vGetPresetList(unsigned short U16List);
   void vSelectPresetListElement(unsigned short U16List,unsigned char u8ListElementID);
   void vDeleteSinglePresetElement(unsigned short U16List,unsigned char u8ListElementID);
   void vDeleteAllPreset(unsigned short U16List);
   void vSendSpecialSaveListElement(unsigned short U16List,unsigned char u8ListElementID,unsigned short u16PI, unsigned int u32Frequency);
   unsigned int iGetNumberOfPresetsPerBank(unsigned short U16List);

protected:
	virtual void vStatus(tunerVector<unsigned char> &bitStream);
private:
	tun_Config* m_potun_Config;
	tun_MsgToHMI* m_potun_MsgToHMI;
};

#endif
