/************************************************************************
 * FILE:         clAars_ATPresetListSetActive.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clAars_ATPresetListSetActive method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATPresetListSetActive.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATPresetListSetActive.cpp.trc.h"
#endif

/*****************************************************************************

******************************************************************************/
clAars_ATPresetListSetActive::clAars_ATPresetListSetActive(){

}
/*****************************************************************************

******************************************************************************/
clAars_ATPresetListSetActive::~clAars_ATPresetListSetActive(){

}
/*****************************************************************************

******************************************************************************/
clAars_ATPresetListSetActive::clAars_ATPresetListSetActive(tuner::AarsApp::clAarsHandler* poAarsHandler):
  tuner::AarsApp::clClientMethod(poAarsHandler, ADR_MSG_FID_CM_ATPRESETLISTSETACTIVE, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1){

}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetListSetActive::vSendATPresetListSetActive(tU16 U16List){
	clCMATPresetListSetActiveStartResult oData;
	oData.setFktId(U16List);
	vMethodStartResult(oData);
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetListSetActive::vStatus(tunerVector<unsigned char> &/*bitStream*/){
	//Nothing to Handle
}
/*****************************************************************************

******************************************************************************/
void clAars_ATPresetListSetActive::vMethodResult(tunerVector<unsigned char> bitStream){
   clADRInMsg oMsg(bitStream);
   clCMATPresetListSetActiveResult oData;
   oMsg.vGetDataFromPayload(oData);
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnATPresetListSetActiveResult();
}
