/************************************************************************
 * FILE:           clAars_ATSetPINew.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATSetPINew
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

				
 *************************************************************************/



#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "clAars_ATPI.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATPI.cpp.trc.h"
#endif

clAars_ATPI::clAars_ATPI()
{

}
clAars_ATPI::~clAars_ATPI()
{

}

clAars_ATPI::clAars_ATPI(tuner::AarsApp::clAarsHandler* poAarsHandler):
          tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_ATPI, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_TUNER1)
{

}

void clAars_ATPI::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clATPIStatus oData;
   oMsg.vGetDataFromPayload(oData);
   unsigned short u16PI = oData.u16PI;
   unsigned long u32Frequency = oData.u32Frequency;
   ETG_TRACE_USR4(("clAars_ATPI::vStatus: u16PI  = 0x%x, u32Frequency = %u", u16PI, u32Frequency ));
   //clTmcTuner_TMCTunerControl oTunerControl;
   //oTunerControl.vOnNewATHDAudioProgramStatus(u8AudioProgram);//??????
}
void clAars_ATPI::vError(tunerVector<unsigned char> bitStream)
{
    clADRInMsg oMsg(bitStream);
    clCMError oData;
    oMsg.vGetDataFromPayload(oData);
    ETG_TRACE_USR4(("clAars_ATPI::vError: ErrorCode  = %d, ErrorInfo = %d", oData.getErrorCode(), oData.getErrorInfo()));
    clTmcTuner_TMCTunerControl oTunerControl;
    oTunerControl.vOnATPIError(oData);
}

void clAars_ATPI::vSelectPIFrequency(unsigned short u16PI, unsigned int u32Frequency)
{
    ETG_TRACE_USR4(("clAars_ATPI::vSelectPIFrequency: %04x:%d",u16PI , u32Frequency));
    clATPISetGet oData;
    oData.setPI(u16PI);
    oData.setFrequency(u32Frequency);
    vSetGet(oData);
}
void clAars_ATPI::vIncrementStep(unsigned char u8Nsteps)
{
    ETG_TRACE_USR4(("clAars_ATPI::vIncrement: %d", u8Nsteps));
    clATPIIncrement oData;
    oData.setNsteps(u8Nsteps);
    vIncrement(oData);
}
void clAars_ATPI::vDecrementStep(unsigned char u8Nsteps)
{
    ETG_TRACE_USR4(("clAars_ATPI::vDecrement: %d", u8Nsteps));
    clATPIDecrement oData;
    oData.setNsteps(u8Nsteps);
    vDecrement(oData);
}
