/************************************************************************
 * FILE:            clAars_ATHDLongName.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Implementation of the Class clAars_ATHDLongName
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  14-Jan-2015          pad1cob
				
 *************************************************************************/


#include "clAars_ATHDLongName.h"
#include "AarsApp/clAarsHandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_TMCTunerControl.h"
#include "tuner_trace.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clAars_ATHDLongName.cpp.trc.h"
#endif


clAars_ATHDLongName::clAars_ATHDLongName(){
}



clAars_ATHDLongName::~clAars_ATHDLongName(){
}





clAars_ATHDLongName::clAars_ATHDLongName(tuner::AarsApp::clAarsHandler* poAarsHandler): 
  tuner::AarsApp::clClientProperty(poAarsHandler, ADR_MSG_FID_CM_ATHD_LONGNAME, ADR_MSG_CLIENT_AMFMTUNER, ADR_MSG_FBLOCK_AMFMTUNER, ADR_MSG_INSTANCE_ALL){

}

void clAars_ATHDLongName::vGetATHDLongName(const unsigned int u32HDStationId, const unsigned char u8AudioProgram)
{
   ETG_TRACE_USR4(("clAars_ATHDLongName::vGetATHDLongName: u32StationId = 0x%08x , u8AudioProgram = %d", u32HDStationId, u8AudioProgram ));
   clCMATHDLongNameGet oData;
   oData.setHDStationId(u32HDStationId);
   oData.setHDAudioProgram((clCMEnum_ATHDAudioProgram::enATHDAudioProgram)u8AudioProgram);
   vGet(oData);
}

void clAars_ATHDLongName::vStatus(tunerVector<unsigned char> &bitStream){
   clADRInMsg oMsg(bitStream);
   clCMATHDLongNameStatus oData;
   oMsg.vGetDataFromPayload(oData);
   ETG_TRACE_USR4(("clAars_ATHDLongName::vStatus: HDStationId = 0x%08x, HDAudioProgram = %d, HDLongName : %s",\
   oData.getHDStationId(),oData.getHDAudioProgram(),oData.getHDLongName()));
   clTmcTuner_TMCTunerControl oTunerControl;
   oTunerControl.vOnNewATHDLongNameStatus(oData.getHDStationId(),(const unsigned char)oData.getHDAudioProgram(),oData.getHDLongName());
}


