/************************************************************************
 * FILE:           clAars_ATHDAudioProgram.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_ATHDAudioProgram
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  06-Mar-2015          vnd4kor
				
 *************************************************************************/



#if !defined(clAars_ATHDAUDIOPROGRAM__INCLUDED_)
#define clAars_ATHDAUDIOPROGRAM__INCLUDED_

#include "AarsApp/clClientProperty.h"

/**
 * @author vnd4kor
 * @version 1.0
 * @created 06-Mar-2015 10:20:45
 */
namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_ATHDAudioProgram : public tuner::AarsApp::clClientProperty
{

public:
   clAars_ATHDAudioProgram();
   virtual ~clAars_ATHDAudioProgram();

   /**
    *
    * @param poAarsHandler
    */
   clAars_ATHDAudioProgram(tuner::AarsApp::clAarsHandler* poAarsHandler);

   void vSelectHDAudioProgram(tU8 u8AudioProgramNumber);
   void vIncrementHDAudioProgram();
   void vDecrementHDAudioProgram();

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
private:



};

#endif // !defined(EA_3CDF9CDE_EAA2_4087_8957_A34CC64B5D04__INCLUDED_)
