/************************************************************************
 * FILE:           clAars_ATFrequency.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   header of the Class clAars_ATFrequency
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  06-Mar-2015
				
 *************************************************************************/


#if !defined(clAars_ATFrequency__INCLUDED_)
#define clAars_ATFrequency__INCLUDED_

#include "AarsApp/clClientProperty.h"

namespace tuner
{
   namespace AarsApp
   {
      class clAarsHandler;
   }
}

class clAars_ATFrequency : public tuner::AarsApp::clClientProperty
{

public:
    clAars_ATFrequency();
    virtual ~clAars_ATFrequency();

    /**
    *
    * @param poAarsHandler
    */
    clAars_ATFrequency(tuner::AarsApp::clAarsHandler* poAarsHandler);
    void vSelectDirectFrequency(unsigned int u32Frequency);
    void vIncrementStep(unsigned char u8Nsteps);
    void vDecrementStep(unsigned char u8Nsteps);

protected:
   /**
    *
    * @param bitStream
    */
   virtual void vStatus(tunerVector<unsigned char> &bitStream);
   virtual void vError(tunerVector<unsigned char> bitStream);
private:



};







#endif
