/************************************************************************
 * FILE:           clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Jul 30, 2015		   rrb1kor	
 *************************************************************************/



#include "AMFMTuner/clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS.h"
#include "CcaApp/clCCAhandler.h"
#include "datatypes/tString.h"
#include "Aars/clAars_CM_UpdateLandscapeProgress.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

#include "tuner_trace.h"
#include "tun_ActualData.h"
#include "tun_defines.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS.cpp.trc.h"
#endif

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::~clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS()
{
	m_potun_ActualData = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS(clCCAhandler* poCCAhandler,tun_ActualData* potun_ActualData)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_UPDATELANDSCAPE_PROGRESS, poCCAhandler)
{
	m_potun_ActualData = potun_ActualData;
}
void clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vSet(amt_tclServiceData* /*poInMsg*/)
{
}
void clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vGet(amt_tclServiceData* /*poInMsg*/)
{
}
void clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}
void clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vOnCM_UpdateLandscapeProgressStatus(unsigned char u8ScannedFrequenciesRatio)
{
	ETG_TRACE_USR4(("vOnCM_UpdateLandscapeProgressStatus::u8ScannedFrequenciesRatio=%d",u8ScannedFrequenciesRatio ));
	midw_tunerfi_tclMsgFID_TUN_G_UPDATELANDSCAPE_PROGRESSStatus oMessage;
	oMessage.u8FreqPerc=u8ScannedFrequenciesRatio;

	if(m_potun_ActualData->m_otun_Data_MainStatus.u32GetSystemState() != SPM_SYSTEM_STATE_STANDBY)
	{
		vStatus(oMessage);
	}
}
tVoid clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vOnUpdateLandscapeError(clCMError &oData)
{
    ETG_TRACE_USR4(( "clTmcTuner_Property_G_UPDATELANDSCAPE_PROGRESS::vOnUpdateLandscapeError(), ErrorCode:%d ,ErrorInfo: %d, ", oData.getErrorCode(), oData.getErrorInfo()));
    clMuteImpl::instance()->vOnTuningActionError(Mute::MuteHandling::CONFIGLISTUPDATE);
}
