/************************************************************************
 * FILE:           clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
					   auj1kor	
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.h"
#include "Aars/clAars_CM_StationsList.h"
#include "Aars/clAars_CM_StationListRelease.h"
#include "CcaApp/clCCAhandler.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tun_MsgToHMI.h"
#include "kdsconfig/clConfigInterface.h"
#include "datatypes/tString.h"
#include "Aars/clAars_CM_StationListConfig.h"
#include "clTmcTuner_Method_S_JAPAN_SET_AREA.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tun_HMIManager.h"
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE.cpp.trc.h"
#endif
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::~clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE()
{
	m_potun_MsgToHMI = 0;
	m_poclAars_CM_StationListConfig = 0;
	m_poclAars_CM_StationListRelease = 0;
	m_poclConfigInterface = 0;
	m_potun_HMIManager=0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE(clCCAhandler* poCCAhandler,tun_MsgToHMI* potun_MsgToHMI,
		clConfigInterface* poclConfigInterface , clAars_CM_StationListConfig* poclAars_CM_StationListConfig , clAars_CM_StationListRelease* poclAars_CM_StationListRelease,tun_HMIManager* potun_HMIManager)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_SURVIELLANCE_LISTUPDATE, poCCAhandler)
{
	m_potun_MsgToHMI = potun_MsgToHMI;
	m_poclConfigInterface = poclConfigInterface;
	m_poclAars_CM_StationListConfig = poclAars_CM_StationListConfig;
	m_poclAars_CM_StationListRelease = poclAars_CM_StationListRelease;
	m_potun_HMIManager=potun_HMIManager;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vGet(amt_tclServiceData* /*poInMsg*/)
{

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	ETG_TRACE_USR4(("clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vUpreg"));
	vSendSDSStationListConfig();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSendStatus()
{
   //vSendStatus();
}
/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vPopulateStationList(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement,
		tunerVector<clCMADRBaseType_StationsListData>::iterator ActualIt)
{
	if(NULL==m_potun_HMIManager || m_potun_MsgToHMI == NULL)
	{
		ETG_TRACE_USR4(("tun_HMIManager null pointer"));
		ETG_TRACE_USR4(("m_potun_MsgToHMI null pointer"));
		return;
	}
	oTunerStationListElement.e8ConfigListID.enType = (midw_fi_tcl_e8_Tun_ConfigListID::tenType)vGetConfigListIDFromFreq(ActualIt->Frequency);
	oTunerStationListElement.u32Frequency=ActualIt->Frequency;
	oTunerStationListElement.b8HDNumOfAudioPrograms.u8Value=ActualIt->HDNumberOfAudioPrograms;
	oTunerStationListElement.b8StationInfo.u8Value=ActualIt->SendernameInfo.enType;
	oTunerStationListElement.bTpInfo=ActualIt->TpInfo;
	oTunerStationListElement.e8HDTextEncoding.enType=(midw_fi_tcl_e8_Tun_HD_TextEncodingType::tenType)ActualIt->HDTextEncoding;
	tU8 u8ModulationType = (tU8)ActualIt->ModulationType.enType;
	oTunerStationListElement.e8ModulationType.enType=(midw_fi_tcl_e8_Tun_ModulationType::tenType)u8ModulationType;
	oTunerStationListElement.e8PresetListForAcmp.enType=oGetADR3ToMidwTunerPresetListID(ActualIt->PresetListForAcmp);
	tU8 u8SendernameInfo = (tU8)ActualIt->SendernameInfo.enType;
	oTunerStationListElement.e8SendernameInfo.enType=(midw_fi_tcl_e8_Tun_SendernameInfo::tenType)u8SendernameInfo;
	oTunerStationListElement.s8LevelCompensation=ActualIt->LevelCompensation;
	midw_fi_tclString sUtf8String ;
	if((oTunerStationListElement.e8ModulationType.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_HD) && (midw_fi_tcl_e8_Tun_HD_TextEncodingType::FI_EN_ISO_IEC_8859_1_1998==oTunerStationListElement.e8HDTextEncoding.enType))
	{
		sUtf8String=ActualIt->Sendername_HDCallSign_DRMServiceLabel.getFixedString().c_str();
		oTunerStationListElement.sPSName.bSet(sUtf8String,midw_fi_tclString::FI_EN_ISO8859_1M);
	}
	else if(oTunerStationListElement.e8ModulationType.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_ANALOG)
	{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI			
		if(m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr() == NULL)
		{
			ETG_TRACE_USR4(("poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr null pointer"));
			return;
		}		
		if(m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()->bIsJapanRegion())
		{
			sUtf8String = m_potun_MsgToHMI->poGet_TmcTuner_Method_S_JAPAN_SET_AREAPtr()->sGetStationNameFromDBForListUpdate(ActualIt->Frequency);
			oTunerStationListElement.sPSName.bSet(sUtf8String, midw_fi_tclString::FI_EN_UTF8);
		}
		else
		{
#endif
			char apRText[STATIONNAME_LEN+1] = {0};
			if(!ActualIt->Sendername_HDCallSign_DRMServiceLabel.getFixedString().empty())
			{
				strncpy(apRText, ActualIt->Sendername_HDCallSign_DRMServiceLabel.getFixedString().c_str(), STATIONNAME_LEN);
			}
			m_potun_HMIManager->vConvertRTextTotString((unsigned char*)apRText,&sUtf8String,STATIONNAME_LEN);
			oTunerStationListElement.sPSName.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		}
#endif
	}
	else if(oTunerStationListElement.e8ModulationType.enType== midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_DRM)
	{
		sUtf8String=ActualIt->Sendername_HDCallSign_DRMServiceLabel.getFixedString().c_str();
		oTunerStationListElement.sPSName.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
	}
	oTunerStationListElement.u32PI=ActualIt->PI_HDStationId_DRMServiceId;
	oTunerStationListElement.u32PI_HDStnId_DRMSrvId=ActualIt->PI_HDStationId_DRMServiceId;
	oTunerStationListElement.u8ElementSelected=ActualIt->Selected.enType;
	oTunerStationListElement.u8PTY_HDPTY_DRMPty=ActualIt->RDS_HD_DRM_Pty;
	oTunerStationListElement.u8PositionInPresetList=ActualIt->PresetAcmp;
	oTunerStationListElement.u8Quality=ActualIt->ReceptionQuality;
	if(oTunerStationListElement.u32PI_HDStnId_DRMSrvId != 0)
	{
		m_potun_MsgToHMI->vGetStationLogoPath(oTunerStationListElement.u32PI_HDStnId_DRMSrvId , sUtf8String);
		oTunerStationListElement.StationLogo.bSet(  sUtf8String,
			midw_fi_tclString::FI_EN_UTF8);
	}
	vTraceStationListElement(oTunerStationListElement);
}

/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vTraceStationListElement(midw_fi_tcl_TunerConfigListElement &oTunerStationListElement)
{
	ETG_TRACE_USR4(( "StationList1 Frequency= %d HDNumOfAudioPrograms=%d StationInfo=%d TpInfo=%d HDTextEncoding=%d",
		oTunerStationListElement.u32Frequency,oTunerStationListElement.b8HDNumOfAudioPrograms.u8Value,oTunerStationListElement.b8StationInfo.u8Value,oTunerStationListElement.bTpInfo,oTunerStationListElement.e8HDTextEncoding.enType));
	ETG_TRACE_USR4(( "StationList2 ModulationType= %d PresetListForAcmp=%d SendernameInfo=%d LevelCompensation=%d",
		oTunerStationListElement.e8ModulationType.enType,oTunerStationListElement.e8PresetListForAcmp.enType,oTunerStationListElement.e8SendernameInfo.enType,oTunerStationListElement.s8LevelCompensation));
	ETG_TRACE_USR4(( "StationList3 PSName=%s", oTunerStationListElement.sPSName.szGet(midw_fi_tclString::FI_EN_UTF8)));
	ETG_TRACE_USR4(( "StationList4 StationLogo =%s", oTunerStationListElement.StationLogo.szGet(midw_fi_tclString::FI_EN_UTF8)));
}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vOnCM_StationListStatus(clCMStationsListStatus &oData)
{
	midw_tunerfi_tclMsgFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus oMessage;
	//oMessage.e8ConfigListID.enType=oGetADR3ToMidwTunerStationListIDunsigned(oData.getListId());
	tunerVector<clCMADRBaseType_StationsListData> vActualData = oData.getData();
	tunerVector<clCMADRBaseType_StationsListData>::iterator ActualIt = vActualData.begin();
	unsigned char u8ElementId = 0;
	for(; ActualIt != vActualData.end();ActualIt++, u8ElementId++)
	{
		midw_fi_tcl_TunerConfigListElement oTunerStationListElement;
		vPopulateStationList(oTunerStationListElement,ActualIt);
		oTunerStationListElement.u8ElementID = u8ElementId;
		oMessage.Tun_ConfigListElements.TunerConfigListElement.push_back(oTunerStationListElement);
	}
	vStatus(oMessage);
	ETG_TRACE_USR4(("clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vOnCM_StationListStatus"));
	vSendStationListRelease();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSendSDSStationListConfig()
{
	ETG_TRACE_USR4(("clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSendStationListConfig"));
	tU32 u32AvialbleBands = m_poclConfigInterface->u32GetConfigData("AvailableBands");
	clCMStationListConfigStartResult oData;

	oData.ListId=0x06;
	oData.AnalogFilter.enType=clCMEnum_AnalogFilter::ALL;
	oData.PtyFilter=0x00;
	oData.Sorting.enType=clCMEnum_Sorting::FREQUENCY_ASCENDING;
	oData.DigitalFilter = 0x00;

	if(u32AvialbleBands & 0x01) // FM
	{
		oData.Band = 0x01;
	}
	if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
	{
		if(u32AvialbleBands & 0x02) // LW
		{
			oData.Band |= 0x02;
		}
		if(u32AvialbleBands & 0x04) // MW
		{
			oData.Band |= 0x04;
		}
		oData.DigitalFilter = 0x03;
	}
	if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
	{
		oData.Band |= 0x100000;
		oData.DigitalFilter |= 0x04;
	}

	m_poclAars_CM_StationListConfig->vSendStationListConfig(oData);

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSendStationListRelease()
{
	ETG_TRACE_USR4(("clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vSendStationListRelease"));
	m_poclAars_CM_StationListRelease->vReleaseStationList(0x06);
}

/**************************************************************************//**
*
******************************************************************************/
tU8 clTmcTuner_Property_G_SURVIELLANCE_LISTUPDATE::vGetConfigListIDFromFreq(unsigned int u32Frequency)
{
	if( m_poclConfigInterface == NULL )
	{
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return 0xFF;
	}
	tU8 u8ConfigListID = 0xFF;

    if (u32Frequency>=(unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM") && u32Frequency<=(unsigned int)m_poclConfigInterface->u32GetConfigData("HighFM"))
    {
    	u8ConfigListID = (tU8)midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM;
    }
    else if(u32Frequency>=(unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW") && u32Frequency<=(unsigned int)m_poclConfigInterface->u32GetConfigData("HighLW"))
    {
    	u8ConfigListID = (tU8)midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_LW;
    }
    else if(u32Frequency>=(unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") && u32Frequency<=(unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW"))
    {
    	u8ConfigListID = (tU8)midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW;
    }
    else
    {
    	// nothing
    }

    return u8ConfigListID;
}
