/************************************************************************
 * FILE:           clTmcTuner_Property_G_JAPAN_AREA.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_JAPAN_AREA.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Mar 30, 2016	      pmn3kor
 *************************************************************************/



#ifndef COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_PROPERTY_G_JAPAN_AREA_H_
#define COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_PROPERTY_G_JAPAN_AREA_H_

#include "CcaApp/clServerProperty.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"
/*----------------------------------------------------------------------*/

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
#include"diaglib_if.h"
#endif


class clTmcTuner_Property_G_JAPAN_AREA: public  tuner::CcaApp::clServerProperty
{
public:
   clTmcTuner_Property_G_JAPAN_AREA(tuner::CcaApp::clCCAhandler* poCCAhandler);
   ~clTmcTuner_Property_G_JAPAN_AREA();
   void vSendStatusToClient();
   bool bGetSelectedMode();
   unsigned char u8GetJapanAreaCode();

protected:
      virtual void vGet(amt_tclServiceData* poInMsg);
      virtual void vUpreg(amt_tclServiceData* poInMsg);
      virtual void vSet(amt_tclServiceData* poInMsg);

private:
   midw_tunerfi_tclMsgFID_TUN_G_JAPAN_AREAStatus m_oMessage;
   dp_tclTmcTunerDPManualJapanAreaCode m_ManualJapanAreaCode;
   dp_tclTmcTunerDPAutomaticJapanAreaCode m_AutomaticJapanAreaCode;
   dp_tclTmcTunerDPJapanSelectionMode m_SelectedMode;

};

#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_PROPERTY_G_JAPAN_AREA_H_ */
