/************************************************************************
 * FILE:           clTmcTuner_Property_G_JAPAN_AREA.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_JAPAN_AREA.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Mar 30, 2016	      pmn3kor
 *************************************************************************/




#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#include "clTmcTuner_Property_G_JAPAN_AREA.h"
#include "tun_defines.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_JAPAN_AREA.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Property_G_JAPAN_AREA::clTmcTuner_Property_G_JAPAN_AREA(clCCAhandler* poCCAhandler)
: clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_JAPAN_AREA, poCCAhandler)
{
}

/******************************************************************************
*
******************************************************************************/
clTmcTuner_Property_G_JAPAN_AREA::~clTmcTuner_Property_G_JAPAN_AREA()
{
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_AREA::vSet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_AREA::vGet(amt_tclServiceData* /*poInMsg*/)
{
   //send property status when get is called by clients
   vSendStatusToClient();
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_AREA::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   //send property status when clients register for this property
   vSendStatusToClient();
}

/******************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_G_JAPAN_AREA::vSendStatusToClient()
{
   m_oMessage.e8SelectedRegion.enType = midw_fi_tcl_e8_Tun_Japan_Region::tenType(u8GetJapanAreaCode());
   m_oMessage.bAreaSelectionMode = bGetSelectedMode();
   ETG_TRACE_USR4(( " vSendStatusToClient :  e8SelectedRegion=%d bUpdate=%d",  m_oMessage.e8SelectedRegion.enType, m_oMessage.bAreaSelectionMode));
   vStatus(m_oMessage);

}

/******************************************************************************
*
******************************************************************************/
bool clTmcTuner_Property_G_JAPAN_AREA::bGetSelectedMode()
{
   return m_SelectedMode.tGetData();
}


/******************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Property_G_JAPAN_AREA::u8GetJapanAreaCode()
{
   if(bGetSelectedMode() == MANUAL_UPDATE)
   {
      ETG_TRACE_USR4(("clTmcTuner_Property_G_JAPAN_AREA: u8GetJapanAreaCode m_ManualJapanAreaCode = %d", m_ManualJapanAreaCode.tGetData()));
      return m_ManualJapanAreaCode.tGetData();
   }
   else // Automatic_update  Navi area code
   {
      ETG_TRACE_USR4(("clTmcTuner_Property_G_JAPAN_AREA: u8GetJapanAreaCode m_AutomaticJapanAreaCode = %d", m_AutomaticJapanAreaCode.tGetData()));
      return m_AutomaticJapanAreaCode.tGetData();
   }
}
