/************************************************************************
 * FILE:           clTmcTuner_Property_G_HD_TEST_MODE_DATA.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_HD_TEST_MODE_DATA.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_HD_TEST_MODE_DATA.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "tun_FI_HelpFunc.h"
#include "kdsconfig/clConfigInterface.h"
#define ERROR_NOTAVAILABLE 0x000B


using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_HD_TEST_MODE_DATA.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_HD_TEST_MODE_DATA::~clTmcTuner_Property_G_HD_TEST_MODE_DATA()
{
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_HD_TEST_MODE_DATA::clTmcTuner_Property_G_HD_TEST_MODE_DATA(clCCAhandler* poCCAhandler,clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_TEST_MODE_DATA, poCCAhandler)
	,m_poclConfigInterface(poclConfigInterface)
{

}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vSet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vGet(amt_tclServiceData* /*poInMsg*/)
{
	if ( m_poclConfigInterface!= NULL )
	{
		if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_TEST_MODE_DATA,ERROR_NOTAVAILABLE);
		}
	}
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if ( m_poclConfigInterface!= NULL )
	{
		if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_TEST_MODE_DATA,ERROR_NOTAVAILABLE);
		}
	}
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vSendStatus()
{
   vStatus(m_oMessage);
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vOnNewATHDTestModeStatus(clCMHDTestModeStatus &oData,unsigned char u8PhysicalTuner,unsigned char u8TransitionCount )
{
   m_oMessage.TunerHDTestModeData.sHDCallSign.bSet(oData.getHDCallSign(), midw_fi_tclString::FI_EN_ISO8859_1M);
   m_oMessage.TunerHDTestModeData.u32HDStationId = oData.getHDStationId();
   m_oMessage.TunerHDTestModeData.b8HDAvailableAudioPrograms.u8Value = oData.getAvailableAudioprograms();
   m_oMessage.TunerHDTestModeData.e8HDActiveAudioProgram.enType = (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType)oData.getActiveAudioprogram();
   m_oMessage.TunerHDTestModeData.u8AudioQuality = oData.getAudioQuality();
   m_oMessage.TunerHDTestModeData.b8HDStationInfoBits.u8Value = oData.getHDStationInfoBits();
   m_oMessage.TunerHDTestModeData.u8CD_NO = oData.getCD_N0();
   
   tun_FI_HelpFunc :: bConverttU8toEnumPhsicalTuner(u8PhysicalTuner,
                            m_oMessage.TunerHDTestModeData.e8PhysicalTuner.enType);
   m_oMessage.TunerHDTestModeData.u8TransitionCount = u8TransitionCount;
   vPrintTrace();
   vSendStatus();
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_TEST_MODE_DATA::vPrintTrace()
{
	ETG_TRACE_USR4(( "clTmcTuner_Property_G_HD_TEST_MODE_DATA::vOnNewATHDTestModeStatus()"
	"\ne8PhysicalTuner = %d, u32HDStationId = 0x%08x, b8HDAvailableAudioPrograms: 0x%02x, e8HDActiveAudioProgram = %d, u8AudioQuality = %d "
	"\nb8HDStationInfoBits = 0x%02x, u8CD_NO = %d, u8TransitionCount = %d, sHDCallSign = %s"
	,m_oMessage.TunerHDTestModeData.e8PhysicalTuner.enType 
	,m_oMessage.TunerHDTestModeData.u32HDStationId
	,m_oMessage.TunerHDTestModeData.b8HDAvailableAudioPrograms.u8Value 
	,m_oMessage.TunerHDTestModeData.e8HDActiveAudioProgram.enType
	,m_oMessage.TunerHDTestModeData.u8AudioQuality 
	,m_oMessage.TunerHDTestModeData.b8HDStationInfoBits.u8Value 
    ,m_oMessage.TunerHDTestModeData.u8CD_NO 
	,m_oMessage.TunerHDTestModeData.u8TransitionCount
	,m_oMessage.TunerHDTestModeData.sHDCallSign.szGet(midw_fi_tclString::FI_EN_UTF8)
   ));
}


