/************************************************************************
 * FILE:           clTmcTuner_Property_G_HD_SECTION_PARAMETER.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_HD_SECTION_PARAMETER.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_HD_SECTION_PARAMETER.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_EvaluationParameter.h"
#include "tuner_trace.h"
#include "kdsconfig/clConfigInterface.h"
#define ERROR_NOTAVAILABLE 0x000B

using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_HD_SECTION_PARAMETER.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_HD_SECTION_PARAMETER::~clTmcTuner_Property_G_HD_SECTION_PARAMETER()
{
	m_poEvaluationParameter = 0;
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_HD_SECTION_PARAMETER::clTmcTuner_Property_G_HD_SECTION_PARAMETER(clCCAhandler* poCCAhandler, clAars_CM_EvaluationParameter* poEvaluationParameter, clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SECTION_PARAMETER, poCCAhandler)
	 ,m_poEvaluationParameter(poEvaluationParameter)
	 ,m_poclConfigInterface(poclConfigInterface)
{

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_SECTION_PARAMETER::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if ( m_poclConfigInterface!= NULL )
	{
		if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
		{
			for(short u16ParameterId = 0; u16ParameterId <= HD_SECTION_PARAMETER_ID; u16ParameterId++)
				{
					m_poEvaluationParameter->vGetHDSectionParameter((unsigned short)u16ParameterId);
				}
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SECTION_PARAMETER,ERROR_NOTAVAILABLE);
		}
	}

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_SECTION_PARAMETER::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_SECTION_PARAMETER::vGet(amt_tclServiceData* poInMsg)
{
	ETG_TRACE_USR4(("clTmcTuner_Property_G_HD_SECTION_PARAMETER: Get"));
	if ( m_poclConfigInterface!= NULL )
	{
		if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
		{
			midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERGet oMessage;
			m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);
			m_poEvaluationParameter->vGetHDSectionParameter((unsigned short)oMessage.e16Parameter_ID.enType);
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_SECTION_PARAMETER,ERROR_NOTAVAILABLE);
		}
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_HD_SECTION_PARAMETER::vOnNewHDSectionParameterStatus(unsigned short u16ParameterID, char s8ParameterValue)
{
   midw_tunerfi_tclMsgFID_TUN_G_HD_SECTION_PARAMETERStatus oMessage;
   oMessage.e16Parameter_ID.enType = (midw_fi_tcl_e16_Tun_ParameterID::tenType)u16ParameterID;
   oMessage.s8ParameterValue = s8ParameterValue;


   ETG_TRACE_USR4(("clTmcTuner_Property_G_HD_SECTION_PARAMETER::vOnNewHDSectionParameterStatus : ParameterID = %d, Parameter Value = %d",oMessage.e16Parameter_ID.enType, oMessage.s8ParameterValue ));
   vStatus(oMessage);
}
