/************************************************************************
 * FILE:            clTmcTuner_Property_G_HD_LONGNAME.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_HD_LONGNAME.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_HD_LONGNAME.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATHDLongName.h"
#include "kdsconfig/clConfigInterface.h"

#define ERROR_NOTAVAILABLE 0x000B

using namespace tuner::CcaApp;


#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_G_HD_LONGNAME.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_HD_LONGNAME::~clTmcTuner_Property_G_HD_LONGNAME()
{
	m_poATHDLongName = NULL;
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_HD_LONGNAME::clTmcTuner_Property_G_HD_LONGNAME(clCCAhandler* poCCAhandler,clAars_ATHDLongName* poATHDLongName, clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_LONGNAME, poCCAhandler), m_poATHDLongName(poATHDLongName)
{
	m_poclConfigInterface = poclConfigInterface;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_LONGNAME::vSet(amt_tclServiceData* /*poInMsg*/)
{
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_LONGNAME::vGet(amt_tclServiceData* poInMsg)
{
	if(m_poclConfigInterface != NULL )
	{
		if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
		{
			ETG_TRACE_USR4(("clTmcTuner_Property_G_HD_LONGNAME: Get"));
			m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
			vSendATHDLongNameGetRequestToAars();
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_LONGNAME,ERROR_NOTAVAILABLE);
		}
	}
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_LONGNAME::vSendATHDLongNameGetRequestToAars()
{
	if(m_poATHDLongName != NULL)
	{
		m_poATHDLongName->vGetATHDLongName(m_oMessage.u32HDStationId,(unsigned char)m_oMessage.e8HDAudioProgram.enType);
	}
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_LONGNAME::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if(m_poclConfigInterface != NULL )
	{
		if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_HD_LONGNAME,ERROR_NOTAVAILABLE);
		}
	}
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_HD_LONGNAME::vOnNewATHDLongNameStatus(const unsigned int u32HDStationId,const unsigned char u8HDAudioProgram,const tunerString sATHDLongName )
{
   midw_tunerfi_tclMsgFID_TUN_G_HD_LONGNAMEStatus oMessage;
   oMessage.u32HDStationId = u32HDStationId;
   oMessage.e8HDAudioProgram.enType = (midw_fi_tcl_e8_Tun_HDAudioProgram::tenType)u8HDAudioProgram;
   oMessage.sHDLongName.bSet(sATHDLongName.c_str(), midw_fi_tclString::FI_EN_ISO8859_1M);  
   	ETG_TRACE_USR4(("clTmcTuner_Property_G_HD_LONGNAME: vOnNewATHDLongNameStatus: HDStationID = 0x%8x, u8AudioProgram = %d, sLongName = %s ",\
		oMessage.u32HDStationId 
		,(unsigned char)oMessage.e8HDAudioProgram.enType
		,oMessage.sHDLongName.szGet(midw_fi_tclString::FI_EN_ISO8859_1M)));
   vStatus(oMessage);
}
