/************************************************************************
 * FILE:           clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/


#ifndef clTmcTuner_Property_clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE_h
#define clTmcTuner_Property_clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "AMFMTuner/clHDImageMemoryManagement.h"

class clAars_ATHDImageFileUpdate;
class clConfigInterface;
#include "tun_MsgToHMI.h"
#include "tun_MsgFromHMI.h"

class clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE();
      clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE( tuner::CcaApp::clCCAhandler* poCCAhandler,clAars_ATHDImageFileUpdate* poATHDImageFileUpdate,
    		  tun_MsgToHMI* potun_MsgToHMI, clHDStationLogoManagement *poclHDStationLogoManagement , clConfigInterface* poclConfigInterface,
			  tun_MsgFromHMI* potun_MsgFromHMI);
	  virtual tVoid vOnNewATHDImageFileUpdateStatus(clCMATHDImageFileUpdateStatus &oImageFileData);
	  tVoid vOnNewPSDXHDRImageDisplayTrigger(unsigned char u8ActiveAudioProgram, \
		  unsigned short u16ActiveLOTID, unsigned long u32HDStationID);
	   tVoid vOnNewPSDXHDRBlankImageDisplayTrigger(unsigned char u8ActiveAudioProgram, \
			   unsigned long u32HDStationID, unsigned short u16ActiveLotID);
	   tVoid vOnNewPSDXHDRFlushImageTrigger(unsigned char u8ActiveAudioProgram, \
		  unsigned int u32ActiveStationID, unsigned int u32ActiveAudioProgramMIMEHash);
	  tVoid vClearData();
	  tVoid vSendBlankImageDisplayToClient();
	  midw_fi_tclString strGetActiveStationLogoPath(unsigned int u32HDStationId, unsigned char u8ActiveAudioProgram);

   protected:
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);

   private:
      /* Added the below constructor for the purpose of unit testing */
#ifdef VARIANT_P_RECEPTION_FC_TMCTUNER_UTEST
      clTmcTuner_Property_G_HD_IMAGEFILE_UPDATE(tuner::CcaApp::clCCAhandler* poCCAhandler);
#endif
	  clHDImageMemoryManagement oHDImageMemoryManagement;
	  clAars_ATHDImageFileUpdate* m_poATHDImageFileUpdate;
	  clCMATHDImageFileUpdateStatus m_ATHDImageFileLastSent;
      unsigned char m_u8ActiveAudioProgram;
	  unsigned short m_u16ActiveAudioProgramLOTID;
	  unsigned int m_u32ActiveHDStationID;
	  tun_MsgToHMI* m_potun_MsgToHMI;
	  clHDStationLogoManagement* m_poclHDStationLogoManagement;
	  clConfigInterface* m_poclConfigInterface;
	  tun_MsgFromHMI* m_potun_MsgFromHMI;

	  tVoid vSendStatus(tBool bDisplayImage, clCMATHDImageFileUpdateStatus& oImageFileData);
	  tBool bIsImageDataSameAsCurrentXHDRData(clCMATHDImageFileUpdateStatus& oImageFileData);
	  tBool bIsEqualImage(clCMATHDImageFileUpdateStatus& oData,unsigned char u8ActiveAudioProgram, \
		  unsigned short u16ActiveLOTID, unsigned int u32ActiveStationID);
	  tVoid vSendImageUpdateToClient(clCMATHDImageFileUpdateStatus& oImageFileData);
	  tVoid vPrintImageData(clCMATHDImageFileUpdateStatus& oImageFileData);
	  tBool bIsImageDataSameAsLastSentImage(clCMATHDImageFileUpdateStatus& oImageFileData);

};

#endif
